/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;

public class RoundedMatteBorder
extends AbstractBorder {
    private static final int DEF_DIAMETER = 10;
    private static final int DEF_INSET = 5;
    private final Color _color;
    private Insets _insets;
    private Insets _margin;

    public RoundedMatteBorder(int thickness, Color color) {
        this(thickness, thickness, thickness, thickness, 5, color);
    }

    public RoundedMatteBorder(int thickness, int marginThickness, Color color) {
        this(thickness, thickness, thickness, thickness, marginThickness, color);
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, Color color) {
        this(top, left, bottom, right, 5, color);
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, int marginThickness, Color color) {
        this(top, left, bottom, right, marginThickness, marginThickness, color);
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, int horzInset, int vertInset, Color color) {
        this(top, left, bottom, right, vertInset, horzInset, vertInset, horzInset, color);
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, int topInset, int leftInset, int bottomInset, int rightInset, Color color) {
        this._insets = new Insets(top, left, bottom, right);
        this._margin = new Insets(topInset, leftInset, bottomInset, rightInset);
        this._color = color;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int r = 10;
        g2.translate(x, y);
        g2.setColor(this._color);
        g2.fillRect(r / 2, 0, width - r - 1, this._insets.top);
        g2.fillRect(0, r / 2, this._insets.left, height - r - 1);
        g2.fillRect(r / 2, height - this._insets.bottom - 1, width - r - 1, this._insets.bottom);
        g2.fillRect(width - this._insets.right - 1, r / 2, this._insets.right, height - r - 1);
        RoundRectangle2D.Float round = new RoundRectangle2D.Float(0.0f, 0.0f, width - 1, height - 1, r, r);
        Container parent = c.getParent();
        if (parent != null) {
            g2.setColor(parent.getBackground());
            Area corner = new Area(new Rectangle2D.Float(0.0f, 0.0f, width, height));
            corner.subtract(new Area(round));
            g2.fill(corner);
        }
        BasicStroke stroke = new BasicStroke(1.0f);
        g2.setStroke(stroke);
        g2.setColor(this._color);
        g2.draw(new Arc2D.Double(0.0, 0.0, r, r, 90.0, 90.0, 0));
        g2.draw(new Arc2D.Double(width - r - 2, 0.0, r, r, 90.0, -90.0, 0));
        g2.draw(new Arc2D.Double(width - r - 2, height - r - 2, r, r, 0.0, -90.0, 0));
        g2.draw(new Arc2D.Double(0.0, height - r - 2, r, r, 180.0, 90.0, 0));
        g2.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this._margin;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.set(this._margin.top, this._margin.left, this._margin.bottom, this._margin.right);
        return insets;
    }
}

