/*
 * Decompiled with CFR 0.152.
 */
package editor.util.transform.java;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.SourcePositions;
import editor.util.transform.java.Wrap;
import editor.util.transform.java.visitor.GosuVisitor;
import gw.lang.javac.IJavaParser;
import gw.lang.parser.GosuParserFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;

public class JavaToGosu {
    public static String convertString(String javaSource, int ... indent) {
        Wrap[] wraps = new Wrap[]{new Wrap("", "", "", ""), new Wrap("class _JAVA_TO_GOSU_INTERNAL_ {", "\n}", "class _JAVA_TO_GOSU_INTERNAL_  {\n\n", "\n}\n"), new Wrap("class _JAVA_TO_GOSU_INTERNAL_ { void _JAVA_TO_GOSU_INTERNAL_METHOD_() {", "\n}}", "class _JAVA_TO_GOSU_INTERNAL_  {\n\n  function _JAVA_TO_GOSU_INTERNAL_METHOD_() : void {\n", "\n  }\n\n}\n"), new Wrap("class _JAVA_TO_GOSU_INTERNAL_ { void _JAVA_TO_GOSU_INTERNAL_METHOD_() {", ";\n}}", "class _JAVA_TO_GOSU_INTERNAL_  {\n\n  function _JAVA_TO_GOSU_INTERNAL_METHOD_() : void {\n", "\n  }\n\n}\n"), new Wrap("class _JAVA_TO_GOSU_INTERNAL_ { void _JAVA_TO_GOSU_INTERNAL_METHOD_() { if(", ");\n}}", "class _JAVA_TO_GOSU_INTERNAL_  {\n\n  function _JAVA_TO_GOSU_INTERNAL_METHOD_() : void {\n    if (", ") {\n      \n    }\n  }\n\n}\n")};
        String javaWrapStart = "";
        String javaWrapEnd = "";
        String gosuWrapStart = "";
        String gosuWrapEnd = "";
        ArrayList<CompilationUnitTree> trees = null;
        DocTrees[] docTrees = new DocTrees[]{null};
        boolean parsed = false;
        String src = null;
        for (int i = wraps.length - 1; i >= 0 && !parsed; --i) {
            javaWrapStart = wraps[i].JAVA_WRAP_START;
            javaWrapEnd = wraps[i].JAVA_WRAP_END;
            gosuWrapStart = wraps[i].GOSU_WRAP_START;
            gosuWrapEnd = wraps[i].GOSU_WRAP_END;
            trees = new ArrayList<CompilationUnitTree>();
            src = javaWrapStart + javaSource + javaWrapEnd;
            parsed = JavaToGosu.parseJava(trees, null, dc -> {
                docTrees[0] = dc;
            }, src);
        }
        if (!parsed) {
            return "";
        }
        GosuVisitor visitor = new GosuVisitor(indent == null || indent.length == 0 ? 2 : indent[0], docTrees[0]);
        for (CompilationUnitTree tree : trees) {
            tree.accept(visitor, null);
        }
        String output = visitor.getOutput().toString();
        if (!javaWrapStart.isEmpty()) {
            int b = output.indexOf(gosuWrapStart) + gosuWrapStart.length();
            int e = output.lastIndexOf(gosuWrapEnd);
            output = JavaToGosu.unIndent(output.substring(b, e));
        }
        return output;
    }

    private static String unIndent(String output) {
        int tab;
        StringBuilder src = new StringBuilder();
        String[] lines = output.split("\n");
        boolean leadingLines = true;
        ArrayList<String> removedEmptyLeadingLines = new ArrayList<String>();
        for (int index = 0; index < lines.length; ++index) {
            if (leadingLines && lines[index].trim().isEmpty()) continue;
            removedEmptyLeadingLines.add(lines[index]);
            leadingLines = false;
        }
        lines = removedEmptyLeadingLines.toArray(new String[removedEmptyLeadingLines.size()]);
        char[] chars = lines[0].toCharArray();
        for (tab = 0; tab < chars.length && chars[tab] == ' '; ++tab) {
        }
        for (String line : lines) {
            if (!line.trim().isEmpty()) {
                if (line.length() > tab && line.substring(0, tab).trim().isEmpty()) {
                    src.append(line.substring(tab));
                } else {
                    src.append(line);
                }
                src.append("\n");
                continue;
            }
            src.append("\n");
        }
        return src.toString();
    }

    private static boolean parseJava(List<CompilationUnitTree> trees, Consumer<SourcePositions> sourcePositions, Consumer<DocTrees> docTrees, String src) {
        DiagnosticCollector errorHandler;
        IJavaParser javaParser = (IJavaParser)GosuParserFactory.getInterface(IJavaParser.class);
        if (!javaParser.parseText(src, trees, sourcePositions, docTrees, errorHandler = new DiagnosticCollector())) {
            return false;
        }
        return !errorHandler.getDiagnostics().stream().anyMatch(e -> e.getKind() == Diagnostic.Kind.ERROR);
    }
}

