/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.Scheme;
import editor.util.ContainerMoverSizer;
import editor.util.ContainerSizer;
import editor.util.EditorUtilities;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public abstract class AbstractGotoPopup<T>
extends JPopupMenu {
    protected GenerifiedJList _list;
    protected JTextField _nameField;
    private EventListenerList _nodeListenerList = new EventListenerList();
    private boolean _bLocked;
    private EditorKeyListener _editorKeyListener;
    private UndoableEditListener _docListener;
    private DocumentListener _docListenerForEdits;
    private JScrollPane _scrollPane;
    private JCheckBox _cbExternalTypes;
    private final int _waitTime;
    private Timer _timer;
    private final int _rowCount;
    private final String _title;
    private List<T> _allData;
    private String _strPrefix;
    private final boolean _takesInput;
    private final boolean _centerInFrame;
    private Object _dataLock = new Object();
    private boolean _dataInitialized;
    private JLabel _spinner;
    private boolean _externalOption;

    public AbstractGotoPopup(int waitTime, int rowCount, String title, String strPrefix, boolean takesInput, boolean centerInFrame, boolean externalOption) {
        this._waitTime = waitTime;
        this._timer = new Timer();
        this._rowCount = rowCount;
        this._title = title;
        this._strPrefix = strPrefix;
        this._takesInput = takesInput;
        this._centerInFrame = centerInFrame;
        this._externalOption = externalOption;
        this.initLayout();
    }

    private void initLayout() {
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        GridBagLayout gridBag = new GridBagLayout();
        JPanel pane = new JPanel();
        pane.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        CompoundBorder border = BorderFactory.createCompoundBorder(UIManager.getBorder("PopupMenu.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ContainerMoverSizer content = new ContainerMoverSizer(border);
        content.setLayout(new BorderLayout());
        this._cbExternalTypes = new JCheckBox("Include external types");
        this.initializeDataInWaitMode();
        int iY = 0;
        JLabel labelName = new JLabel(this._title);
        labelName.setOpaque(true);
        labelName.setBackground(Scheme.active().getControl());
        labelName.setFont(labelName.getFont().deriveFont(1));
        labelName.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        pane.add((Component)labelName, c);
        if (this._externalOption) {
            this._cbExternalTypes.setBackground(Scheme.active().getControl());
            this._cbExternalTypes.setMnemonic('n');
            this._cbExternalTypes.addItemListener(e -> {
                this.initializeDataInWaitMode();
                this.handleEdit();
            });
            c.anchor = 17;
            c.fill = 2;
            c.gridx = 1;
            c.gridy = iY - 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            pane.add((Component)this._cbExternalTypes, c);
        }
        if (this._takesInput) {
            this._nameField = new JTextField(32);
            c.anchor = 17;
            c.fill = 2;
            c.gridx = 0;
            c.gridy = iY++;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(2, 0, 2, 0);
            pane.add((Component)this._nameField, c);
        }
        this._scrollPane = new JScrollPane();
        this._list = new GenerifiedJList(new DefaultListModel()){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dim = super.getPreferredScrollableViewportSize();
                int iScreenWidth = this.getToolkit().getScreenSize().width;
                if (dim.width > iScreenWidth / 3) {
                    dim.width = iScreenWidth / 3;
                }
                return dim;
            }
        };
        this._scrollPane.setViewportView(this._list);
        this._scrollPane.setVisible(false);
        this._list.addMouseListener(new PopupMouseListener());
        this._list.setCellRenderer(this.constructCellRenderer());
        this._list.setFixedCellHeight(22);
        this._list.getSelectionModel().setSelectionMode(0);
        this._list.setVisibleRowCount(this._rowCount);
        this._scrollPane.setBorder(UIManager.getBorder("TextField.border"));
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        pane.add((Component)this._scrollPane, c);
        this._spinner = new JLabel(EditorUtilities.loadIcon("images/wait.gif"));
        this._spinner.setBorder(UIManager.getBorder("TextField.border"));
        this._spinner.setBackground(Scheme.active().getWindow());
        this._spinner.setOpaque(true);
        this._spinner.setVisible(false);
        c.gridy = iY;
        pane.add((Component)this._spinner, c);
        content.add((Component)pane, "Center");
        JPanel sizerPanel = new JPanel(new BorderLayout());
        sizerPanel.add((Component)new JPanel(), "Center");
        sizerPanel.add((Component)new ContainerSizer(), "East");
        content.add((Component)sizerPanel, "South");
        this._editorKeyListener = new EditorKeyListener();
        this.add(content);
        this._docListener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                AbstractGotoPopup.this.resetTimer();
            }
        };
        this._docListenerForEdits = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractGotoPopup.this.resetTimer();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractGotoPopup.this.resetTimer();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractGotoPopup.this.resetTimer();
            }
        };
        if (this._strPrefix != null) {
            this.filterDisplay(this._strPrefix, false);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AbstractGotoPopup.this._takesInput) {
                    AbstractGotoPopup.this._nameField.requestFocus();
                } else {
                    AbstractGotoPopup.this._list.requestFocus();
                }
            }
        });
    }

    JTextField getNameField() {
        return this._nameField;
    }

    GenerifiedJList getList() {
        return this._list;
    }

    protected abstract ListCellRenderer constructCellRenderer();

    protected abstract void handleEdit();

    protected boolean isExternalTypes() {
        return this._cbExternalTypes.isSelected();
    }

    private void initializeDataInWaitMode() {
        EditorUtilities.doBackgroundOp(() -> {
            try {
                this._allData = this.initializeData();
            }
            finally {
                this._dataInitialized = true;
                Object object = this._dataLock;
                synchronized (object) {
                    this._dataLock.notifyAll();
                }
                SwingUtilities.invokeLater(() -> this._spinner.setVisible(false));
            }
        });
    }

    protected abstract List<T> initializeData();

    protected abstract AbstractPopupListModel<T> reconstructModel(String var1);

    @Override
    public final void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        if (bVisible) {
            this.registerListeners();
            EditorUtilities.removePopupBorder(this);
            this.turnOnMnemonics();
        } else {
            this.unregisterListeners();
            if (this._takesInput) {
                this._nameField.requestFocus();
            }
            this.turnOffMnemonics();
        }
    }

    private void turnOnMnemonics() {
        UIManager.getDefaults().put("Button.showMnemonics", (Object)true);
        EventQueue.invokeLater(() -> UIManager.getDefaults().put("Button.showMnemonics", (Object)false));
    }

    private void turnOffMnemonics() {
        try {
            Robot robot = new Robot();
            robot.keyPress(18);
            robot.keyRelease(18);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    private void registerListeners() {
        this.unregisterListeners();
        if (this._takesInput) {
            this._nameField.addKeyListener(this._editorKeyListener);
            this._nameField.getDocument().addUndoableEditListener(this._docListener);
            this._nameField.getDocument().addDocumentListener(this._docListenerForEdits);
        } else {
            this._list.addKeyListener(this._editorKeyListener);
        }
    }

    private void unregisterListeners() {
        if (this._takesInput) {
            this._nameField.getDocument().removeDocumentListener(this._docListenerForEdits);
            this._timer.cancel();
            this._nameField.getDocument().removeUndoableEditListener(this._docListener);
            this._nameField.removeKeyListener(this._editorKeyListener);
        } else {
            this._list.removeKeyListener(this._editorKeyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void filterDisplay(final String prefix, boolean showSpinner) {
        if (showSpinner) {
            Object object = this._dataLock;
            synchronized (object) {
                if (!this._dataInitialized) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractGotoPopup.this._spinner.setVisible(true);
                            AbstractGotoPopup.this.pack();
                            AbstractGotoPopup.this._nameField.requestFocus();
                        }
                    });
                }
            }
        }
        if (this._takesInput) {
            EditorUtilities.doBackgroundOp(new Runnable(){

                @Override
                public void run() {
                    final AbstractPopupListModel model = AbstractGotoPopup.this.reconstructModel(prefix);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractGotoPopup.this.filterSynchronously(model);
                        }
                    });
                }
            });
        } else {
            AbstractPopupListModel<T> model = this.reconstructModel(prefix);
            this.filterSynchronously(model);
        }
    }

    private void filterSynchronously(AbstractListModel model) {
        this._list.setModel(model);
        this._list.setSelectedIndex(0);
        int iListCount = this._list.getModel().getSize();
        this._list.setVisibleRowCount(Math.min(iListCount, this._rowCount));
        this._scrollPane.setVisible(iListCount > 0);
        this._list.revalidate();
        this._list.repaint();
        this.pack();
        if (this._takesInput) {
            this._nameField.requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractGotoPopup.this._nameField.requestFocus();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void show(Component invoker, int iX, int iY) {
        this._bLocked = true;
        try {
            super.show(invoker, iX, iY);
            if (this._centerInFrame) {
                EditorUtilities.centerWindowInFrame(this, KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow());
            }
        }
        finally {
            this._bLocked = false;
        }
    }

    public final void addNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.add(ChangeListener.class, l);
    }

    public final void removeNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.remove(ChangeListener.class, l);
    }

    public void setSelection(String strSelection) {
        List<String> suggestionNames = this.getPopupSuggestions();
        for (int currentIndex = 0; currentIndex < suggestionNames.size(); ++currentIndex) {
            if (!suggestionNames.get(currentIndex).equals(strSelection)) continue;
            this._list.setSelectedIndex(currentIndex);
            break;
        }
    }

    public List<String> getPopupSuggestions() {
        ListModel popupModel = this._list.getModel();
        ArrayList<String> suggestionNames = new ArrayList<String>();
        for (int i = 0; i < popupModel.getSize(); ++i) {
            suggestionNames.add(popupModel.getElementAt(i).toString());
        }
        return suggestionNames;
    }

    private void fireNodeChanged(final EventListenerList list, final ChangeEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractGotoPopup.this.fireNodeChangedNow(list, e);
            }
        });
    }

    private void fireNodeChangedNow(EventListenerList list, ChangeEvent e) {
        Object[] listeners = list.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> getInitializedAllData() {
        Object object = this._dataLock;
        synchronized (object) {
            if (!this._dataInitialized) {
                try {
                    this._dataLock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this._allData;
    }

    private void resetTimer() {
        DisplayListTimerTask timerTask = new DisplayListTimerTask();
        if (this._waitTime > 0) {
            this._timer.cancel();
            this._timer = new Timer();
            this._timer.schedule((TimerTask)timerTask, this._waitTime);
        } else {
            timerTask.run();
        }
    }

    private class DisplayListTimerTask
    extends TimerTask {
        private DisplayListTimerTask() {
        }

        @Override
        public void run() {
            AbstractGotoPopup.this.handleEdit();
        }
    }

    protected abstract class GenerifiedJList
    extends JList {
        protected GenerifiedJList(ListModel dataModel) {
            super(dataModel);
        }

        protected GenerifiedJList(T[] listData) {
            super(listData);
        }

        public T getSelectedValue() {
            return super.getSelectedValue();
        }
    }

    public static abstract class AbstractPopupListModel<T>
    extends AbstractListModel {
        @Override
        public abstract T getElementAt(int var1);
    }

    private class PopupMouseListener
    extends MouseAdapter {
        private PopupMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (AbstractGotoPopup.this._bLocked) {
                return;
            }
            int iIndex = AbstractGotoPopup.this._list.locationToIndex(e.getPoint());
            if (iIndex < 0) {
                return;
            }
            AbstractGotoPopup.this._list.setSelectedIndex(iIndex);
            Object datum = AbstractGotoPopup.this._list.getSelectedValue();
            AbstractGotoPopup.this.fireNodeChanged(AbstractGotoPopup.this._nodeListenerList, new ChangeEvent(datum));
            AbstractGotoPopup.this.setVisible(false);
        }
    }

    class EditorKeyListener
    extends KeyAdapter {
        EditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isAltDown()) {
                if (e.getKeyChar() == 'n') {
                    AbstractGotoPopup.this._cbExternalTypes.setSelected(!AbstractGotoPopup.this._cbExternalTypes.isSelected());
                }
            } else if (e.getKeyCode() == 38 || e.getKeyCode() == 224) {
                Action selectPrevious = AbstractGotoPopup.this._list.getActionMap().get("selectPreviousRow");
                selectPrevious.actionPerformed(new ActionEvent(AbstractGotoPopup.this._list, 0, "selectPreviousRow"));
            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
                Action selectNext = AbstractGotoPopup.this._list.getActionMap().get("selectNextRow");
                selectNext.actionPerformed(new ActionEvent(AbstractGotoPopup.this._list, 0, "selectNextRow"));
            } else if (e.getKeyCode() == 33) {
                Action scrollUpChangeSelection = AbstractGotoPopup.this._list.getActionMap().get("scrollUp");
                scrollUpChangeSelection.actionPerformed(new ActionEvent(AbstractGotoPopup.this._list, 0, "scrollUp"));
            } else if (e.getKeyCode() == 34) {
                Action scrollDownChangeSelection = AbstractGotoPopup.this._list.getActionMap().get("scrollDown");
                scrollDownChangeSelection.actionPerformed(new ActionEvent(AbstractGotoPopup.this._list, 0, "scrollDown"));
            } else if (e.getKeyCode() == 10) {
                Object datum = AbstractGotoPopup.this._list.getSelectedValue();
                if (datum != null) {
                    AbstractGotoPopup.this.fireNodeChanged(AbstractGotoPopup.this._nodeListenerList, new ChangeEvent(datum));
                }
                AbstractGotoPopup.this.setVisible(false);
            } else if (e.getKeyCode() == 27) {
                AbstractGotoPopup.this.setVisible(false);
            } else {
                return;
            }
            e.consume();
        }
    }
}

