/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.SourceFileAttribute;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuProgram;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;

public class BatchDocument
extends DefaultStyledDocument {
    public static final char[] EOL_ARRAY = new char[]{'\n'};
    private final List<DefaultStyledDocument.ElementSpec> _batch = new ArrayList<DefaultStyledDocument.ElementSpec>();

    public void appendString(String str, AttributeSet a) {
        this.processInserts(this.getElementsForString(str, a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendBatchString(String str, AttributeSet a) {
        List<DefaultStyledDocument.ElementSpec> list = this._batch;
        synchronized (list) {
            this._batch.addAll(this.getElementsForString(str, a));
            while (this._batch.size() > 102400) {
                this._batch.remove(0);
            }
        }
    }

    private List<DefaultStyledDocument.ElementSpec> getElementsForString(String str, AttributeSet a) {
        if (str.length() > 0) {
            boolean bBytecodeDump = str.startsWith("// class version ") && str.contains("// access flags");
            ArrayList<DefaultStyledDocument.ElementSpec> ret = new ArrayList<DefaultStyledDocument.ElementSpec>();
            SimpleAttributeSet bytecodeDumpColor = new SimpleAttributeSet();
            bytecodeDumpColor.addAttribute(StyleConstants.Foreground, new Color(92, 225, 92));
            StringTokenizer t = new StringTokenizer(str, "\r\n", true);
            while (t.hasMoreTokens()) {
                String s = t.nextToken();
                if (s.equals("\n")) {
                    ret.addAll(this.getElementsForLineFeed(a));
                    continue;
                }
                if (bBytecodeDump) {
                    ret.add(new DefaultStyledDocument.ElementSpec(bytecodeDumpColor, 3, s.toCharArray(), 0, s.length()));
                    continue;
                }
                ret.addAll(this._getElementsForString(s, a));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    private Collection<? extends DefaultStyledDocument.ElementSpec> _getElementsForString(String str, AttributeSet a) {
        a = a.copyAttributes();
        char[] chars = str.toCharArray();
        ArrayList<DefaultStyledDocument.ElementSpec> ret = new ArrayList<DefaultStyledDocument.ElementSpec>();
        if (!this.handleStackTraceLink(str, ret, a) && !this.handleTestResults(str, ret, a)) {
            ret.add(new DefaultStyledDocument.ElementSpec(a, 3, chars, 0, str.length()));
        }
        return ret;
    }

    private boolean handleStackTraceLink(String str, List<DefaultStyledDocument.ElementSpec> ret, AttributeSet a) {
        if (str.trim().startsWith("at ") && str.contains("(") && str.contains(".gs") && str.contains(":")) {
            int iParen = str.indexOf("(");
            int iDot = str.indexOf(46, iParen);
            String name = str.substring(iParen + 1, iDot);
            int iAt = str.indexOf("at");
            int iName = str.lastIndexOf("." + name);
            String fqn = null;
            if (iName >= 0) {
                fqn = str.substring(iAt + 3, iName + name.length() + 1);
            } else {
                IType contextType;
                String rawFqnPlusMethodName = str.substring(iAt + 3, str.indexOf(40));
                String rawFqn = rawFqnPlusMethodName.substring(0, rawFqnPlusMethodName.lastIndexOf(46));
                IType rawType = TypeSystem.getByFullNameIfValid((String)rawFqn);
                if (rawType instanceof IGosuProgram && (contextType = ((IGosuProgram)rawType).getContextType()) != null) {
                    fqn = contextType.getName();
                }
                if (fqn == null) {
                    return false;
                }
            }
            int iLine = str.indexOf(58);
            String strLine = "";
            int iDigit = iLine + 1;
            while (Character.isDigit(str.charAt(iDigit))) {
                char c = str.charAt(iDigit);
                strLine = strLine + c;
                ++iDigit;
            }
            int line = strLine.length() > 0 ? Integer.parseInt(strLine) : -1;
            String firstPart = str.substring(0, iParen + 1);
            ret.add(new DefaultStyledDocument.ElementSpec(a, 3, firstPart.toCharArray(), 0, firstPart.length()));
            SimpleAttributeSet newAttr = new SimpleAttributeSet();
            newAttr.addAttribute(HTML.Tag.A, new SourceFileAttribute(line, fqn));
            newAttr.addAttribute(StyleConstants.Foreground, new Color(150, 150, 255));
            String link = str.substring(iParen + 1, str.length() - 1);
            ret.add(new DefaultStyledDocument.ElementSpec(newAttr, 3, link.toCharArray(), 0, link.length()));
            String lastPart = ")";
            ret.add(new DefaultStyledDocument.ElementSpec(a, 3, lastPart.toCharArray(), 0, 1));
            return true;
        }
        return false;
    }

    private boolean handleTestResults(String str, List<DefaultStyledDocument.ElementSpec> ret, AttributeSet a) {
        if (str.equals("  SUCCESS ")) {
            SimpleAttributeSet newAttr = new SimpleAttributeSet();
            newAttr.addAttribute(StyleConstants.Foreground, new Color(90, 220, 90));
            ret.add(new DefaultStyledDocument.ElementSpec(newAttr, 3, str.toCharArray(), 0, str.length()));
            return true;
        }
        if (str.startsWith("  FAILED: ") && str.contains(" : ")) {
            SimpleAttributeSet newAttr = new SimpleAttributeSet();
            newAttr.addAttribute(StyleConstants.Foreground, new Color(240, 90, 90));
            ret.add(new DefaultStyledDocument.ElementSpec(newAttr, 3, "  FAILED: ".toCharArray(), 0, "  FAILED: ".length()));
            String theRest = str.substring("  FAILED: ".length());
            ret.add(new DefaultStyledDocument.ElementSpec(a, 3, theRest.toCharArray(), 0, theRest.length()));
            return true;
        }
        return false;
    }

    public List<DefaultStyledDocument.ElementSpec> getElementsForLineFeed(AttributeSet a) {
        ArrayList<DefaultStyledDocument.ElementSpec> ret = new ArrayList<DefaultStyledDocument.ElementSpec>(3);
        ret.add(new DefaultStyledDocument.ElementSpec(a, 3, EOL_ARRAY, 0, 1));
        Element paragraph = this.getParagraphElement(0);
        AttributeSet pattr = paragraph.getAttributes();
        ret.add(new DefaultStyledDocument.ElementSpec(null, 2));
        ret.add(new DefaultStyledDocument.ElementSpec(pattr, 1));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBatchUpdates() {
        List<DefaultStyledDocument.ElementSpec> list = this._batch;
        synchronized (list) {
            this.processInserts(this._batch);
            this._batch.clear();
        }
    }

    private void processInserts(List<DefaultStyledDocument.ElementSpec> insertsList) {
        if (!insertsList.isEmpty()) {
            this.ensureEndStartTagsPrecedeInserts(insertsList);
            DefaultStyledDocument.ElementSpec[] inserts = new DefaultStyledDocument.ElementSpec[insertsList.size()];
            insertsList.toArray(inserts);
            try {
                super.insert(this.getLength(), inserts);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void ensureEndStartTagsPrecedeInserts(List<DefaultStyledDocument.ElementSpec> insertsList) {
        Element paragraph = this.getParagraphElement(0);
        AttributeSet pattr = paragraph.getAttributes();
        insertsList.add(0, new DefaultStyledDocument.ElementSpec(pattr, 1));
        insertsList.add(0, new DefaultStyledDocument.ElementSpec(null, 2));
    }
}

