/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BeanInfoNode;
import editor.BeanTree;
import editor.EditorBasedPopup;
import editor.GosuEditor;
import editor.ISelectionPopup;
import editor.MethodNode;
import editor.PropertyNode;
import editor.Scheme;
import editor.util.ContainerMoverSizer;
import editor.util.ContainerSizer;
import editor.util.EditorUtilities;
import editor.util.TextComponentUtil;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbol;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.util.IFeatureFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class BeanInfoPopup
extends EditorBasedPopup
implements ISelectionPopup {
    private JTree _tree;
    private EventListenerList _nodeListenerList = new EventListenerList();
    private boolean _bLocked;
    IType[] _classes;
    private boolean _bShowBeanRoots;
    EditorKeyListener _editorKeyListener;
    private UndoableEditListener _docListener;
    private int _iInitialCaretPos;
    private boolean _bConstrainByLastPathElement;
    private String _strCompleteCodePrefix;
    String _strMemberPath;
    private boolean _bDOA;
    private IFeatureFilter _filter;
    private boolean _bExpansion;
    private boolean _bForFeatureLiteral;

    public BeanInfoPopup(IType classBean, String strMemberPath, GosuEditor editor) throws ParseException {
        this(classBean, strMemberPath, false, editor, null);
    }

    public BeanInfoPopup(IType classBean, String strMemberPath, boolean bConstrainByLastPathElement, GosuEditor editor, IFeatureFilter filter) throws ParseException {
        this(classBean, strMemberPath, bConstrainByLastPathElement, editor, filter, false);
    }

    public BeanInfoPopup(IType classBean, String strMemberPath, boolean bConstrainByLastPathElement, GosuEditor editor, IFeatureFilter filter, boolean bExpansion) throws ParseException {
        this(classBean, strMemberPath, bConstrainByLastPathElement, editor, filter, bExpansion, false);
    }

    public BeanInfoPopup(IType classBean, String strMemberPath, boolean bConstrainByLastPathElement, GosuEditor editor, IFeatureFilter filter, boolean bExpansion, boolean bForFeatureLiteral) throws ParseException {
        super(editor);
        this._bConstrainByLastPathElement = bConstrainByLastPathElement;
        this._strMemberPath = strMemberPath;
        this._filter = filter;
        this._bExpansion = bExpansion;
        this._bForFeatureLiteral = bForFeatureLiteral;
        this._strCompleteCodePrefix = !this.isMemberPathEmpty(strMemberPath) ? strMemberPath : null;
        this.initLayout(new IType[]{classBean}, false);
    }

    private boolean isMemberPathEmpty(String strMemberPath) {
        return strMemberPath == null || strMemberPath.length() == 0 || strMemberPath.equalsIgnoreCase(".") || strMemberPath.equalsIgnoreCase("#");
    }

    public boolean isForFeatureLiteral() {
        return this._bForFeatureLiteral;
    }

    public void setForFeatureLiteral(boolean bForFeatureLiteral) {
        this._bForFeatureLiteral = bForFeatureLiteral;
    }

    private IType getWhosAskin() {
        IScriptPartId scriptPart = this.getEditor().getScriptPart();
        if (scriptPart != null) {
            return scriptPart.getContainingType();
        }
        return null;
    }

    public IType[] getClasses() {
        return this._classes;
    }

    public IType getRootOfTree() {
        BeanTree beanTree = (BeanTree)this._tree.getModel().getRoot();
        return beanTree.getBeanNode().getType();
    }

    public Boolean isForStaticAccess() {
        if (this.isForFeatureLiteral()) {
            return null;
        }
        return false;
    }

    public boolean isDOA() {
        return this._bDOA;
    }

    private void setDOA(boolean bDOA) {
        this._bDOA = bDOA;
    }

    public IFeatureFilter getFeatureInfoFilter() {
        return this._filter;
    }

    protected void initLayout(IType[] classBeans, final boolean bShowBeanRoots) {
        this._iInitialCaretPos = this.getEditor().getEditor().getCaretPosition();
        boolean bFilterRootBeans = false;
        if (classBeans == null || classBeans.length == 0 || classBeans.length == 1 && classBeans[0] == null) {
            classBeans = this.getAllBeans();
            bFilterRootBeans = true;
        }
        this._classes = classBeans;
        this._bShowBeanRoots = bShowBeanRoots;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        CompoundBorder border = BorderFactory.createCompoundBorder(UIManager.getBorder("PopupMenu.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ContainerMoverSizer content = new ContainerMoverSizer(border);
        content.setLayout(new BorderLayout());
        JPanel pane = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        pane.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        int iY = 0;
        if (this._classes.length == 1) {
            JLabel labelTypeName = new JLabel(TypeSystem.getGenericRelativeName((IType)this._classes[0], (boolean)true));
            labelTypeName.setOpaque(true);
            labelTypeName.setBackground(Scheme.active().getControl());
            labelTypeName.setFont(labelTypeName.getFont().deriveFont(1));
            labelTypeName.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
            c.anchor = 17;
            c.fill = 2;
            c.gridx = 0;
            c.gridy = iY++;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            pane.add((Component)labelTypeName, c);
        }
        BeanTree beanTree = !bShowBeanRoots && classBeans.length == 1 ? new BeanTree(classBeans[0], this.getWhosAskin(), "", false, this.isForStaticAccess(), this._filter, this._bExpansion) : (classBeans.length == 1 ? new BeanTree(classBeans, this.getWhosAskin(), false, this.isForStaticAccess()) : new BeanTree(classBeans, this.getWhosAskin()));
        this._tree = new JTree(new DefaultTreeModel(beanTree)){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dim = super.getPreferredScrollableViewportSize();
                dim.width = dim.width * (bShowBeanRoots ? 3 : 1);
                dim.width = Math.min(dim.width, 480);
                dim.height = dim.height * (bShowBeanRoots ? 2 : 1);
                return dim;
            }

            @Override
            public boolean isFocusable() {
                return false;
            }
        };
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.addMouseListener(new BeanTreeListener());
        this._tree.setCellRenderer(new BeanTreeCellRenderer(this._tree));
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setSelectionRow(0);
        this._tree.setRowHeight(20);
        this._tree.setVisibleRowCount(10);
        this._tree.getActionMap().put("scrollUpChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectionRows = BeanInfoPopup.this._tree.getSelectionRows();
                if (selectionRows != null) {
                    int selectionRow = selectionRows[0];
                    selectionRow = Math.max(0, selectionRow - 10);
                    BeanInfoPopup.this._tree.setSelectionRow(selectionRow);
                    BeanInfoPopup.this._tree.scrollRowToVisible(selectionRow);
                }
            }
        });
        this._tree.getActionMap().put("scrollDownChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectionRows = BeanInfoPopup.this._tree.getSelectionRows();
                if (selectionRows != null) {
                    int selectionRow = selectionRows[0];
                    selectionRow = Math.min(BeanInfoPopup.this._tree.getRowCount() - 1, selectionRow + 10);
                    BeanInfoPopup.this._tree.setSelectionRow(selectionRow);
                    BeanInfoPopup.this._tree.scrollRowToVisible(selectionRow);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this._tree);
        scrollPane.setBorder(UIManager.getBorder("TextField.border"));
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        pane.add((Component)scrollPane, c);
        this._editorKeyListener = new EditorKeyListener();
        this._docListener = e -> this.filterDisplay();
        content.add((Component)pane, "Center");
        JPanel sizerPanel = new JPanel(new BorderLayout());
        sizerPanel.add((Component)new JPanel(), "Center");
        sizerPanel.add((Component)new ContainerSizer(), "East");
        content.add((Component)sizerPanel, "South");
        if (this._strCompleteCodePrefix != null) {
            this.filterDisplay(bFilterRootBeans);
            if (this._tree.getModel().getChildCount(this._tree.getModel().getRoot()) == 0) {
                this._tree.setModel(new DefaultTreeModel(beanTree));
                this._tree.setSelectionRow(0);
                this._tree.revalidate();
                this._tree.repaint();
            }
        }
        this.add((Component)content, "Center");
    }

    private IType[] getAllBeans() {
        ArrayList<IType> beans = new ArrayList<IType>();
        Collection list = this.getEditor().getSymbolTable().getSymbols().values();
        for (ISymbol sym : list) {
            if (!TypeSystem.isBeanType((IType)sym.getType())) continue;
            beans.add(sym.getType());
        }
        return beans.toArray(new IType[beans.size()]);
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        if (bVisible) {
            this.registerListeners();
            EditorUtilities.removePopupBorder(this);
        } else {
            this.unregisterListeners();
            this.getEditor().getEditor().requestFocus();
        }
    }

    @Override
    public void setSelection(String strMember) {
        this.setSelection(strMember, false);
    }

    public void setSelection(String strMember, boolean bSilent) {
        if (strMember == null) {
            return;
        }
        strMember = strMember.toLowerCase();
        BeanTree root = (BeanTree)this._tree.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            BeanTree child = (BeanTree)root.getChildAt(i);
            BeanInfoNode node = child.getBeanNode();
            String strNodeName = node.getName().toLowerCase();
            if (!strNodeName.startsWith(strMember + (node instanceof MethodNode ? "(" : ""))) continue;
            TreePath path = new TreePath(new BeanTree[]{root, child});
            this._tree.setSelectionPath(path);
            this._tree.scrollPathToVisible(path);
            if (!bSilent) {
                this._editorKeyListener.handleSelection();
            }
            return;
        }
    }

    @Override
    public List<String> getPopupSuggestions() {
        ArrayList<String> suggestionNames = new ArrayList<String>();
        BeanTree root = (BeanTree)this._tree.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            BeanTree child = (BeanTree)root.getChildAt(i);
            BeanInfoNode node = child.getBeanNode();
            String strNodeName = node.getName().toLowerCase();
            suggestionNames.add(strNodeName);
        }
        return suggestionNames;
    }

    void registerListeners() {
        this.unregisterListeners();
        this.getEditor().getEditor().addKeyListener(this._editorKeyListener);
        this.getEditor().getEditor().getDocument().addUndoableEditListener(this._docListener);
    }

    void unregisterListeners() {
        this.getEditor().getEditor().getDocument().removeUndoableEditListener(this._docListener);
        this.getEditor().getEditor().removeKeyListener(this._editorKeyListener);
    }

    void filterDisplay() {
        this.getEditor().setCompleteCode(true);
        GosuEditor.postTaskInParserThread(() -> {
            if (this.getEditor().isCompleteCode()) {
                try {
                    this.filterDisplay(false);
                }
                finally {
                    this.getEditor().setCompleteCode(false);
                }
            }
        });
    }

    void filterDisplay(boolean bFilterRootBeans) {
        if (this._bShowBeanRoots) {
            return;
        }
        String strWholePath = TextComponentUtil.getPartialWordBeforeCaret(this.getEditor().getEditor());
        if (this.isOutOfScope()) {
            this.setDOA(true);
            this.setVisible(false);
            return;
        }
        String strPrefix = strWholePath;
        if (strWholePath != null && strWholePath.length() > 0) {
            int iDotIndex = strWholePath.lastIndexOf(46);
            if (iDotIndex < 0) {
                iDotIndex = strWholePath.lastIndexOf(35);
            }
            if (iDotIndex >= 0) {
                strPrefix = strWholePath.substring(iDotIndex + 1);
            }
        }
        if (this.endsWithInvalidChar(strPrefix)) {
            this.setVisible(false);
            return;
        }
        BeanTree beanTree = null;
        if (this._classes.length > 1 || bFilterRootBeans) {
            for (IType aClass : this._classes) {
                String strClass = TypeSystem.getUnqualifiedClassName((IType)aClass);
                ArrayList<IType> classList = new ArrayList<IType>();
                if (!this.shouldFilterClass(strClass, strPrefix)) {
                    classList.add(aClass);
                }
                beanTree = new BeanTree(classList.toArray(new IType[classList.size()]), this.getWhosAskin());
            }
        } else {
            beanTree = new BeanTree(this._classes[0], this.getWhosAskin(), "", strPrefix, this.isForStaticAccess(), this._filter, this._bExpansion);
        }
        BeanTree beanTree1 = beanTree;
        SwingUtilities.invokeLater(() -> {
            this._tree.setModel(new DefaultTreeModel(beanTree1));
            this._tree.setSelectionRow(0);
            this._tree.revalidate();
            this._tree.repaint();
        });
    }

    private boolean shouldFilterClass(String strClass, String strPrefix) {
        if (strPrefix != null && strPrefix.length() > 0 && Character.isJavaIdentifierStart(strPrefix.charAt(0))) {
            return !strClass.toLowerCase().startsWith(strPrefix.toLowerCase());
        }
        return false;
    }

    boolean isOutOfScope() {
        return !this._bConstrainByLastPathElement && this.getEditor().getEditor().getCaretPosition() <= this._iInitialCaretPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show(Component invoker, int iX, int iY) {
        this._bLocked = true;
        try {
            BeanTree root = (BeanTree)this._tree.getModel().getRoot();
            if (root == null || root.getChildCount() == 0) {
                return;
            }
            if (root.getChildCount() == 1) {
                TreePath path = this._tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                BeanTree tree = (BeanTree)path.getLastPathComponent();
                String strBeanNodeName = tree.getBeanNode().getName();
                int iIndexParen = strBeanNodeName.indexOf(40);
                if (iIndexParen > 0) {
                    strBeanNodeName = strBeanNodeName.substring(0, iIndexParen);
                }
                String strWordAtCaret = TextComponentUtil.getWordAtCaret(this.getEditor().getEditor());
                if (this._strCompleteCodePrefix != null && !this._strCompleteCodePrefix.equalsIgnoreCase(strBeanNodeName) && !this._strCompleteCodePrefix.equalsIgnoreCase(strWordAtCaret)) {
                    this.setReplaceWholeWord(true);
                    this.fireNodeChanged(this._nodeListenerList, new ChangeEvent(tree));
                    return;
                }
            }
            super.show(invoker, iX, iY);
        }
        finally {
            this._bLocked = false;
        }
    }

    @Override
    public void addNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.add(ChangeListener.class, l);
    }

    public void removeNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.remove(ChangeListener.class, l);
    }

    public boolean isModelEmpty() {
        BeanTree root = (BeanTree)this._tree.getModel().getRoot();
        return root == null || root.getChildCount() == 0;
    }

    protected void fireNodeChanged(EventListenerList list, ChangeEvent e) {
        EventQueue.invokeLater(() -> this.fireNodeChangedNow(list, e));
    }

    protected void fireNodeChangedNow(EventListenerList list, ChangeEvent e) {
        Object[] listeners = list.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    static class BeanTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private JTree _tree;
        protected boolean _bSelected;
        protected BeanTree _node;

        public BeanTreeCellRenderer(JTree tree) {
            this._tree = tree;
        }

        @Override
        public synchronized Component getTreeCellRendererComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
            if (value instanceof BeanTree) {
                this._node = (BeanTree)value;
                this._bSelected = bSelected;
                this.configure();
            }
            return this;
        }

        public void update() {
            this._tree.repaint();
        }

        public void configure() {
            ImageIcon icon;
            if (this._node == null) {
                return;
            }
            BeanInfoNode node = this._node.getBeanNode();
            this.setText(node.getDisplayName());
            if (node instanceof MethodNode) {
                IMethodInfo mi = ((MethodNode)node).getMethodDescriptor();
                icon = mi.isPrivate() ? EditorUtilities.loadIcon("images/Method.png") : (mi.isInternal() ? EditorUtilities.loadIcon("images/Method.png") : (mi.isProtected() ? EditorUtilities.loadIcon("images/Method.png") : EditorUtilities.loadIcon("images/Method.png")));
                if (mi.isDeprecated()) {
                    this.setText("<html><strike>" + this.getText() + "</strike></html>");
                }
            } else if (node instanceof PropertyNode) {
                IPropertyInfo pi = ((PropertyNode)node).getPropertyDescriptor();
                icon = pi.isPrivate() ? EditorUtilities.loadIcon("images/property.png") : (pi.isInternal() ? EditorUtilities.loadIcon("images/property.png") : (pi.isProtected() ? EditorUtilities.loadIcon("images/property.png") : EditorUtilities.loadIcon("images/property.png")));
                if (pi.isDeprecated()) {
                    this.setText("<html><strike>" + this.getText() + "</strike></html>");
                }
            } else {
                icon = node.getType() instanceof IFunctionType ? EditorUtilities.loadIcon("images/Method.png") : EditorUtilities.loadIcon("images/variable.png");
            }
            this.setIcon(icon);
        }

        @Override
        public void paint(Graphics g) {
            Color bkColor;
            if (this._bSelected) {
                bkColor = this._tree.isEnabled() ? Scheme.active().getActiveCaption() : Scheme.active().getControl();
            } else {
                bkColor = this._tree.getBackground();
                if (bkColor == null) {
                    bkColor = this.getBackground();
                }
            }
            if (bkColor != null) {
                g.setColor(bkColor);
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                if (this._bSelected) {
                    g.setColor(this._tree.isEnabled() ? Scheme.active().getXpBorderColor() : Scheme.active().getControlShadow());
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
                g.setColor(bkColor);
            }
            this.setForeground(Scheme.active().getWindowText());
            super.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (dim != null) {
                dim = new Dimension(dim.width + 3, dim.height);
            }
            return dim;
        }
    }

    class BeanTreeListener
    extends MouseAdapter {
        BeanTreeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (BeanInfoPopup.this._bLocked) {
                return;
            }
            TreePath path = BeanInfoPopup.this._tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            BeanTree tree = (BeanTree)path.getLastPathComponent();
            BeanInfoPopup.this.setVisible(false);
            BeanInfoPopup.this.fireNodeChanged(BeanInfoPopup.this._nodeListenerList, new ChangeEvent(tree));
            e.consume();
        }
    }

    class EditorKeyListener
    extends KeyAdapter {
        EditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isControlDown()) {
                if (e.getKeyCode() == 8 || e.getKeyCode() == 127 || e.getKeyCode() == 37 || e.getKeyCode() == 39 || e.getKeyCode() == 86) {
                    return;
                }
                if (e.getKeyCode() == 90) {
                    BeanInfoPopup.this.setVisible(false);
                    return;
                }
                e.consume();
                return;
            }
            if (e.getModifiers() == 8) {
                e.consume();
                return;
            }
            if (e.getKeyCode() == 38 || e.getKeyCode() == 224) {
                Action selectPrevious = BeanInfoPopup.this._tree.getActionMap().get("selectPrevious");
                selectPrevious.actionPerformed(new ActionEvent(BeanInfoPopup.this._tree, 0, "selectPrevious"));
                e.consume();
            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
                Action selectNext = BeanInfoPopup.this._tree.getActionMap().get("selectNext");
                selectNext.actionPerformed(new ActionEvent(BeanInfoPopup.this._tree, 0, "selectNext"));
                e.consume();
            } else if (e.getKeyCode() == 33) {
                Action scrollUpChangeSelection = BeanInfoPopup.this._tree.getActionMap().get("scrollUpChangeSelection");
                scrollUpChangeSelection.actionPerformed(new ActionEvent(BeanInfoPopup.this._tree, 0, "scrollUpChangeSelection"));
                e.consume();
            } else if (e.getKeyCode() == 34) {
                Action scrollDownChangeSelection = BeanInfoPopup.this._tree.getActionMap().get("scrollDownChangeSelection");
                scrollDownChangeSelection.actionPerformed(new ActionEvent(BeanInfoPopup.this._tree, 0, "scrollDownChangeSelection"));
                e.consume();
            } else if (e.getKeyCode() == 10 || e.getKeyCode() == 32 || e.getKeyCode() == 9) {
                BeanInfoPopup.this.setReplaceWholeWord(e.getKeyCode() == 9);
                this.handleSelection();
                e.consume();
            } else if (e.getKeyCode() == 46) {
                this.handleSelectionForDot();
            } else if (e.getKeyCode() == 27) {
                BeanInfoPopup.this.setVisible(false);
                e.consume();
            }
        }

        void handleSelectionForDot() {
            TreePath path = BeanInfoPopup.this._tree.getSelectionPath();
            if (path == null) {
                BeanInfoPopup.this.setVisible(false);
                return;
            }
            EventQueue.invokeLater(() -> {
                this.sendKeyEvent(8);
                BeanTree tree = (BeanTree)path.getLastPathComponent();
                BeanInfoPopup.this.fireNodeChanged(BeanInfoPopup.this._nodeListenerList, new DotWasTypedChangeEvent(tree));
                BeanInfoPopup.this.setVisible(false);
                EventQueue.invokeLater(() -> this.sendKeyEvent(46));
            });
        }

        private void handleSelection() {
            TreePath path = BeanInfoPopup.this._tree.getSelectionPath();
            if (path == null) {
                return;
            }
            this.handleSelection(path);
        }

        private void handleSelection(TreePath path) {
            BeanTree tree = (BeanTree)path.getLastPathComponent();
            BeanInfoPopup.this.fireNodeChanged(BeanInfoPopup.this._nodeListenerList, new ChangeEvent(tree));
            BeanInfoPopup.this.setVisible(false);
        }

        private void sendKeyEvent(int iKey) {
            BeanInfoPopup.this.getEditor().getEditor().dispatchEvent(new KeyEvent(BeanInfoPopup.this.getEditor().getEditor(), 401, System.currentTimeMillis(), 0, iKey, '\uffff'));
            BeanInfoPopup.this.getEditor().getEditor().dispatchEvent(new KeyEvent(BeanInfoPopup.this.getEditor().getEditor(), 402, System.currentTimeMillis(), 0, iKey, '\uffff'));
            BeanInfoPopup.this.getEditor().getEditor().dispatchEvent(new KeyEvent(BeanInfoPopup.this.getEditor().getEditor(), 400, System.currentTimeMillis(), 0, 0, (char)iKey));
        }
    }

    static class DotWasTypedChangeEvent
    extends ChangeEvent {
        public DotWasTypedChangeEvent(Object source) {
            super(source);
        }
    }
}

