/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractLineInfoManager;
import editor.GosuEditor;
import editor.debugger.Breakpoint;
import editor.util.EditorUtilities;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.statements.IFunctionStatement;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.ImageIcon;

public class GosuClassLineInfoManager
extends AbstractLineInfoManager {
    private ImageIcon _iconOverride = EditorUtilities.loadIcon("images/override.png");
    private ImageIcon _iconImpl = EditorUtilities.loadIcon("images/impl.png");
    private ImageIcon _iconOverrideAndImpl = EditorUtilities.loadIcon("images/override_and_impl.png");

    @Override
    protected boolean isBreakpointAtLine(int iLine) {
        return this.getBreakpointAtLine(iLine) != null;
    }

    @Override
    protected Breakpoint getBreakpointAtLine(int iLine) {
        return this.getBreakpointManager().getBreakpointAtEditorLine(this.getEditor().getTypeAtLine(iLine), iLine);
    }

    @Override
    protected boolean isExecPointAtLine(int iLine) {
        return this.getExecPointAtLine(iLine) != null;
    }

    @Override
    protected Breakpoint getExecPointAtLine(int iLine) {
        return this.getBreakpointManager().getExecPointAtEditorLine(this.getEditor().getScriptPart().getContainingTypeName(), this.getEditor().getTypeAtLine(iLine), iLine);
    }

    @Override
    protected boolean isFramePointAtLine(int iLine) {
        return this.getFramePointAtLine(iLine) != null;
    }

    @Override
    protected Breakpoint getFramePointAtLine(int iLine) {
        return this.getBreakpointManager().getFramePointAtEditorLine(this.getEditor().getScriptPart().getContainingTypeName(), this.getEditor().getTypeAtLine(iLine), iLine);
    }

    @Override
    public Cursor getCursor(int iLine) {
        if (this.getSuperFunction(iLine) != null) {
            return Cursor.getPredefinedCursor(12);
        }
        return super.getCursor(iLine);
    }

    @Override
    public void handleLineClick(MouseEvent e, int iLine, int iX, int iY) {
        IFunctionStatement overrideFunction = this.getSuperFunction(iLine);
        if (overrideFunction != null && iY < this._iconOverrideAndImpl.getIconHeight() / 2) {
            IFunctionStatement funcStmt = overrideFunction.getDynamicFunctionSymbol().getSuperDfs().getDeclFunctionStmt();
            ((GosuEditor)this.getEditor()).gotoDeclaration(funcStmt.getLocation().getDeepestLocation(funcStmt.getNameOffset(null), true).getParsedElement());
        } else if (e.isPopupTrigger()) {
            this.showContextMenu(e, iLine);
        } else {
            this.getBreakpointManager().toggleLineBreakpoint(this.getEditor(), this.getEditor().getScriptPart().getContainingTypeName(), this.getEditor().getTypeAtLine(iLine), iLine);
        }
    }

    @Override
    public void render(Graphics g, int iLine, int iLineHeight, int iX, int iY) {
        super.render(g, iLine, iLineHeight, iX, iY);
        boolean isOverridden = this.getSuperFunction(iLine) != null;
        boolean isImplemented = false;
        if (isOverridden) {
            if (isImplemented) {
                g.drawImage(this._iconOverrideAndImpl.getImage(), iX, iY + iLineHeight / 2 - this._iconOverrideAndImpl.getIconHeight() / 2, this._iconOverrideAndImpl.getIconWidth(), this._iconOverrideAndImpl.getIconHeight(), null);
            } else {
                g.drawImage(this._iconOverride.getImage(), iX, iY + iLineHeight / 2 - this._iconOverride.getIconHeight() / 2, this._iconOverride.getIconWidth(), this._iconOverride.getIconHeight(), null);
            }
        } else if (isImplemented) {
            g.drawImage(this._iconImpl.getImage(), iX, iY + iLineHeight / 2 - this._iconImpl.getIconHeight() / 2, this._iconImpl.getIconWidth(), this._iconImpl.getIconHeight(), null);
        }
    }

    private IFunctionStatement getSuperFunction(int iLine) {
        IDynamicFunctionSymbol dfs;
        Map<Integer, IFunctionStatement> functionsByLine = ((GosuEditor)this.getEditor()).getFunctionsByLineNumber();
        IFunctionStatement functionStatement = functionsByLine.get(iLine);
        if (functionStatement != null && (dfs = functionStatement.getDynamicFunctionSymbol()) != null && dfs.isOverride()) {
            return functionStatement;
        }
        return null;
    }
}

