/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditorKit;
import editor.GosuStyleContext;
import editor.util.Pair;
import gw.lang.GosuShop;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISourceCodeTokenizer;
import gw.lang.parser.ITokenizerInstructor;
import gw.lang.parser.Keyword;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.exceptions.ParseWarningForDeprecatedMember;
import gw.lang.parser.expressions.IBeanMethodCallExpression;
import gw.lang.parser.expressions.IBlockLiteralExpression;
import gw.lang.parser.expressions.ICompoundTypeLiteral;
import gw.lang.parser.expressions.IFieldAccessExpression;
import gw.lang.parser.expressions.ITypeLiteralExpression;
import gw.lang.parser.statements.IBeanMethodCallStatement;
import gw.lang.parser.statements.INamespaceStatement;
import gw.lang.parser.statements.IUsesStatement;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.INamespaceType;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.gs.IGosuEnhancement;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

public class GosuDocument
extends PlainDocument {
    static final Object CommentAttribute = new AttributeKey();
    private ParseResultsException _pe;
    private List<IParseTree> _locations;
    private int _locationsOffset;
    private char[] _charArray = new char[1];
    private ITokenizerInstructor _instructor;

    public GosuDocument() {
        super(new GapContent(1024));
    }

    public Scanner createScanner() {
        return new Scanner(new DocumentReader(0, this.getLength()), this._instructor);
    }

    public void setParseResultsException(ParseResultsException pe) {
        this._pe = pe;
    }

    public ParseResultsException getParseResultsException() {
        return this._pe;
    }

    public void setLocations(List<IParseTree> locations) {
        this._locations = locations;
    }

    public List<IParseTree> getLocations() {
        return this._locations;
    }

    public void setLocationsOffset(int locationsOffset) {
        this._locationsOffset = locationsOffset;
    }

    public boolean hasErrorStartingAt(int iPos) {
        if (this._pe == null) {
            return false;
        }
        List pes = this._pe.getParseExceptions();
        for (IParseIssue pe : pes) {
            if (pe.getTokenStart() != iPos) continue;
            return true;
        }
        return false;
    }

    public Pair<Boolean, ParseWarningForDeprecatedMember> getParseWarningStartingAt(int iPos) {
        if (this._pe == null) {
            return new Pair<Boolean, Object>(false, null);
        }
        List pes = this._pe.getParseWarnings();
        boolean hasParseWarning = false;
        ParseWarningForDeprecatedMember parseWarning = null;
        for (IParseIssue pe : pes) {
            if (pe.getTokenStart() == null || pe.getTokenStart() != iPos) continue;
            hasParseWarning = true;
            if (!(pe instanceof ParseWarningForDeprecatedMember)) continue;
            parseWarning = (ParseWarningForDeprecatedMember)pe;
            break;
        }
        return new Pair<Boolean, Object>(hasParseWarning, parseWarning);
    }

    public Integer getStyleCodeAtPosition(int iPosition) {
        IParseTree l;
        if (this._locations == null || this._locations.isEmpty()) {
            return null;
        }
        try {
            l = IParseTree.Search.getDeepestLocation(this._locations, (int)(iPosition - this._locationsOffset), (boolean)true);
        }
        catch (Throwable t) {
            return null;
        }
        if (l == null) {
            return null;
        }
        if (!l.contains(iPosition - this._locationsOffset)) {
            return null;
        }
        IParsedElement parsedElem = l.getParsedElement();
        try {
            return this.getStyleCodeForParsedElement(iPosition, parsedElem);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private Integer getStyleCodeForParsedElement(int iPosition, IParsedElement parsedElem) {
        if (parsedElem instanceof IBeanMethodCallStatement) {
            parsedElem = ((IBeanMethodCallStatement)parsedElem).getBeanMethodCall();
        }
        if (parsedElem instanceof IBeanMethodCallExpression) {
            IMethodInfo md;
            if (iPosition >= ((IBeanMethodCallExpression)parsedElem).getStartOffset() && (md = ((IBeanMethodCallExpression)parsedElem).getMethodDescriptor()) != null) {
                if (md.getOwnersType() instanceof IGosuEnhancement) {
                    return GosuStyleContext.ENHANCEMENT_METHOD_CALL_KEY;
                }
                return GosuStyleContext.METHOD_CALL_KEY;
            }
            return null;
        }
        if (parsedElem instanceof IExpression && ((IExpression)parsedElem).getType() instanceof INamespaceType && !parsedElem.hasParseExceptions()) {
            return GosuStyleContext.NESTED_TYPE_LITERAL_KEY;
        }
        if (parsedElem instanceof IFieldAccessExpression) {
            IFieldAccessExpression ma = (IFieldAccessExpression)parsedElem;
            try {
                if (iPosition < ma.getStartOffset()) {
                    return null;
                }
                if (!GosuEditorKit.getStylePreferences().areStylesEquivalent("EnhancementProperty", "Property")) {
                    IPropertyInfo pi = ((IFieldAccessExpression)parsedElem).getPropertyInfo();
                    if (pi != null && pi.getOwnersType() instanceof IGosuEnhancement) {
                        return GosuStyleContext.ENHANCEMENT_PROPERTY_KEY;
                    }
                    return GosuStyleContext.PROPERTY_KEY;
                }
                return GosuStyleContext.PROPERTY_KEY;
            }
            catch (Exception pi) {
                // empty catch block
            }
        }
        if (parsedElem instanceof ITypeLiteralExpression) {
            ITypeLiteralExpression tl = (ITypeLiteralExpression)parsedElem;
            if (!(tl.getType().getType() instanceof IErrorType)) {
                IParsedElement parent = tl.getParent();
                if (parent instanceof IUsesStatement) {
                    return GosuStyleContext.USES_KEY;
                }
                int segLength = Math.min(5, this.getContent().length() - iPosition);
                Segment txt = new Segment(this._charArray, iPosition, segLength);
                try {
                    this.getContent().getChars(iPosition, segLength, txt);
                    if (Character.isJavaIdentifierPart(txt.first())) {
                        if (parent instanceof ITypeLiteralExpression && !(parent instanceof ICompoundTypeLiteral)) {
                            if (parent instanceof IBlockLiteralExpression) {
                                return GosuStyleContext.TYPE_LITERAL_KEY;
                            }
                            return GosuStyleContext.NESTED_TYPE_LITERAL_KEY;
                        }
                        if (parsedElem instanceof IBlockLiteralExpression && !"block".equals(txt.toString())) {
                            return GosuStyleContext.NESTED_TYPE_LITERAL_KEY;
                        }
                        return GosuStyleContext.TYPE_LITERAL_KEY;
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                return GosuStyleContext.PARSE_ERROR_KEY;
            }
        }
        if (parsedElem instanceof INamespaceStatement) {
            return GosuStyleContext.PACKAGE_KEY;
        }
        return null;
    }

    public int getScannerStart(int p) {
        Element elem = this.getDefaultRootElement();
        int lineNum = elem.getElementIndex(p);
        Element line = elem.getElement(lineNum);
        AttributeSet a = line.getAttributes();
        while (a.isDefined(CommentAttribute) && lineNum > 0) {
            line = elem.getElement(--lineNum);
            a = line.getAttributes();
        }
        return line.getStartOffset();
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
        Element root = this.getDefaultRootElement();
        DocumentEvent.ElementChange ec = chng.getChange(root);
        if (ec != null) {
            Element[] added = ec.getChildrenAdded();
            boolean inComment = false;
            for (Element elem : added) {
                String s;
                int p0 = elem.getStartOffset();
                int p1 = elem.getEndOffset();
                try {
                    s = this.getText(p0, p1 - p0);
                }
                catch (BadLocationException bl) {
                    s = "";
                }
                if (inComment) {
                    MutableAttributeSet a = (MutableAttributeSet)elem.getAttributes();
                    a.addAttribute(CommentAttribute, CommentAttribute);
                    int index = s.indexOf("*/");
                    if (index < 0) continue;
                    inComment = false;
                    continue;
                }
                int index = s.indexOf("/*");
                if (index < 0 || (index = s.indexOf("*/", index)) >= 0) continue;
                inComment = true;
            }
        }
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.removeUpdate(chng);
    }

    public void setTokenizerInstructor(ITokenizerInstructor tokenizerInstructor) {
        this._instructor = tokenizerInstructor;
    }

    class DocumentReader
    extends Reader {
        Segment segment = new Segment();
        int p0;
        int p1;
        int pos;
        int index;

        public DocumentReader(int p0, int p1) {
            this.p0 = p0;
            this.p1 = Math.min(GosuDocument.this.getLength(), p1);
            this.pos = p0;
            try {
                this.loadSegment();
            }
            catch (IOException ioe) {
                throw new Error("unexpected: " + ioe);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.index >= this.segment.offset + this.segment.count) {
                if (this.pos >= this.p1) {
                    return -1;
                }
                this.loadSegment();
            }
            return this.segment.array[this.index++];
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void reset() throws IOException {
            this.pos = this.p0;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int length = this.segment.offset + this.segment.count;
            if (this.index >= length) {
                if (this.pos >= this.p1) {
                    return -1;
                }
                this.loadSegment();
                length = this.segment.offset + this.segment.count;
            }
            int n = Math.min(length - this.index, len);
            System.arraycopy(this.segment.array, this.index, cbuf, 0, n);
            this.index += n;
            return n;
        }

        void loadSegment() throws IOException {
            try {
                int n = Math.min(1024, this.p1 - this.pos);
                GosuDocument.this.getText(this.pos, n, this.segment);
                this.pos += n;
                this.index = this.segment.offset;
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class Scanner {
        int _p0;
        ISourceCodeTokenizer _tokenizer;

        Scanner(Reader reader, ITokenizerInstructor instructor) {
            this._tokenizer = GosuShop.createSourceCodeTokenizer((Reader)reader);
            this._tokenizer.setWhitespaceSignificant(true);
            this._tokenizer.setCommentsSignificant(true);
            this._tokenizer.setParseDotsAsOperators(true);
            this._tokenizer.wordChars(95, 95);
            if (instructor != null) {
                this._tokenizer.setInstructor(instructor.createNewInstance(this._tokenizer));
            }
        }

        public boolean isReservedWord(String strWord) {
            return Keyword.isReservedKeyword((String)strWord);
        }

        public void setRange(int p0, int p1) throws IOException {
            this._tokenizer.reset((Reader)new DocumentReader(p0, p1));
            this._tokenizer.nextToken();
            this._p0 = p0;
        }

        public final int getStartOffset() {
            int begOffs = this._tokenizer.getTokenStart();
            return this._p0 + begOffs;
        }

        public final int getEndOffset() {
            int endOffs = this._tokenizer.getTokenEnd();
            return this._p0 + endOffs;
        }

        public int getType() {
            return this._tokenizer.getType();
        }

        public void nextToken() throws IOException {
            this._tokenizer.nextToken();
        }
    }

    static class AttributeKey {
        private AttributeKey() {
        }

        public String toString() {
            return "comment";
        }
    }
}

