/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.DefaultContextMenuHandler;
import editor.GosuEditor;
import editor.GosuEditorKit;
import editor.GosuStyleContext;
import editor.IContextMenuHandler;
import editor.ILineInfoManager;
import editor.IScriptEditor;
import editor.undo.AtomicUndoManager;
import editor.util.EditorUtilities;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ScriptabilityModifiers;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.reflect.IScriptabilityModifier;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import javax.swing.JViewport;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class GosuField
extends GosuEditor
implements ClipboardOwner {
    private static volatile AtomicUndoManager _dummyUndoMgr;

    public GosuField(ISymbolTable symTable, AtomicUndoManager undoMgr) {
        this(symTable, GosuField.normalizeUndoManager(undoMgr), true, true);
    }

    public GosuField(ISymbolTable symTable, AtomicUndoManager undoMgr, boolean bEmptyTextOk, boolean bAccessAll) {
        this(symTable, GosuField.normalizeUndoManager(undoMgr), (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE, new DefaultContextMenuHandler(), false, bEmptyTextOk, bAccessAll);
    }

    public GosuField(ISymbolTable symTable, AtomicUndoManager undoMgr, IScriptabilityModifier scriptabilityConstraint, IContextMenuHandler<IScriptEditor> contextMenuHandler, boolean bStatement, boolean bEmptyTextOk, boolean bAccessAll) {
        super(symTable, null, GosuField.normalizeUndoManager(undoMgr), scriptabilityConstraint, contextMenuHandler, bStatement, bEmptyTextOk);
        ((AbstractDocument)this.getEditor().getDocument()).setDocumentFilter(new GSFieldDocumentFilter());
        this.setAcceptUses(false);
        this.setAccessAll(bAccessAll);
    }

    @Override
    public void read(IScriptPartId partId, String strSource) throws IOException {
        super.read(partId, strSource);
        ((AbstractDocument)this.getEditor().getDocument()).setDocumentFilter(new GSFieldDocumentFilter());
    }

    @Override
    protected void configureLayout(ILineInfoManager lineInfoRenderer) {
        super.configureLayout(lineInfoRenderer);
        JViewport viewport = new JViewport(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = GosuField.this.getEditor().getPreferredSize();
                return new Dimension(1, dim.height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        viewport.setView(this.getEditor());
        this.add((Component)viewport, "Center");
    }

    @Override
    protected void handleParseException(ParseResultsException e, boolean bForceCodeCompletion) {
        super.handleParseException(e, bForceCodeCompletion);
        if (e != null) {
            if (!e.getParseExceptions().isEmpty()) {
                this.getEditor().setBackground(GosuEditorKit.getStylePreferences().getBackground(-90));
            } else {
                this.getEditor().setBackground(GosuEditorKit.getStylePreferences().getBackground(-89));
            }
        }
    }

    @Override
    protected void clearParseException() {
        super.clearParseException();
        EventQueue.invokeLater(() -> this.getEditor().setBackground(((GosuStyleContext)this.getEditor().getEditorKit().getViewFactory()).getBackground(-91)));
    }

    @Override
    public void clipCut(Clipboard c) {
        try {
            this.getUndoManager().beginUndoAtom("Cut");
            this.clipCopy(c);
            this.delete();
        }
        finally {
            this.getUndoManager().endUndoAtom();
        }
    }

    @Override
    public void clipCopy(Clipboard c) {
        try {
            Transferable contents = this.getClipCopyContents();
            if (contents == null) {
                return;
            }
            c.setContents(contents, this);
        }
        catch (Exception e) {
            EditorUtilities.handleUncaughtException(e);
        }
    }

    @Override
    public void clipPaste(Clipboard c, boolean asGosu) {
        Transferable t = c.getContents(this);
        if (t == null) {
            return;
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String strContents = (String)t.getTransferData(DataFlavor.stringFlavor);
                this.getEditor().replaceSelection(strContents);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Transferable getClipCopyContents() {
        StringSelection contents = null;
        String strSelection = this.getExpandedSelection();
        if (strSelection != null && strSelection.length() > 0) {
            contents = new StringSelection(strSelection);
        }
        return contents;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private static AtomicUndoManager normalizeUndoManager(AtomicUndoManager candidate) {
        return candidate != null ? candidate : GosuField.getDummyUndoManager();
    }

    private static AtomicUndoManager getDummyUndoManager() {
        if (_dummyUndoMgr == null) {
            AtomicUndoManager dummy = new AtomicUndoManager(1);
            dummy.setPaused(true);
            _dummyUndoMgr = dummy;
        }
        return _dummyUndoMgr;
    }

    class GSFieldDocumentFilter
    extends DocumentFilter {
        GSFieldDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (GosuField.this.getHeight() < GosuField.this.getFontMetrics(GosuField.this.getFont()).getHeight() * 2) {
                super.insertString(fb, offset, string.replace('\n', ';'), attr);
            } else {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (GosuField.this.getHeight() < GosuField.this.getFontMetrics(GosuField.this.getFont()).getHeight() * 2) {
                super.replace(fb, offset, length, text.replace('\n', ';'), attrs);
            } else {
                super.replace(fb, offset, length, text, attrs);
            }
        }
    }
}

