/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractGotoPopup;
import editor.FileTree;
import editor.FileTreeUtil;
import editor.GotoTypePopup;
import editor.LabFrame;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JRootPane;
import javax.swing.text.JTextComponent;

public class GotoProgramTypePopup
extends GotoTypePopup {
    public static void display() {
        GotoProgramTypePopup valuePopup = new GotoProgramTypePopup("");
        valuePopup.addNodeChangeListener(e -> {
            String strQualifedType = (String)e.getSource();
            GotoProgramTypePopup.doGoTo(strQualifedType);
        });
        JRootPane host = LabFrame.instance().getRootPane();
        valuePopup.show(host, 0, 0);
    }

    public static void display(JTextComponent host, String prefix, Consumer<String> consumer) {
        GotoProgramTypePopup valuePopup = new GotoProgramTypePopup(prefix);
        valuePopup.addNodeChangeListener(e -> {
            String strQualifedType = (String)e.getSource();
            consumer.accept(strQualifedType);
            host.requestFocus();
        });
        valuePopup.getNameField().setText(prefix);
        valuePopup.show(EditorUtilities.rootPaneForComponent(host), 0, 0);
    }

    public GotoProgramTypePopup(String strPrefix) {
        super("Enter a program name", strPrefix);
    }

    @Override
    protected List<String> initializeData() {
        FileTree root = FileTreeUtil.getRoot();
        ArrayList<String> progs = new ArrayList<String>();
        this.findProgs(root, progs);
        return progs;
    }

    private void findProgs(FileTree root, List<String> progs) {
        if (root.getName().toLowerCase().endsWith(".gsp")) {
            progs.add(root.getType().getName());
        } else if (root.isDirectory()) {
            for (FileTree tree : root.getChildren()) {
                this.findProgs(tree, progs);
            }
        }
    }

    protected List<String> filterTypes(List<String> types, Experiment experiment) {
        return types;
    }

    @Override
    protected AbstractGotoPopup.AbstractPopupListModel<String> reconstructModel(String strPrefix) {
        if (strPrefix == null || strPrefix.isEmpty()) {
            return new GotoTypePopup.TypeModel(this.getInitializedAllData());
        }
        return super.reconstructModel(strPrefix);
    }
}

