/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.util.EditorUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;

public class ImagePanel
extends JComponent {
    ImageIcon _image;
    Dimension _minDim;
    Border _border;
    JLabel _label;

    public ImagePanel(String strImage) {
        this.setOpaque(false);
        this._image = EditorUtilities.loadIcon(strImage);
        this._label = new JLabel();
        this.setLayout(null);
    }

    @Override
    public void paintComponent(Graphics g) {
        this._image.paintIcon(this, g, this.getInsets().left, this.getInsets().top);
        g.translate(this._label.getX(), this._label.getY());
        this._label.paint(g);
    }

    @Override
    public synchronized Dimension getMinimumSize() {
        Insets insets;
        if (this._image == null) {
            return super.getMinimumSize();
        }
        Insets insets2 = insets = this._border == null ? new Insets(0, 0, 0, 0) : this._border.getBorderInsets(this);
        return this._minDim == null ? new Dimension(this._image.getIconWidth() + (this._border != null ? insets.left + insets.right : 0), this._image.getIconHeight() + (this._border != null ? insets.top + insets.bottom : 0)) : this._minDim;
    }

    @Override
    public synchronized Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void setMinimumSize(Dimension dim) {
        this._minDim = dim;
    }

    @Override
    public synchronized Insets getInsets() {
        if (this._border == null) {
            return super.getInsets();
        }
        return this._border.getBorderInsets(this);
    }

    public ImageIcon getImageIcon() {
        return this._image;
    }

    public void setImageIcon(ImageIcon image) {
        this._image = image;
    }

    public Border getImageBorder() {
        return this._border;
    }

    public Rectangle getClientRect() {
        if (this._image == null) {
            return this.getBounds();
        }
        if (this._border == null) {
            return new Rectangle(0, 0, this._image.getIconWidth(), this._image.getIconHeight());
        }
        Insets insets = this._border.getBorderInsets(this);
        return new Rectangle(insets.left, insets.top, this._image.getIconWidth(), this._image.getIconHeight());
    }

    public void setTextColor(Color textColor) {
        this._label.setForeground(textColor);
    }

    public Color getTextColor() {
        return this._label.getForeground();
    }

    public void setTextRect(Rectangle rcText) {
        this._label.setBounds(rcText);
    }

    public Rectangle getTextRect() {
        return this._label.getBounds();
    }

    public void setText(String strText) {
        this._label.setText(strText);
        this.repaintNow();
    }

    public void repaintNow() {
        Graphics g = this.getGraphics();
        this.paint(g);
        g.dispose();
    }

    public static ImagePanel createSplashImagePanel(String strImage) {
        ImagePanel imagePanel = new ImagePanel(strImage);
        imagePanel.setCursor(Cursor.getPredefinedCursor(3));
        Window splash = new Window(new Frame()){

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }
        };
        splash.setBackground(new Color(0, 0, 0, 0));
        splash.setLayout(new BorderLayout());
        splash.add("Center", imagePanel);
        splash.pack();
        EditorUtilities.centerWindowInFrame(splash, splash);
        splash.setVisible(true);
        imagePanel.repaintNow();
        return imagePanel;
    }

    public static ImagePanel createAboutImagePopup(String strImage) {
        Point showDim;
        ImagePanel imagePanel = new ImagePanel(strImage);
        final JPopupMenu splash = new JPopupMenu();
        splash.setOpaque(false);
        splash.setBackground(new Color(0, 0, 0, 0));
        splash.add(imagePanel);
        int iconWidth = imagePanel.getImageIcon().getIconWidth();
        int iconHeight = imagePanel.getImageIcon().getIconHeight();
        if (EditorUtilities.getActiveWindow() == null) {
            showDim = EditorUtilities.getXYForDialogRelativeToStudioFrame(iconWidth, iconHeight);
        } else {
            Dimension rootPaneSize = ((JFrame)EditorUtilities.getActiveWindow()).getRootPane().getSize();
            int x = (rootPaneSize.width - iconWidth) / 2;
            int y = (rootPaneSize.height - iconHeight) / 2;
            showDim = new Point(x, y);
        }
        splash.show(EditorUtilities.getActiveWindow() == null ? null : ((JFrame)EditorUtilities.getActiveWindow()).getRootPane(), (int)showDim.getX(), (int)showDim.getY());
        splash.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                splash.setVisible(false);
            }
        });
        return imagePanel;
    }
}

