/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.EditorHost;
import editor.GosuEventQueue;
import editor.GosuLabLAF;
import editor.GosuPanel;
import editor.IGosuEditor;
import editor.settings.ISettings;
import editor.settings.Settings;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.PlatformUtil;
import editor.util.ScreenUtil;
import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.lang.parser.IScriptPartId;
import gw.lang.reflect.Expando;
import gw.lang.reflect.ReflectUtil;
import gw.lang.reflect.json.IJsonIO;
import gw.lang.reflect.json.Json;
import gw.lang.reflect.module.IFileSystem;
import gw.util.PathUtil;
import gw.util.StreamUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.script.Bindings;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class LabFrame
extends JFrame
implements IGosuEditor {
    public static final int VERSION = 2;
    private static final String GOSU_LAB_DIR = ".GosuLab";
    private static final String GOSU_DIR = ".Gosu";
    private static LabFrame INSTANCE = null;
    private static Map<String, ISettings> _settings = Settings.makeDefaultSettings();
    private GosuPanel _panel;
    private Rectangle _restoreBounds;
    private List<String> _experiments = Collections.emptyList();

    public static LabFrame instance() {
        return INSTANCE;
    }

    public LabFrame() throws HeadlessException {
        super("Gosu Editor");
        this.makeCustomFrameDecorations();
        INSTANCE = this;
        this.configUI();
        this.setInitialSize();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LabFrame.this.exit();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                EventQueue.invokeLater(() -> {
                    EditorHost currentEditor = LabFrame.this._panel.getCurrentEditor();
                    if (currentEditor != null) {
                        currentEditor.parse();
                    }
                });
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                EventQueue.invokeLater(LabFrame.this._panel::saveIfDirty);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if ((LabFrame.this.getExtendedState() & 6) != 6) {
                    LabFrame.this._restoreBounds = LabFrame.this.getBounds();
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                if ((LabFrame.this.getExtendedState() & 6) != 6) {
                    LabFrame.this._restoreBounds = LabFrame.this.getBounds();
                }
            }
        });
    }

    private void makeCustomFrameDecorations() {
    }

    public void exit() {
        this.saveLabState(this._panel.getExperimentView().getExperiment());
        if (this._panel.saveIfDirty()) {
            this.getGosuPanel().killProcess();
            System.exit(0);
        }
    }

    private void configUI() {
        this.setDefaultCloseOperation(0);
        this.setIconImage(LabFrame.loadLabIcon().getImage());
        this._panel = new GosuPanel(this);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this._panel, "Center");
    }

    private void setInitialSize() {
        this._panel.setEditorSplitPosition(20);
        this._panel.setExperimentSplitPosition(60);
    }

    @Override
    public void reset() {
        if (EventQueue.isDispatchThread()) {
            this.resetNow();
            return;
        }
        try {
            EventQueue.invokeAndWait(this::resetNow);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void resetNow() {
        this._panel.clearTabs();
    }

    @Override
    public void openInitialFile(IScriptPartId partId, Path file) {
        this._panel.openInitialFile(partId, file);
    }

    @Override
    public void openFile(Path anySourceFile) {
        this._panel.openFile(anySourceFile, true);
    }

    @Override
    public void showMe() {
        this.setVisible(true);
        GosuEventQueue.instance().run();
    }

    @Override
    public GosuPanel getGosuPanel() {
        return this._panel;
    }

    @Override
    public void restoreState(Experiment experiment) {
        this._panel.restoreExperimentState(experiment);
    }

    public void selectTab(Object contentId) {
        this._panel.selectTab((Path)contentId);
    }

    public void closeTab(Object contentId) {
        this._panel.closeTab((Path)contentId);
    }

    public Rectangle getRestoreBounds() {
        return new Rectangle(this._restoreBounds);
    }

    public void setRestoreBounds(Rectangle restoreBounds) {
        this._restoreBounds = restoreBounds;
    }

    public List<String> getExperiments() {
        return this._experiments;
    }

    public void setExperiments(List<String> experiments) {
        this._experiments = experiments;
        Iterator<String> iter = experiments.iterator();
        while (iter.hasNext()) {
            String exp = iter.next();
            if (PathUtil.exists((Path)PathUtil.create((String)exp, (String[])new String[0]), (LinkOption[])new LinkOption[0])) continue;
            iter.remove();
        }
    }

    public void addExperiment(Experiment exp) {
        String dir = PathUtil.getAbsolutePathName((Path)exp.getExperimentDir());
        if (this._experiments.isEmpty()) {
            this._experiments = new ArrayList<String>();
            this._experiments.add(dir);
        } else {
            if (this._experiments.contains(dir)) {
                this._experiments.remove(dir);
            }
            this._experiments.add(0, dir);
        }
    }

    public static LabFrame create() {
        GosuLabLAF.setLookAndFeel();
        CommonServices.getFileSystem().setCachingMode(IFileSystem.CachingMode.NO_CACHING);
        return new LabFrame();
    }

    public void checkForUpdate(GosuPanel gosuPanel) {
        try {
            Path userFile = LabFrame.getUserFile(gosuPanel);
            if (!PathUtil.exists((Path)userFile, (LinkOption[])new LinkOption[0]) || LabFrame.getVersion(gosuPanel) < 2) {
                PathUtil.delete((Path)LabFrame.getUserGosuEditorDir(), (boolean)true);
            }
        }
        catch (Exception e) {
            PathUtil.delete((Path)LabFrame.getUserGosuEditorDir(), (boolean)true);
        }
    }

    public static Path getUserGosuDir() {
        Path gosuDir = PathUtil.create((String)System.getProperty("user.home"), (String[])new String[]{GOSU_DIR});
        PathUtil.mkdirs((Path)gosuDir);
        return gosuDir;
    }

    public static Path getUserGosuEditorDir() {
        Path gosuDir = PathUtil.create((String)System.getProperty("user.home"), (String[])new String[]{GOSU_LAB_DIR});
        PathUtil.mkdirs((Path)gosuDir);
        return gosuDir;
    }

    public static Path getIndexDir() {
        Path gosuDir = PathUtil.create((String)(System.getProperty("user.home") + File.separator + GOSU_LAB_DIR + File.separator + "index"), (String[])new String[0]);
        PathUtil.mkdirs((Path)gosuDir);
        return gosuDir;
    }

    public static Path getStockExperimentsDir() {
        Path gosuDir = PathUtil.create((String)(System.getProperty("user.home") + File.separator + GOSU_LAB_DIR + File.separator + "experiments"), (String[])new String[0]);
        LabFrame.copyExampleExperiments(LabFrame.getStockExamplesDir());
        return gosuDir;
    }

    private static void copyExampleExperiments(Path gosuDir) {
        URL marker = EditorUtilities.class.getClassLoader().getResource("examples/marker.txt");
        try {
            IDirectory examplesDir = CommonServices.getFileSystem().getIFile(marker).getParent();
            LabFrame.copyExamples((IResource)examplesDir, gosuDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyExamples(IResource from, Path to) {
        if (from instanceof IDirectory) {
            if (!PathUtil.getName((Path)to).equals("examples") && PathUtil.exists((Path)to, (LinkOption[])new LinkOption[0])) {
                return;
            }
            if (!PathUtil.exists((Path)to, (LinkOption[])new LinkOption[0]) && !PathUtil.mkdirs((Path)to)) {
                System.out.println("Failed to create experiment directory: " + PathUtil.getAbsolutePathName((Path)to));
            }
            for (IDirectory child : ((IDirectory)from).listDirs()) {
                LabFrame.copyExamples((IResource)child, PathUtil.create((Path)to, (String)child.getName()));
            }
            for (IDirectory child : ((IDirectory)from).listFiles()) {
                LabFrame.copyExamples((IResource)child, PathUtil.create((Path)to, (String)child.getName()));
            }
        } else {
            try {
                int len;
                InputStream in = ((IFile)from).openInputStream();
                OutputStream out = PathUtil.createOutputStream((Path)to, (OpenOption[])new OpenOption[0]);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Path getStockExamplesDir() {
        Path gosuDir = PathUtil.create((String)(System.getProperty("user.home") + File.separator + GOSU_LAB_DIR + File.separator + "examples"), (String[])new String[0]);
        PathUtil.mkdirs((Path)gosuDir);
        return gosuDir;
    }

    public static List<Path> getStockExampleExperiments() {
        ArrayList<Path> experiments = new ArrayList<Path>();
        Path experimentsDir = LabFrame.getStockExamplesDir();
        for (Path dir : PathUtil.listFiles((Path)experimentsDir)) {
            Path experimentFile;
            if (!PathUtil.isDirectory((Path)dir, (LinkOption[])new LinkOption[0]) || (experimentFile = LabFrame.findExperimentFile(dir)) == null) continue;
            experiments.add(dir);
        }
        return experiments;
    }

    public static Path findExperimentFile(Path dir) {
        for (Path f : PathUtil.listFiles((Path)dir)) {
            if (!PathUtil.getName((Path)f).equalsIgnoreCase(PathUtil.getName((Path)dir) + ".prj")) continue;
            return f;
        }
        return null;
    }

    private static Experiment makeScratchExperiment(GosuPanel gosuPanel) {
        Path experimentDir = PathUtil.create((Path)LabFrame.getStockExperimentsDir(), (String)"Scratch");
        return new Experiment(experimentDir, gosuPanel);
    }

    public static void openFileOrDir(Path file) {
        try {
            Path parent;
            if (PathUtil.isDirectory((Path)file, (LinkOption[])new LinkOption[0])) {
                parent = file;
                file = null;
            } else {
                if (!PathUtil.exists((Path)file, (LinkOption[])new LinkOption[0])) {
                    return;
                }
                parent = (file = PathUtil.getAbsolutePath((Path)file)).getParent();
                if (parent == null) {
                    return;
                }
            }
            LabFrame.doOpen(parent, file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void doOpen(Path dir, Path toSelect) throws IOException {
        if (PlatformUtil.isWindows()) {
            String cmd = toSelect != null ? "explorer /select," + PathUtil.getAbsolutePathName((Path)toSelect) : "explorer /root," + PathUtil.getAbsolutePathName((Path)dir);
            Runtime.getRuntime().exec(cmd);
            return;
        }
        if (PlatformUtil.isMac()) {
            if (toSelect != null) {
                String script = String.format("tell application \"Finder\"\n\treveal {\"%s\"} as POSIX file\n\tactivate\nend tell", PathUtil.getAbsolutePathName((Path)toSelect));
                Runtime.getRuntime().exec(new String[]{"/usr/bin/osascript", "-e", script});
            } else {
                Runtime.getRuntime().exec(new String[]{"open", PathUtil.getAbsolutePathName((Path)dir)});
            }
            return;
        }
        String path = PathUtil.getAbsolutePathName((Path)dir);
        if (PlatformUtil.hasXdgOpen()) {
            Runtime.getRuntime().exec(new String[]{"/usr/bin/xdg-open", path});
        } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            Desktop.getDesktop().open(PathUtil.create((String)path, (String[])new String[0]).toFile());
        } else {
            JOptionPane.showMessageDialog(LabFrame.instance(), "This action isn't supported on the current platform", "Cannot Open Path", 0);
        }
    }

    public static ImageIcon loadLabIcon() {
        return EditorUtilities.loadIcon("images/g_16.png");
    }

    public static Path getUserFile(GosuPanel gosuPanel) {
        Path file = PathUtil.create((Path)LabFrame.getUserGosuEditorDir(), (String)"layout.gosulab");
        if (!PathUtil.isFile((Path)file, (LinkOption[])new LinkOption[0])) {
            Expando bindings = new Expando();
            bindings.put("Title", (Object)"Gosu Lab");
            bindings.put("Version", (Object)2);
            bindings.put("Experiments", Arrays.asList(PathUtil.getAbsolutePathName((Path)LabFrame.makeScratchExperiment(gosuPanel).getExperimentDir())));
            try (BufferedWriter fw = PathUtil.createWriter((Path)file);){
                String json = (String)ReflectUtil.invokeMethod((Object)bindings, (String)"toJson", (Object[])new Object[0]);
                fw.write(json);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return file;
    }

    public static Integer getVersion(GosuPanel gosuPanel) throws MalformedURLException {
        Bindings bindings = (Bindings)ReflectUtil.getProperty((Object)LabFrame.getUserFile(gosuPanel).toUri().toURL(), (String)"JsonContent");
        return (Integer)bindings.get("Version");
    }

    public Experiment loadRecentExperiment(GosuPanel gosuPanel) {
        Bindings bindings;
        try {
            bindings = (Bindings)ReflectUtil.getProperty((Object)LabFrame.getUserFile(gosuPanel).toUri().toURL(), (String)"JsonContent");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.restoreLabState(bindings);
        return new Experiment(PathUtil.create((String)LabFrame.instance().getExperiments().get(0), (String[])new String[0]), gosuPanel);
    }

    public void saveLabState(Experiment experiment) {
        if (!LabFrame.instance().isVisible()) {
            return;
        }
        Path userFile = LabFrame.getUserFile(experiment.getGosuPanel());
        try (BufferedWriter fw = PathUtil.createWriter((Path)userFile);){
            Expando bindings = new Expando();
            bindings.put("Title", (Object)"Gosu Lab");
            bindings.put("Version", (Object)2);
            this.addExperiment(experiment);
            bindings.put("Experiments", LabFrame.instance().getExperiments());
            LabFrame.saveScreenProps(bindings);
            String json = (String)ReflectUtil.invokeMethod((Object)bindings, (String)"toJson", (Object[])new Object[0]);
            fw.write(json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void saveScreenProps(Expando bindings) {
        LabFrame frame = LabFrame.instance();
        boolean maximized = (frame.getExtendedState() & 6) == 6;
        Expando bindingsFrame = new Expando();
        bindings.put("Frame", (Object)bindingsFrame);
        bindingsFrame.put("Maximized", (Object)(maximized ? 1 : 0));
        Rectangle bounds = frame.getRestoreBounds();
        Expando bindingsBounds = new Expando();
        bindingsFrame.put("Bounds", (Object)bindingsBounds);
        if (bounds != null) {
            ScreenUtil.convertToPercentageOfScreenWidth(bounds);
            bindingsBounds.put("X", (Object)bounds.x);
            bindingsBounds.put("Y", (Object)bounds.y);
            bindingsBounds.put("Width", (Object)bounds.width);
            bindingsBounds.put("Height", (Object)bounds.height);
        }
    }

    private void restoreLabState(Bindings bindings) {
        LabFrame frame = LabFrame.instance();
        Bindings bindingsFrame = (Bindings)bindings.get("Frame");
        boolean bSet = false;
        if (bindingsFrame != null) {
            Bindings bindingsBounds = (Bindings)bindingsFrame.get("Bounds");
            Integer x = (Integer)bindingsBounds.get("X");
            Integer y = (Integer)bindingsBounds.get("Y");
            Integer width = (Integer)bindingsBounds.get("Width");
            Integer height = (Integer)bindingsBounds.get("Height");
            if (height != null) {
                Rectangle bounds = new Rectangle(x, y, width, height);
                ScreenUtil.convertFromPercentageOfScreenWidth(bounds);
                frame.setBounds(bounds);
                frame.setRestoreBounds(bounds);
                bSet = true;
            }
        }
        if (!bSet) {
            LabFrame.setInitialFrameBounds(LabFrame.instance());
        }
        if (bindingsFrame != null && (Integer)bindingsFrame.get("Maximized") == 1) {
            frame.setExtendedState(6);
        }
        frame.setExperiments((List)bindings.get("Experiments"));
    }

    private static void setInitialFrameBounds(Frame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = screenSize.width * 2 / 3;
        int height = width * 2 / 3;
        frame.setSize(width, height);
        EditorUtilities.centerWindowInFrame(frame, frame);
    }

    public static Map<String, ISettings> getSettings() {
        return _settings;
    }

    public ISettings findSettings(Predicate<ISettings> matcher) {
        if (matcher == null) {
            return null;
        }
        for (ISettings settings : _settings.values()) {
            if (!matcher.test(settings)) continue;
            return settings;
        }
        return null;
    }

    public static void loadSettings() {
        Bindings bindings;
        block15: {
            Path settingsFile = LabFrame.getSettingsFile();
            if (PathUtil.isFile((Path)settingsFile, (LinkOption[])new LinkOption[0])) {
                try (Reader reader = StreamUtil.getInputStreamReader((InputStream)settingsFile.toUri().toURL().openStream());){
                    bindings = Json.fromJson((String)StreamUtil.getContent((Reader)reader));
                    break block15;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
        _settings = new TreeMap<String, ISettings>();
        List settingList = IJsonIO.readList((String)"Settings", (Bindings)bindings);
        settingList.forEach(setting -> _settings.put(setting.getPath(), (ISettings)setting));
        _settings = Settings.mergeSettings(_settings);
    }

    public static void saveSettings() {
        Path settingsFile = LabFrame.getSettingsFile();
        try (BufferedWriter fw = PathUtil.createWriter((Path)settingsFile);){
            Expando bindings = new Expando();
            IJsonIO.writeList((String)"Settings", new ArrayList<ISettings>(_settings.values()), (Bindings)bindings);
            String json = (String)ReflectUtil.invokeMethod((Object)bindings, (String)"toJson", (Object[])new Object[0]);
            fw.write(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path getSettingsFile() {
        return PathUtil.create((Path)LabFrame.getUserGosuEditorDir(), (String)"settings.gosulab");
    }
}

