/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractTree;
import editor.ClearablePanel;
import editor.LabFrame;
import editor.LabTreeCellRenderer;
import editor.MessageTree;
import editor.MessageTreeContextMenu;
import editor.NodeKind;
import editor.Scheme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.MatteBorder;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class MessagesPanel
extends ClearablePanel {
    private JTree _tree;
    private JScrollPane _scroller;

    public MessagesPanel() {
        this.setLayout(new BorderLayout());
        this.configUi();
    }

    private void configUi() {
        this._tree = new JTree();
        this._tree.setModel(new DefaultTreeModel(new MessageTree(this._tree)));
        this._tree.setBackground(Scheme.active().getWindow());
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.setRowHeight(22);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setVisibleRowCount(20);
        this._tree.setCellRenderer(new LabTreeCellRenderer(this._tree));
        this._tree.addMouseListener(new MouseHandler());
        this._tree.addKeyListener(new TreeKeyHandler());
        this._scroller = new JScrollPane(this._tree);
        this._scroller.setBorder(new MatteBorder(0, 1, 1, 1, Scheme.active().getScrollbarBorderColor()));
        this.add((Component)this._scroller, "Center");
    }

    public JTree getTree() {
        return this._tree;
    }

    @Override
    public void clear() {
        this._tree.setModel(new DefaultTreeModel(new MessageTree(this._tree)));
    }

    @Override
    public void dispose() {
        LabFrame.instance().getGosuPanel().showMessages(false);
    }

    public MessageTree getSelectedTree() {
        return (MessageTree)this._tree.getLastSelectedPathComponent();
    }

    public MessageTree addErrorMessage(String message, MessageTree parent, MessageTree.IssueNode data) {
        return this.addTerminalMessage(message, NodeKind.Error, parent, data);
    }

    public MessageTree addWarningMessage(String message, MessageTree parent, MessageTree.IssueNode data) {
        return this.addTerminalMessage(message, NodeKind.Warning, parent, data);
    }

    public MessageTree addInfoMessage(String message, MessageTree parent, MessageTree.IssueNode data) {
        return this.addTerminalMessage(message, NodeKind.Info, parent, data);
    }

    public MessageTree addFailureMessage(String message, MessageTree parent, MessageTree.IssueNode data) {
        return this.addTerminalMessage(message, NodeKind.Failure, parent, data);
    }

    public MessageTree addTypeMessage(String message, MessageTree parent, MessageTree.IssueNode data) {
        return this.addTerminalMessage(message, NodeKind.File, parent, data);
    }

    private MessageTree addTerminalMessage(String message, NodeKind kind, MessageTree parent, MessageTree.IssueNode data) {
        MessageTree tree = new MessageTree(message, kind, data);
        if (parent == null) {
            parent = (MessageTree)this._tree.getModel().getRoot();
        }
        parent.addViaModel(tree);
        return tree;
    }

    public void appendToTop(MessageTree message) {
        MessageTree child;
        MessageTree root = (MessageTree)this._tree.getModel().getRoot();
        AbstractTree csr = null;
        Iterator iterator = root.getChildren().iterator();
        while (iterator.hasNext() && (child = (MessageTree)iterator.next()).isTerminal()) {
            csr = child;
        }
        if (csr == null) {
            root.insertViaModel(message, 0);
        } else {
            MessageTree parent = (MessageTree)csr.getParent();
            parent.insertViaModel(message, parent.getIndex(csr) + 1);
        }
    }

    public void insertAtTop(MessageTree message) {
        MessageTree root = (MessageTree)this._tree.getModel().getRoot();
        root.insertViaModel(message, 0);
    }

    public void expandAll() {
        this.expandAll(0, this._tree.getRowCount());
    }

    void expandAll(int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            this._tree.expandRow(i);
        }
        if (this._tree.getRowCount() != rowCount) {
            this.expandAll(rowCount, this._tree.getRowCount());
        }
    }

    public boolean hasErrors() {
        return ((MessageTree)this.getTree().getModel().getRoot()).hasErrors();
    }

    private class TreeKeyHandler
    implements KeyListener {
        private TreeKeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            MessageTree selection;
            if (e.getKeyCode() == 10 && (selection = MessagesPanel.this.getSelectedTree()) != null && selection.isTerminal()) {
                ((MessageTree.IssueNode)selection.getNode()).jumpToTarget();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class MouseHandler
    implements MouseListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MessageTree tree;
            Object data;
            TreePath selectionPath;
            if (e.getClickCount() == 2 && (selectionPath = MessagesPanel.this._tree.getSelectionPath()) != null && (data = (tree = (MessageTree)selectionPath.getLastPathComponent()).getNode()) != null && data.hasTarget()) {
                data.jumpToTarget();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleContextMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleContextMenu(e);
        }

        private void handleContextMenu(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int row = MessagesPanel.this._tree.getRowForLocation(e.getX(), e.getY());
                TreePath path = MessagesPanel.this._tree.getPathForLocation(e.getX(), e.getY());
                MessagesPanel.this._tree.setSelectionPath(path);
                if (row > -1) {
                    MessagesPanel.this._tree.setSelectionRow(row);
                    EventQueue.invokeLater(() -> new MessageTreeContextMenu().displayContextMenu((MessageTree)path.getLastPathComponent(), e.getX(), e.getY(), (Component)MessagesPanel.this._tree));
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

