/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BeanInfoNode;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeInfoUtil;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.JavaTypes;

public class MethodNode
extends BeanInfoNode {
    private IMethodInfo _mi;

    public MethodNode(IMethodInfo mi) {
        super((IType)new FunctionType(mi));
        this._mi = mi;
    }

    @Override
    public String getDisplayName() {
        return this._mi.getDisplayName() + this.getParameterDisplay() + " : " + MethodNode.getTypeName(this.getReturnType());
    }

    private IType getReturnType() {
        IType retType = ((IFunctionType)this.getType()).getReturnType();
        if (retType != JavaTypes.pVOID() && this._mi instanceof IJavaMethodInfo) {
            retType = this._mi.getReturnType();
        }
        return retType;
    }

    @Override
    public String getName() {
        return this._mi.getDisplayName() + this.getParameterDisplay();
    }

    @Override
    public IFeatureInfo getFeatureInfo() {
        return this._mi;
    }

    @Override
    protected int getTypePriority() {
        return 1;
    }

    public IMethodInfo getMethodDescriptor() {
        return this._mi;
    }

    public String getParameterDisplay() {
        IParameterInfo[] pd = this._mi.getParameters();
        if (pd == null || pd.length == 0) {
            return TypeInfoUtil.getTypeVarList((IFeatureInfo)this._mi, (boolean)true) + "()";
        }
        StringBuilder sbParams = new StringBuilder();
        sbParams.append(TypeInfoUtil.getTypeVarList((IFeatureInfo)this._mi, (boolean)true)).append("(");
        for (int i = 0; i < pd.length; ++i) {
            String strType;
            String strName = pd[i].getName();
            sbParams.append(i == 0 ? "" : ", ").append(strName);
            boolean bBlock = pd[i].getFeatureType() instanceof IBlockType;
            String string = strType = bBlock ? ((IBlockType)pd[i].getFeatureType()).getRelativeNameSansBlock() : pd[i].getFeatureType().getRelativeName();
            if (bBlock) {
                sbParams.append(strType);
                continue;
            }
            sbParams.append(" : ").append(strType);
        }
        sbParams.append(")");
        return sbParams.toString();
    }
}

