/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.plugin.typeloader.ITypeFactory;
import editor.util.EditorUtilities;
import editor.util.SmartMenuItem;
import editor.util.SourceFileCreator;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class NewFilePopup
extends JPopupMenu {
    public NewFilePopup() {
        NewFilePopup.addMenuItems(this);
    }

    public static void addMenuItems(JComponent popup) {
        NewFilePopup.addNewItem(popup, "Class", "images/class.png", () -> SourceFileCreator.instance().create(ClassType.Class));
        NewFilePopup.addNewItem(popup, "Enum", "images/enum.png", () -> SourceFileCreator.instance().create(ClassType.Enum));
        popup.add(new JPopupMenu.Separator());
        NewFilePopup.addNewItem(popup, "Interface", "images/interface.png", () -> SourceFileCreator.instance().create(ClassType.Interface));
        NewFilePopup.addNewItem(popup, "Structure", "images/structure.png", () -> SourceFileCreator.instance().create(ClassType.Structure));
        NewFilePopup.addNewItem(popup, "Annotation", "images/annotation.png", () -> SourceFileCreator.instance().create(ClassType.Annotation));
        popup.add(new JPopupMenu.Separator());
        NewFilePopup.addNewItem(popup, "Program", "images/program.png", () -> SourceFileCreator.instance().create(ClassType.Program));
        NewFilePopup.addNewItem(popup, "Template", "images/template.png", () -> SourceFileCreator.instance().create(ClassType.Template));
        popup.add(new JPopupMenu.Separator());
        NewFilePopup.addNewItem(popup, "Enhancement", "images/Enhancement.png", () -> SourceFileCreator.instance().create(ClassType.Enhancement));
        popup.add(new JPopupMenu.Separator());
        NewFilePopup.addNewItem(popup, "Namespace", "images/folder.png", () -> SourceFileCreator.instance().createNamespace());
        popup.add(new JPopupMenu.Separator());
        EventQueue.invokeLater(() -> NewFilePopup.addCustomTypes(popup));
    }

    private static void addCustomTypes(JComponent popup) {
        for (ITypeLoader tl : TypeSystem.getAllTypeLoaders()) {
            ITypeFactory factory = (ITypeFactory)tl.getInterface(ITypeFactory.class);
            if (factory == null || !factory.canCreate()) continue;
            NewFilePopup.addNewItem(popup, factory.getName(), factory.getIcon(), () -> SourceFileCreator.instance().create(factory));
        }
        popup.add(new JPopupMenu.Separator());
        NewFilePopup.addNewItem(popup, "Java Class", "images/javaclass.png", () -> SourceFileCreator.instance().create(ClassType.JavaClass));
        popup.add(new JPopupMenu.Separator());
        NewFilePopup.addNewItem(popup, "File", "images/FileText.png", () -> SourceFileCreator.instance().createTextFile());
    }

    private static void addNewItem(JComponent popup, String name, String icon, final Runnable action) {
        SmartMenuItem item = new SmartMenuItem(new AbstractAction(name, EditorUtilities.loadIcon(icon)){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.run();
            }
        });
        popup.add(item);
    }
}

