/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditorPlatformHelper;
import editor.LabFrame;
import editor.SplashScreen;
import editor.util.Experiment;
import editor.util.SettleModalEventQueue;
import gw.config.CommonServices;
import gw.config.IPlatformHelper;
import gw.config.IService;
import gw.lang.Gosu;
import gw.lang.gosuc.GosucModule;
import gw.lang.init.GosuInitialization;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.util.PathUtil;
import java.awt.EventQueue;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class RunMe {
    public static void main(String[] args) throws Exception {
        RunMe.launchEditor();
    }

    public static void launchEditor() throws Exception {
        EventQueue.invokeLater(() -> {
            LabFrame.loadSettings();
            SplashScreen.instance().setFeedbackText("Initializing...");
            LabFrame.create();
            RunMe.reinitializeGosu(null);
            LabFrame.instance().checkForUpdate(LabFrame.instance().getGosuPanel());
            LabFrame.instance().restoreState(LabFrame.instance().loadRecentExperiment(LabFrame.instance().getGosuPanel()));
            SettleModalEventQueue.instance().run();
            SplashScreen.instance().dispose();
            LabFrame.instance().showMe();
        });
    }

    public static void reinitializeGosu(Experiment experiment) {
        CommonServices.getKernel().redefineService_Privileged(IPlatformHelper.class, (IService)new GosuEditorPlatformHelper());
        IExecutionEnvironment execEnv = TypeSystem.getExecutionEnvironment();
        GosuInitialization gosuInitialization = GosuInitialization.instance((IExecutionEnvironment)execEnv);
        GosucModule gosucModule = new GosucModule("_default_", experiment == null ? Collections.emptyList() : experiment.getSourcePath(), RunMe.deriveClasspath(experiment), RunMe.deriveBackingSourcePath(experiment), "", Collections.emptyList(), Collections.emptyList());
        gosuInitialization.reinitializeSimpleIde(gosucModule);
    }

    private static List<String> deriveClasspath(Experiment experiment) {
        ArrayList<String> classpath = new ArrayList<String>();
        List<Object> sourcePath = experiment == null ? Collections.emptyList() : experiment.getSourcePath();
        for (String string : sourcePath) {
            if (string.toLowerCase().startsWith(PathUtil.getAbsolutePathName((Path)experiment.getExperimentDir()).toLowerCase() + File.separator)) continue;
            classpath.add(string);
        }
        List collect = Gosu.deriveClasspathFrom(LabFrame.class).stream().map(File::getAbsolutePath).collect(Collectors.toList());
        classpath.addAll(collect);
        return classpath;
    }

    private static List<String> deriveBackingSourcePath(Experiment experiment) {
        ArrayList<String> backingSource = new ArrayList<String>();
        List<Object> sourcePath = experiment == null ? Collections.emptyList() : experiment.getBackingSourcePath();
        for (String string : sourcePath) {
            if (string.toLowerCase().startsWith(PathUtil.getAbsolutePathName((Path)experiment.getExperimentDir()).toLowerCase() + File.separator)) continue;
            backingSource.add(string);
        }
        List collect = Gosu.findJreSources();
        backingSource.addAll(collect);
        backingSource = new ArrayList(new HashSet(backingSource));
        return backingSource;
    }
}

