/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.EditorHost;
import editor.ScriptEditorUndoItem;
import editor.undo.AtomicUndoManager;
import editor.undo.StagedStateEdit;
import java.awt.EventQueue;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.StateEdit;

public class ScriptChangeHandler
implements UndoableEditListener,
CaretListener {
    private AtomicUndoManager _undoMgr;
    private JTextComponent _editor;
    private boolean _bDirty;
    private boolean _bPaused;
    private int _iLineNumber;
    private boolean _bLineChanged;
    private int _iBefore;
    private int _iAfter;
    private boolean _bCaretPosChangeIsEdit;
    private DocumentEvent.EventType _eventType;

    public ScriptChangeHandler(AtomicUndoManager undoMgr) {
        this._undoMgr = undoMgr;
        this._bDirty = false;
    }

    public void establishUndoableEditListener(EditorHost editor) {
        editor.setUndoableEditListener(this);
        editor.getEditor().addCaretListener(this);
        this._editor = editor.getEditor();
    }

    public void establishUndoableEditListener(JTextComponent editor) {
        editor.getDocument().addUndoableEditListener(this);
        editor.addCaretListener(this);
        this._editor = editor;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.addEditorUndoItem(e);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.isPaused()) {
            return;
        }
        this.updatePositionInfo();
        this._bCaretPosChangeIsEdit = false;
        AtomicUndoManager.DisplayableCompoundEdit undoAtom = this._undoMgr.getUndoAtom();
        if (undoAtom != null && ((CompoundEdit)undoAtom).getPresentationName().equals("Text Change")) {
            EventQueue.invokeLater(() -> {
                if (!this._bCaretPosChangeIsEdit && undoAtom == this._undoMgr.getUndoAtom()) {
                    this._undoMgr.endUndoAtom();
                }
            });
        }
    }

    void updatePositionInfo() {
        this._iBefore = this._iAfter;
        this._iAfter = this._editor.getCaretPosition();
        int iCurrentLine = this._editor.getDocument().getDefaultRootElement().getElementIndex(this._iAfter);
        this._bLineChanged = iCurrentLine != this._iLineNumber;
        this._iLineNumber = iCurrentLine;
    }

    public int getBefore() {
        return this._iBefore;
    }

    public int getAfter() {
        return this._iAfter;
    }

    protected void setDirty(boolean bDirty) {
        this._bDirty = bDirty;
    }

    public boolean isDirty() {
        return this._bDirty;
    }

    protected void setPaused(boolean bPaused) {
        this._bPaused = bPaused;
    }

    public boolean isPaused() {
        return this._bPaused;
    }

    public JTextComponent getEditor() {
        return this._editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEditorUndoItem(UndoableEditEvent e) {
        if (this.isPaused()) {
            return;
        }
        this._bCaretPosChangeIsEdit = true;
        AtomicUndoManager.DisplayableCompoundEdit undoAtom = this._undoMgr.getUndoAtom();
        if (e.getEdit() instanceof DocumentEvent) {
            DocumentEvent docEvent = (DocumentEvent)((Object)e.getEdit());
            try {
                if (docEvent.getLength() > 1 || docEvent.getType() != this._eventType || this._bLineChanged) {
                    undoAtom = this._undoMgr.getUndoAtom();
                    if (undoAtom != null && ((CompoundEdit)undoAtom).getPresentationName().equals("Text Change")) {
                        this._undoMgr.endUndoAtom();
                        undoAtom = null;
                    }
                    if (docEvent.getLength() > 1) {
                        this.addDocEditChange(e);
                        return;
                    }
                }
            }
            finally {
                this._eventType = docEvent.getType();
            }
        }
        if (undoAtom == null || !((CompoundEdit)undoAtom).getPresentationName().equals("Text Change")) {
            this._undoMgr.beginUndoAtom("Text Change");
            final AtomicUndoManager.DisplayableCompoundEdit newUndoAdtom = this._undoMgr.getUndoAtom();
            this._undoMgr.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (ScriptChangeHandler.this.isPaused()) {
                        return;
                    }
                    if (ScriptChangeHandler.this._undoMgr.getUndoAtom() == newUndoAdtom) {
                        ScriptChangeHandler.this._undoMgr.removeChangeListener(this);
                        ScriptChangeHandler.this._undoMgr.endUndoAtom();
                    } else if (!newUndoAdtom.isInProgress()) {
                        ScriptChangeHandler.this._undoMgr.removeChangeListener(this);
                    }
                }
            });
        }
        this.addDocEditChange(e);
    }

    private void addDocEditChange(UndoableEditEvent e) {
        ScriptEditorUndoItem undoItem = new ScriptEditorUndoItem(this, e.getEdit());
        this.addUndoItem(new StagedStateEdit(undoItem, "Text Change"));
    }

    private void addUndoItem(StateEdit transaction) {
        this.setDirty(true);
        transaction.end();
        this.setPaused(true);
        try {
            this._undoMgr.addEdit(transaction);
        }
        finally {
            this.setPaused(false);
        }
    }
}

