/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.IContextMenuHandler;
import editor.IScriptEditor;
import editor.PopupHandler;
import java.awt.Component;
import java.awt.Point;

public class ScriptEditorPopupHandler
extends PopupHandler<IScriptEditor> {
    public ScriptEditorPopupHandler(IScriptEditor scriptEditor, IContextMenuHandler<IScriptEditor> contextMenuHandler) {
        super(scriptEditor, contextMenuHandler);
    }

    @Override
    protected void handleRightClick(int iXPos, int iYPos, Component component) {
        Point pt = new Point(iXPos, iYPos);
        int iPosition = ((IScriptEditor)this._owner).getEditor().viewToModel(pt);
        if (iPosition < 0) {
            iPosition = ((IScriptEditor)this._owner).getEditor().getDocument().getLength() - 1;
        }
        if (!this.isInSelection(iPosition)) {
            ((IScriptEditor)this._owner).getEditor().setCaretPosition(iPosition);
        }
        ((IScriptEditor)this._owner).getEditor().requestFocus();
        super.handleRightClick(iXPos, iYPos, component);
    }

    private boolean isInSelection(int iPosition) {
        if (((IScriptEditor)this._owner).getEditor().getSelectionStart() == ((IScriptEditor)this._owner).getEditor().getSelectionEnd()) {
            return false;
        }
        return iPosition >= ((IScriptEditor)this._owner).getEditor().getSelectionStart() && iPosition <= ((IScriptEditor)this._owner).getEditor().getSelectionEnd();
    }
}

