/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.Scheme;
import editor.TypeCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SelectClassToImportPopup
extends JPopupMenu {
    private static SelectClassToImportPopup _instance = new SelectClassToImportPopup();
    private JList _list;
    private JPanel _pane = new JPanel();
    private ClassSelectionCallback _callBack = null;
    private JLabel _labelTypeName;

    private SelectClassToImportPopup() {
        super("Select Class To Import");
        this.initLayout();
    }

    public static SelectClassToImportPopup instance() {
        return _instance;
    }

    public JList getList() {
        return this._list;
    }

    public void show(Component invoker, Rectangle rectangle, Set<String> possibleTypesToImport, ClassSelectionCallback callback, String label, ListCellRenderer cellRenderer) {
        this.setLabel(label);
        this._list.setCellRenderer(cellRenderer);
        this._labelTypeName.setText(label);
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (String s : possibleTypesToImport) {
            listModel.addElement(s);
        }
        this._list.setModel(listModel);
        this._list.setSelectedIndex(0);
        if (rectangle != null) {
            this.show(invoker, rectangle.x, rectangle.y);
            SwingUtilities.invokeLater(() -> this._list.requestFocus(true));
        }
        this._callBack = callback;
    }

    protected void initLayout() {
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        GridBagLayout gridBag = new GridBagLayout();
        this._pane.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        int iY = 0;
        this._labelTypeName = new JLabel("Select Class To Import");
        this._labelTypeName.setOpaque(true);
        this._labelTypeName.setBackground(Scheme.active().getControl());
        this._labelTypeName.setFont(this._labelTypeName.getFont().deriveFont(1));
        this._labelTypeName.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this._pane.add((Component)this._labelTypeName, c);
        this._list = new JList();
        this._list.addMouseListener(new MenuMouseListener());
        this._list.setCellRenderer(new TypeCellRenderer(this._list));
        this._list.getSelectionModel().setSelectionMode(0);
        this._list.setVisibleRowCount(10);
        JScrollPane scrollPane = new JScrollPane(this._list);
        scrollPane.setBorder(UIManager.getBorder("TextField.border"));
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this._pane.add((Component)scrollPane, c);
        this.add(this._pane);
        EditorKeyListener listener = new EditorKeyListener();
        this.addKeyListener(listener);
        this._list.addKeyListener(listener);
    }

    public void setSelection(String strSelection) {
        List<String> suggestionNames = this.getPopupSuggestions();
        for (int currentIndex = 0; currentIndex < suggestionNames.size(); ++currentIndex) {
            if (!suggestionNames.get(currentIndex).equals(strSelection)) continue;
            this._list.setSelectedIndex(currentIndex);
            this.notifyOfSelection((String)this._list.getSelectedValue());
            break;
        }
    }

    public List<String> getPopupSuggestions() {
        ArrayList<String> suggestionList = new ArrayList<String>();
        ListModel listObjects = this._list.getModel();
        for (int i = 0; i < listObjects.getSize(); ++i) {
            suggestionList.add(listObjects.getElementAt(i).toString());
        }
        return suggestionList;
    }

    private void notifyOfSelection(String classToImport) {
        this._callBack.onSelection(classToImport);
    }

    public static interface ClassSelectionCallback {
        public void onSelection(String var1);
    }

    class MenuMouseListener
    extends MouseAdapter {
        MenuMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int iIndex = SelectClassToImportPopup.this._list.locationToIndex(e.getPoint());
            if (iIndex < 0) {
                return;
            }
            SelectClassToImportPopup.this._list.setSelectedIndex(iIndex);
            String classToImport = (String)SelectClassToImportPopup.this._list.getSelectedValue();
            SelectClassToImportPopup.this.notifyOfSelection(classToImport);
        }
    }

    class EditorKeyListener
    extends KeyAdapter {
        EditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 224 || e.getKeyCode() == 37 || e.getKeyCode() == 226) {
                Action selectPrevious = SelectClassToImportPopup.this._list.getActionMap().get("selectPreviousRow");
                selectPrevious.actionPerformed(new ActionEvent(SelectClassToImportPopup.this._list, 0, "selectPreviousRow"));
                e.consume();
            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 225 || e.getKeyCode() == 39 || e.getKeyCode() == 227) {
                Action selectNext = SelectClassToImportPopup.this._list.getActionMap().get("selectNextRow");
                selectNext.actionPerformed(new ActionEvent(SelectClassToImportPopup.this._list, 0, "selectNextRow"));
                e.consume();
            } else if (e.getKeyCode() == 33) {
                Action scrollUpChangeSelection = SelectClassToImportPopup.this._list.getActionMap().get("scrollUp");
                scrollUpChangeSelection.actionPerformed(new ActionEvent(SelectClassToImportPopup.this._list, 0, "scrollUp"));
                e.consume();
            } else if (e.getKeyCode() == 34) {
                Action scrollDownChangeSelection = SelectClassToImportPopup.this._list.getActionMap().get("scrollDown");
                scrollDownChangeSelection.actionPerformed(new ActionEvent(SelectClassToImportPopup.this._list, 0, "scrollDown"));
                e.consume();
            } else if (e.getKeyCode() == 10 || e.getKeyCode() == 32 || e.getKeyCode() == 9) {
                String typeName = (String)SelectClassToImportPopup.this._list.getSelectedValue();
                if (typeName != null) {
                    SelectClassToImportPopup.this.notifyOfSelection(typeName);
                }
                SelectClassToImportPopup.this.setVisible(false);
                e.consume();
            } else if (e.getKeyCode() == 27) {
                SelectClassToImportPopup.this.setVisible(false);
                e.consume();
            }
        }
    }
}

