/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.EditorHost;
import editor.EditorHostTextPane;
import editor.EditorScrollPane;
import editor.ILineInfoManager;
import editor.MouseInEditorHandler;
import editor.ParserFeedbackPanel;
import editor.Scheme;
import editor.ScriptEditorMouseWheelHandler;
import editor.ScrollableEditorRootPane;
import editor.plugin.typeloader.ITypeFactory;
import editor.undo.AtomicUndoManager;
import editor.util.EditorUtilities;
import gw.lang.IIssueContainer;
import gw.lang.parser.ISymbolTable;
import gw.lang.reflect.IType;
import gw.util.GosuStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;

public class StandardEditor
extends EditorHost {
    private EditorScrollPane _scroller;
    private DocumentHandler _docHandler = new DocumentHandler();
    private EditorHostTextPane _editor;
    private ParserFeedbackPanel _panelFeedback;
    private ITypeFactory _factory;
    private IType _type;

    public StandardEditor(ILineInfoManager lineInfoRenderer, IType type) {
        super(new AtomicUndoManager(1000));
        this._type = type;
        if (lineInfoRenderer != null) {
            lineInfoRenderer.setEditor(this);
        }
        this.configUi(lineInfoRenderer);
    }

    private void configUi(ILineInfoManager lineInfoRenderer) {
        this.setLayout(new BorderLayout());
        this._editor = new EditorHostTextPane(this);
        ToolTipManager.sharedInstance().registerComponent(this._editor);
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        this._editor.setFont(new Font(EditorUtilities.getFontFamilyOrDefault("Consolas", "Monospaced"), 0, 12));
        this.setBorder(UIManager.getBorder("TextField.border"));
        this._editor.setMargin(new Insets(3, 3, 3, 3));
        this._editor.setForeground(Scheme.active().getCodeWindowText());
        this._editor.setBackground(Scheme.active().getCodeWindow());
        this._editor.putClientProperty("caretWidth", 2);
        SimpleAttributeSet sas = new SimpleAttributeSet();
        StyleConstants.setLineSpacing(sas, -0.2f);
        this._editor.setCaretColor(Scheme.active().getCodeWindowText());
        this.configureEditorKit(this._type);
        ScrollableEditorRootPane editorRootScroller = new ScrollableEditorRootPane(this._editor);
        editorRootScroller.setContentPane(this._editor);
        editorRootScroller.setBorder(null);
        this._scroller = new EditorScrollPane(lineInfoRenderer, this._editor, editorRootScroller);
        this._scroller.setBorder(null);
        JViewport vp = this._scroller.getViewport();
        vp.setScrollMode(1);
        this.add((Component)this._scroller, "Center");
        JLabel label = new JLabel("");
        label.setFont(label.getFont().deriveFont(1));
        label.setBorder(new EmptyBorder(0, 20, 0, 0));
        this.add((Component)label, "North");
        this._panelFeedback = new ParserFeedbackPanel();
        this.add("East", this._panelFeedback);
        this._editor.addKeyListener(new EditorHost.EditorKeyHandler());
        this._editor.addMouseWheelListener(new ScriptEditorMouseWheelHandler(this));
        MouseInEditorHandler mouseInEditorHandler = new MouseInEditorHandler(this);
        this._editor.addMouseListener(mouseInEditorHandler);
        this._editor.addMouseMotionListener(mouseInEditorHandler);
        this._editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StandardEditor.this.setCompleteCode(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                StandardEditor.this.setCompleteCode(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                StandardEditor.this.setCompleteCode(false);
            }
        });
        this.addDocumentListener();
        this.addKeyHandlers();
    }

    @Override
    protected void handleDot(ISymbolTable transientSymTable) {
    }

    @Override
    public ISymbolTable getSymbolTableAtCursor() {
        return null;
    }

    @Override
    public void gotoDeclaration() {
    }

    @Override
    public boolean canAddBreakpoint(int line) {
        return this._factory.canAddBreakpoint(this._type, line);
    }

    private void configureEditorKit(IType type) {
        if (type == null) {
            return;
        }
        this._factory = (ITypeFactory)type.getTypeLoader().getInterface(ITypeFactory.class);
        if (this._factory == null) {
            return;
        }
        StyledEditorKit kit = this._factory.makeEditorKit();
        if (kit == null) {
            return;
        }
        String mimeType = "text/" + this._factory.getFileExtension().substring(1);
        this._editor.setEditorKitForContentType(mimeType, kit);
        this._editor.setContentType(mimeType);
    }

    @Override
    public void refresh(String content) {
        content = GosuStringUtil.replace((String)content, (String)"\r\n", (String)"\n");
        this.getEditor().setText(content);
        EventQueue.invokeLater(() -> this.getUndoManager().discardAllEdits());
    }

    @Override
    public EditorHostTextPane getEditor() {
        return this._editor;
    }

    @Override
    public EditorScrollPane getScroller() {
        return this._scroller;
    }

    @Override
    public String getLineCommentDelimiter() {
        return "//";
    }

    @Override
    public int getOffsetOfDeepestStatementLocationAtPos(int caretPosition, boolean strict) {
        Element root = this.getDocument().getDefaultRootElement();
        int iElem = root.getElementIndex(caretPosition);
        if (iElem < 0) {
            return -1;
        }
        Element elem = root.getElement(iElem);
        try {
            int lineStart = elem.getStartOffset();
            int lineEnd = elem.getEndOffset();
            String text = this.getDocument().getText(lineStart, lineEnd - lineStart);
            String trimmed = text.trim();
            int whitespace = text.indexOf(trimmed);
            if (whitespace == text.length()) {
                return -1;
            }
            return lineStart + whitespace;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getTypeAtLine(int line) {
        if (this._factory != null) {
            return this._factory.getTypeAtOffset(this._type, this.getLineOffset(line));
        }
        return null;
    }

    @Override
    public String getTooltipMessage(MouseEvent event) {
        if (this._factory == null) {
            return null;
        }
        int iPos = this.getEditor().viewToModel(event.getPoint());
        return this._factory.getTooltipMessage(iPos, this);
    }

    @Override
    public IIssueContainer getIssues() {
        return this._factory.getIssueContainer(this);
    }

    @Override
    public DocumentListener getDocHandler() {
        return this._docHandler;
    }

    @Override
    public JComponent getFeedbackPanel() {
        return this._panelFeedback;
    }

    @Override
    public void parse(String strText, boolean forceCodeCompletion, boolean changed) {
        if (this._factory != null) {
            this._factory.parse(this._type, strText, forceCodeCompletion, changed, this);
            EventQueue.invokeLater(() -> this._panelFeedback.update(this));
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            StandardEditor.this.parse();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            StandardEditor.this.parse();
        }
    }
}

