/*
 * Decompiled with CFR 0.152.
 */
package editor.debugger;

import editor.DefaultContextMenuHandler;
import editor.EditorHost;
import editor.EditorHostTextPane;
import editor.EditorScrollPane;
import editor.GosuEditor;
import editor.GosuPanel;
import editor.GotoExceptionTypePopup;
import editor.IHandleCancel;
import editor.LabFrame;
import editor.Scheme;
import editor.debugger.Breakpoint;
import editor.debugger.BreakpointCellRenderer;
import editor.debugger.BreakpointManager;
import editor.debugger.BreakpointTree;
import editor.debugger.Debugger;
import editor.debugger.ExceptionBreakpointFactory;
import editor.debugger.LineBreakpointFactory;
import editor.splitpane.CollapsibleSplitPane;
import editor.tabpane.TabPane;
import editor.tabpane.TabPosition;
import editor.tabpane.ToolContainer;
import editor.undo.AtomicUndoManager;
import editor.util.EditorUtilities;
import editor.util.LabButton;
import editor.util.LabToolbarButton;
import editor.util.SettleModalEventQueue;
import editor.util.ToolBar;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ScriptabilityModifiers;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.TypelessScriptPartId;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.JavaTypes;
import gw.util.ContextSymbolTableUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class BreakpointsDialog
extends JDialog
implements IHandleCancel {
    private static BreakpointsDialog _current;
    private JTree _tree;
    private JButton _btnViewSource;
    private JPanel _configPanel;
    private AbstractButton _btnPlus;
    private Map<Breakpoint, JPanel> _mapToPanel = new HashMap<Breakpoint, JPanel>();
    private Runnable _listener;
    private BreakpointTree _exceptionBpTree;
    private JCheckBox _cbRunScript;
    private JCheckBox _cbSuspend;
    private JCheckBox _cbUncaught;
    private JCheckBox _cbCaught;
    private JLabel _labelCondition;
    private GosuEditor _fieldExpr;
    private GosuEditor _fieldRunScript;

    public static BreakpointsDialog getOrCreate(Breakpoint bp) {
        if (_current == null) {
            _current = new BreakpointsDialog(bp);
        }
        return _current;
    }

    public static BreakpointsDialog getOrCreate() {
        if (_current == null) {
            _current = new BreakpointsDialog();
        }
        return _current;
    }

    private BreakpointsDialog(Breakpoint bp) {
        this();
        this.selectBreakpoint(bp);
    }

    private BreakpointsDialog() {
        super((Frame)LabFrame.instance(), "Breakpoints");
        this.configUi();
        this.setDefaultCloseOperation(2);
        this.addCloseListener();
    }

    private void selectBreakpoint(Breakpoint bp) {
        if (bp == null) {
            return;
        }
        BreakpointTree tree = ((BreakpointTree)this._tree.getModel().getRoot()).find(bp);
        this._tree.setSelectionPath(tree.getPath());
    }

    protected void configUi() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        contentPane.setLayout(new BorderLayout());
        this._configPanel = new JPanel(new BorderLayout());
        TabPane configTabPane = new TabPane(TabPosition.TOP, 7);
        configTabPane.addTab("Settings", null, this._configPanel);
        JPanel buttonPanel = this.makeButtonPanel();
        CollapsibleSplitPane splitPane = new CollapsibleSplitPane(0, this.createBreakpointsList(), configTabPane);
        this.add((Component)splitPane, "Center");
        splitPane.setPosition(35.0);
        contentPane.add((Component)splitPane, "Center");
        JPanel south = new JPanel(new BorderLayout());
        south.setBackground(Scheme.active().getMenu());
        south.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        JPanel filler = new JPanel();
        filler.setBackground(Scheme.active().getMenu());
        south.add((Component)filler, "Center");
        south.add((Component)buttonPanel, "East");
        contentPane.add((Component)south, "South");
        contentPane.setBackground(Scheme.active().getMenu());
        this.mapCancelKeystroke("Close", this::close);
        this.setSize(800, 500);
        EditorUtilities.centerWindowInFrame(this, this.getOwner());
    }

    private void addCloseListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                BreakpointManager bpm = BreakpointsDialog.this.getGosuPanel().getBreakpointManager();
                bpm.removeChangeLisener(BreakpointsDialog.this._listener);
                _current = null;
            }
        });
    }

    private JPanel createConfigPanel(Breakpoint bp) {
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        int iY = 0;
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        this._cbSuspend = new JCheckBox("Suspend");
        EventQueue.invokeLater(() -> this._cbSuspend.setSelected(bp.isSuspend()));
        this._cbSuspend.addActionListener(e -> {
            boolean selected = this._cbSuspend.isSelected();
            bp.setSuspend(selected);
            this._labelCondition.setEnabled(selected);
            this._fieldExpr.setEnabled(selected);
        });
        configPanel.add((Component)this._cbSuspend, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 5, 10);
        this._labelCondition = new JLabel("Condition:");
        configPanel.add((Component)this._labelCondition, c);
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.3;
        c.insets = new Insets(0, 0, 5, 0);
        IType type = TypeSystem.getByFullNameIfValidNoJava((String)bp.getFqn());
        this._fieldExpr = new GosuEditor((ISymbolTable)(type instanceof IGosuClass && bp.getLine() > 0 ? ContextSymbolTableUtil.getSymbolTableAtOffset((IGosuClass)((IGosuClass)type), (int)bp.getOffset()) : new StandardSymbolTable(true)), null, new AtomicUndoManager(10000), (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE, new DefaultContextMenuHandler(), false, true);
        this._fieldExpr.setExpectedType((IType)JavaTypes.pBOOLEAN());
        this.addEscapeHandler(this._fieldExpr);
        this._fieldExpr.setAccessAll(true);
        try {
            String expr = bp.getExpression();
            this._fieldExpr.read((IScriptPartId)new TypelessScriptPartId("debugger condition"), expr == null ? "" : expr);
            EventQueue.invokeLater(this._fieldExpr::parse);
            this._fieldExpr.getEditor().getDocument().addDocumentListener(new DocHandler(bp, true));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(30, 30));
        panel.add((Component)this._fieldExpr, "Center");
        configPanel.add((Component)panel, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 0, 5);
        this._cbRunScript = new JCheckBox("Run script");
        EventQueue.invokeLater(() -> this._cbRunScript.setSelected(bp.isRunScriptOn()));
        this._cbRunScript.addActionListener(e -> {
            boolean selected = this._cbRunScript.isSelected();
            bp.setRunScriptOn(selected);
            this._fieldRunScript.setEnabled(selected);
        });
        configPanel.add((Component)this._cbRunScript, c);
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.7;
        c.insets = new Insets(0, 0, 10, 0);
        type = TypeSystem.getByFullNameIfValidNoJava((String)bp.getFqn());
        this._fieldRunScript = new GosuEditor((ISymbolTable)(type instanceof IGosuClass && bp.getLine() > 0 ? ContextSymbolTableUtil.getSymbolTableAtOffset((IGosuClass)((IGosuClass)type), (int)bp.getOffset()) : new StandardSymbolTable(true)), null, new AtomicUndoManager(10000), (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE, new DefaultContextMenuHandler(), false, true);
        this.addEscapeHandler(this._fieldRunScript);
        this._fieldRunScript.setAccessAll(true);
        try {
            String expr = bp.getRunScript();
            this._fieldRunScript.read((IScriptPartId)new TypelessScriptPartId("debugger run script"), expr == null ? "" : expr);
            EventQueue.invokeLater(this._fieldRunScript::parse);
            this._fieldRunScript.getEditor().getDocument().addDocumentListener(new DocHandler(bp, false));
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
        panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(30, 30));
        panel.add((Component)this._fieldRunScript, "Center");
        configPanel.add((Component)panel, c);
        if (bp.isExceptionBreakpoint()) {
            c.anchor = 17;
            c.fill = 0;
            c.gridx = 0;
            c.gridy = iY++;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(10, 0, 5, 10);
            this._cbCaught = new JCheckBox("Caught exception");
            this._cbCaught.setSelected(bp.isCaughtException());
            this._cbCaught.addActionListener(e -> {
                bp.setCaughtException(this._cbCaught.isSelected());
                this.updateBreakpointJdi(bp);
            });
            configPanel.add((Component)this._cbCaught, c);
            c.anchor = 17;
            c.fill = 0;
            c.gridx = 0;
            c.gridy = iY;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 5, 10);
            this._cbUncaught = new JCheckBox("Uncaught exception");
            this._cbUncaught.setSelected(bp.isUncaughtException());
            this._cbUncaught.addActionListener(e -> {
                bp.setUncaughtException(this._cbUncaught.isSelected());
                this.updateBreakpointJdi(bp);
            });
            configPanel.add((Component)this._cbUncaught, c);
        }
        return configPanel;
    }

    private void addEscapeHandler(final GosuEditor gosuEditor) {
        gosuEditor.getEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 && !gosuEditor.isCompletionPopupShowing()) {
                    BreakpointsDialog.this.close();
                }
            }
        });
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(Scheme.active().getMenu());
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.addRunButton(buttonPanel);
        this.addSeparator(buttonPanel);
        LabButton btnClose = new LabButton("Close");
        btnClose.addActionListener(e -> this.close());
        buttonPanel.add(btnClose);
        this.getRootPane().setDefaultButton(btnClose);
        return buttonPanel;
    }

    private void addSeparator(JPanel buttonPanel) {
        JPanel separator = new JPanel();
        separator.setBackground(Scheme.active().getMenu());
        separator.setMinimumSize(new Dimension(8, 8));
        buttonPanel.add(separator);
    }

    private void addRunButton(JPanel buttonPanel) {
        this._btnViewSource = new LabButton("View Source");
        this._btnViewSource.setMnemonic('V');
        this._btnViewSource.addActionListener(new ViewSourceAction());
        buttonPanel.add(this._btnViewSource);
        this.getRootPane().setDefaultButton(this._btnViewSource);
        this._btnViewSource.setEnabled(false);
    }

    private JComponent createBreakpointsList() {
        DefaultTreeModel model = new DefaultTreeModel(this.makeBreakpointTree());
        this._tree = new JTree(model);
        this._tree.setBackground(Scheme.active().getWindow());
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.setRowHeight(22);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setVisibleRowCount(20);
        this._tree.setCellRenderer(new BreakpointCellRenderer(this._tree));
        JScrollPane scroller = new JScrollPane(this._tree);
        scroller.setBorder(BorderFactory.createEmptyBorder());
        this.expandAll();
        this._tree.addTreeSelectionListener(e -> {
            Breakpoint bp = this.getSelectedBreakpoint();
            if (bp != null) {
                this._btnViewSource.setEnabled(bp.isLineBreakpoint());
                this.updateConfigPanel();
                this._configPanel.setVisible(true);
            } else {
                this._btnViewSource.setEnabled(false);
                this._configPanel.setVisible(false);
            }
        });
        this._tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BreakpointTree bpTree = BreakpointsDialog.this.getSelectedValue();
                if (bpTree == null) {
                    return;
                }
                Breakpoint bp = bpTree.getBreakpoint();
                if (bp == null) {
                    return;
                }
                BreakpointCellRenderer renderer = (BreakpointCellRenderer)BreakpointsDialog.this._tree.getCellRenderer();
                TreePath selectionPath = BreakpointsDialog.this._tree.getSelectionPath();
                renderer.getTreeCellRendererComponent(BreakpointsDialog.this._tree, bpTree, true, true, true, BreakpointsDialog.this._tree.getRowForPath(selectionPath), true);
                renderer.setBounds(BreakpointsDialog.this._tree.getPathBounds(selectionPath));
                renderer.doLayout();
                if (renderer.getCheckbox().contains(e.getX() - renderer.getX(), e.getY() % renderer.getHeight())) {
                    EditorHost editor;
                    bp.setActive(!bp.isActive());
                    BreakpointsDialog.this._tree.repaint();
                    BreakpointManager bpm = BreakpointsDialog.this.getGosuPanel().getBreakpointManager();
                    Breakpoint csr = bpm.getBreakpoint(bp);
                    if (csr != null) {
                        csr.setActive(bp.isActive());
                    }
                    if ((editor = BreakpointsDialog.this.getGosuPanel().getGosuEditor()) != null) {
                        List<EditorScrollPane.AdviceColumn> columns = EditorUtilities.findDecendents(editor, EditorScrollPane.AdviceColumn.class);
                        for (JComponent jComponent : columns) {
                            jComponent.repaint();
                        }
                    }
                }
            }
        });
        BreakpointManager bpm = this.getGosuPanel().getBreakpointManager();
        this._listener = this::updateBreakpoints;
        bpm.addChangeListener(this._listener);
        TabPane tabPane = new TabPane(TabPosition.TOP, 7);
        tabPane.addTab("Breakpoints", null, scroller);
        ToolContainer toolbar = tabPane.getToolContainer();
        this.addTools(toolbar.getToolBar());
        return tabPane;
    }

    public void expandAll() {
        this.expandAll(0, this._tree.getRowCount());
    }

    private void expandAll(int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            this._tree.expandRow(i);
        }
        if (this._tree.getRowCount() != rowCount) {
            this.expandAll(rowCount, this._tree.getRowCount());
        }
    }

    private BreakpointTree makeBreakpointTree() {
        BreakpointTree root = new BreakpointTree();
        BreakpointTree lineBpTree = new BreakpointTree(LineBreakpointFactory.instance(), root);
        root.addChild(lineBpTree);
        this._exceptionBpTree = new BreakpointTree(ExceptionBreakpointFactory.instance(), root);
        root.addChild(this._exceptionBpTree);
        BreakpointManager bpm = this.getGosuPanel().getBreakpointManager();
        for (Breakpoint bp : bpm.getLineBreakpoints()) {
            lineBpTree.addChild(new BreakpointTree(bp, lineBpTree));
        }
        for (Breakpoint bp : bpm.getExceptionBreakpoints()) {
            this._exceptionBpTree.addChild(new BreakpointTree(bp, this._exceptionBpTree));
        }
        return root;
    }

    private void updateBreakpointJdi(Breakpoint bp) {
        Debugger debugger = this.getGosuPanel().getDebugger();
        if (debugger != null) {
            debugger.removeBreakpointJdi(bp);
            debugger.addBreakpointJdi(bp);
        }
    }

    private void updateBreakpoints() {
        Breakpoint bp = this.getSelectedBreakpoint();
        this._tree.setModel(new DefaultTreeModel(this.makeBreakpointTree()));
        BreakpointTree tree = ((BreakpointTree)this._tree.getModel().getRoot()).find(bp);
        if (tree != null) {
            tree.select(this._tree);
        }
    }

    private void updateConfigPanel() {
        Breakpoint bp;
        if (this._configPanel.getComponentCount() > 0) {
            this._configPanel.remove(0);
        }
        if ((bp = this.getSelectedBreakpoint()) == null) {
            return;
        }
        JPanel panel = this._mapToPanel.get(bp);
        if (panel == null) {
            panel = this.createConfigPanel(bp);
            this._mapToPanel.put(bp, panel);
        }
        this._configPanel.add((Component)panel, "Center");
        this._configPanel.validate();
        this._configPanel.repaint();
    }

    private Breakpoint getSelectedBreakpoint() {
        BreakpointTree bpTree = this.getSelectedValue();
        return bpTree == null ? null : bpTree.getBreakpoint();
    }

    private BreakpointTree getSelectedValue() {
        return this._tree.getSelectionPath() == null ? null : (BreakpointTree)this._tree.getSelectionPath().getLastPathComponent();
    }

    private void addTools(ToolBar tb) {
        int i = 0;
        this._btnPlus = this.makeButton(new AddBreakpointAction());
        tb.add((Component)this._btnPlus, i++);
        LabToolbarButton btnMinus = this.makeButton(new RemoveBreakpointAction());
        tb.add((Component)btnMinus, i);
    }

    public static BreakpointsDialog getShowing() {
        return _current;
    }

    private void addExceptionBreakpoint(String fqn) {
        BreakpointManager bpm = this.getGosuPanel().getBreakpointManager();
        if (bpm.getExceptionBreakpoint(fqn) == null) {
            Breakpoint bp = bpm.addExceptionBreakpoint(fqn);
            this._exceptionBpTree.addViaModel(this._tree, new BreakpointTree(bp, this._exceptionBpTree));
        }
        this.selectBreakpoint(bpm.getExceptionBreakpoint(fqn));
    }

    private LabToolbarButton makeButton(Action action) {
        LabToolbarButton item = new LabToolbarButton(null, null, 2, 0);
        item.setAction(action);
        return item;
    }

    protected void close() {
        this.dispose();
    }

    private GosuPanel getGosuPanel() {
        return LabFrame.instance().getGosuPanel();
    }

    private class DocHandler
    implements DocumentListener {
        private final Breakpoint _bp;
        private final boolean _bExpr;

        private DocHandler(Breakpoint bp, boolean bExpr) {
            this._bp = bp;
            this._bExpr = bExpr;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            try {
                String text = e.getDocument().getText(0, e.getDocument().getLength());
                if (this._bExpr) {
                    this._bp.setExpression(text);
                } else {
                    this._bp.setRunScript(text);
                }
            }
            catch (BadLocationException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private class ViewSourceAction
    extends AbstractAction {
        private ViewSourceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Breakpoint bp = BreakpointsDialog.this.getSelectedBreakpoint();
            if (bp != null) {
                int iLine;
                String strType = bp.getFqn();
                BreakpointsDialog.this.getGosuPanel().openType(strType, false);
                SettleModalEventQueue.instance().run();
                EditorHost currentEditor = BreakpointsDialog.this.getGosuPanel().getCurrentEditor();
                if (currentEditor != null && (iLine = bp.getLine()) >= 1) {
                    EditorHostTextPane editor = currentEditor.getEditor();
                    Element root = editor.getDocument().getRootElements()[0];
                    iLine = root.getElementCount() < iLine ? root.getElementCount() : iLine;
                    Element line = root.getElement(iLine - 1);
                    ((JTextComponent)editor).setCaretPosition(line.getStartOffset());
                }
            }
        }
    }

    private class RemoveBreakpointAction
    extends AbstractAction {
        public RemoveBreakpointAction() {
            super("Remove", EditorUtilities.loadIcon("images/minus.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            TreePath[] indexes = BreakpointsDialog.this._tree.getSelectionPaths();
            int row = BreakpointsDialog.this._tree.getRowForPath(indexes[0]);
            TreePath parent = indexes[0].getParentPath();
            for (int i = indexes.length - 1; i >= 0; --i) {
                BreakpointTree bpTree = (BreakpointTree)indexes[i].getLastPathComponent();
                Breakpoint bp = bpTree.getBreakpoint();
                if (bp == null) continue;
                bpTree.getParent().deleteViaModel(BreakpointsDialog.this._tree, bpTree);
                BreakpointManager bpm = BreakpointsDialog.this.getGosuPanel().getBreakpointManager();
                bpm.removeBreakpoint(bp);
                BreakpointsDialog.this._mapToPanel.remove(bp);
                EditorHost editor = BreakpointsDialog.this.getGosuPanel().getCurrentEditor();
                if (editor == null) continue;
                editor.repaint();
            }
            if (row < BreakpointsDialog.this._tree.getRowCount()) {
                BreakpointsDialog.this._tree.expandPath(parent);
                BreakpointTree bpTree = (BreakpointTree)BreakpointsDialog.this._tree.getPathForRow(row).getLastPathComponent();
                if (bpTree.getBreakpoint() != null) {
                    BreakpointsDialog.this._tree.setSelectionRow(row);
                } else {
                    BreakpointsDialog.this._tree.setSelectionRow(row - 1);
                }
            } else {
                BreakpointsDialog.this._tree.expandPath(parent);
                BreakpointsDialog.this._tree.setSelectionRow(row - 1);
            }
            BreakpointsDialog.this._tree.scrollPathToVisible(BreakpointsDialog.this.getSelectedValue().getPath());
        }

        @Override
        public boolean isEnabled() {
            if (BreakpointsDialog.this._tree.getSelectionCount() > 0) {
                Breakpoint bp = ((BreakpointTree)BreakpointsDialog.this._tree.getSelectionPath().getLastPathComponent()).getBreakpoint();
                return bp != null && !bp.isStatic();
            }
            return false;
        }
    }

    private class AddBreakpointAction
    extends AbstractAction {
        public AddBreakpointAction() {
            super("Add", EditorUtilities.loadIcon("images/plus.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GotoExceptionTypePopup.display(BreakpointsDialog.this._btnPlus, 0, BreakpointsDialog.this._btnPlus.getHeight(), x$0 -> BreakpointsDialog.this.addExceptionBreakpoint(x$0));
        }
    }
}

