/*
 * Decompiled with CFR 0.152.
 */
package editor.debugger;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import editor.AbstractListCellRenderer;
import editor.CommonMenus;
import editor.FileTreeUtil;
import editor.GosuEditor;
import editor.GosuPanel;
import editor.LabFrame;
import editor.Scheme;
import editor.ToggleToolBarButton;
import editor.debugger.BreakpointManager;
import editor.debugger.Debugger;
import editor.debugger.VarTree;
import editor.debugger.VarTreeCellRenderer;
import editor.run.IRunConfig;
import editor.splitpane.CollapsibleSplitPane;
import editor.tabpane.TabPane;
import editor.tabpane.TabPosition;
import editor.tabpane.ToolContainer;
import editor.util.EditorUtilities;
import editor.util.HTMLEscapeUtil;
import editor.util.IDisposable;
import editor.util.LabToolbarButton;
import editor.util.ToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeModel;

public class DebugPanel
extends JPanel
implements IDisposable {
    private JComboBox<ThreadReference> _cbThreads;
    private JList<StackFrameRef> _listFrames;
    private JTree _varTree;
    private List<Consumer<Location>> _listeners;
    private Debugger _debugger;

    public DebugPanel(Debugger debugger) {
        this._debugger = debugger;
        debugger.addChangeListener(e -> EventQueue.invokeLater(() -> this.debuggerChanged(debugger)));
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this._listeners = new ArrayList<Consumer<Location>>();
        CollapsibleSplitPane splitPane = new CollapsibleSplitPane(0, this.makeThreadsPanel(), this.makeVariablesAndWatchesPanel());
        this.add((Component)splitPane, "Center");
        this.add((Component)this.makeRunToolbar(), "West");
        splitPane.setPosition(30.0);
    }

    @Override
    public void dispose() {
        this.getGosuPanel().killProcess();
    }

    private JComponent makeThreadsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this._cbThreads = new JComboBox();
        this._cbThreads.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Scheme.active().getControlShadow()));
        this._cbThreads.setRenderer(new ThreadCellRenderer(this._cbThreads.getRenderer()));
        this._cbThreads.addActionListener(action -> this.threadChanged());
        this._cbThreads.setFocusable(false);
        panel.add(this._cbThreads, "North");
        DefaultListModel model = new DefaultListModel();
        this._listFrames = new JList(model);
        this._listFrames.setBackground(Scheme.active().getWindow());
        this._listFrames.getSelectionModel().setSelectionMode(0);
        this._listFrames.setFixedCellHeight(22);
        this._listFrames.setCellRenderer(new StackFrameCellRenderer());
        this._listFrames.addListSelectionListener(e -> this.updateVars());
        JScrollPane scroller = new JScrollPane(this._listFrames);
        scroller.setBorder(null);
        panel.add((Component)scroller, "Center");
        TabPane tabPane = new TabPane(TabPosition.TOP, 5);
        tabPane.addTab("Threads", EditorUtilities.loadIcon("images/thread.png"), panel);
        return tabPane;
    }

    private JComponent makeRunToolbar() {
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.setBackground(Scheme.active().getMenu());
        toolbarPanel.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        ToolBar toolbar = new ToolBar(1);
        LabToolbarButton item = new LabToolbarButton(new CommonMenus.ClearAndRunActionHandler(() -> this.getGosuPanel().getRunConfig()));
        item.setToolTipSupplier(() -> {
            IRunConfig rc = this.getGosuPanel().getRunConfig();
            return rc == null ? "Run..." : "Run '" + rc.getName() + "'";
        });
        toolbar.add(item);
        item = new LabToolbarButton(new CommonMenus.ClearAndDebugActionHandler(() -> this.getGosuPanel().getRunConfig()));
        item.setToolTipSupplier(() -> {
            IRunConfig rc = this.getGosuPanel().getRunConfig();
            return rc == null ? "Debug..." : "Debug '" + rc.getName() + "'";
        });
        toolbar.add(item);
        item = new LabToolbarButton(new CommonMenus.StopActionHandler(this::getGosuPanel));
        toolbar.add(item);
        item = new LabToolbarButton(new CommonMenus.PauseActionHandler(this::getDebugger));
        toolbar.add(item);
        item = new LabToolbarButton(new CommonMenus.ResumeActionHandler(this::getDebugger));
        toolbar.add(item);
        toolbar.addSeparator();
        item = new LabToolbarButton(new CommonMenus.ViewBreakpointsActionHandler(() -> null));
        toolbar.add(item);
        ToggleToolBarButton titem = new ToggleToolBarButton(new CommonMenus.MuteBreakpointsActionHandler(this::getBreakpointManager));
        toolbar.add(titem);
        toolbarPanel.add((Component)toolbar, "Center");
        return toolbarPanel;
    }

    public Debugger getDebugger() {
        return this._debugger;
    }

    public void addLocationListener(Consumer<Location> listener) {
        this._listeners.add(listener);
    }

    public void removeLocationListener(Consumer<Location> listener) {
        this._listeners.remove(listener);
    }

    private void fireLocationChange(Location loc) {
        for (Consumer<Location> listener : this._listeners) {
            listener.accept(loc);
        }
    }

    private void debuggerChanged(Debugger debugger) {
        if (debugger.isSuspended() || debugger.isPaused()) {
            this.suspended(debugger.getThreads(), debugger.getSuspendedThread());
        } else {
            this.resumed();
        }
    }

    private void suspended(List<ThreadReference> threads, ThreadReference thread) {
        this.updateThreads(threads, thread);
    }

    private void updateThreads(List<ThreadReference> threads, ThreadReference thread) {
        this._cbThreads.setModel(this.makeThreadModel(threads));
        if (thread != null) {
            this._cbThreads.setSelectedItem(thread);
        } else if (threads != null && threads.size() > 0) {
            this._cbThreads.setSelectedIndex(0);
        } else {
            this._cbThreads.setSelectedItem(null);
        }
    }

    private void resumed() {
        this.updateThreads(new ArrayList<ThreadReference>(), null);
        this.threadChanged();
    }

    private void updateVars() {
        StackFrameRef frame = this._listFrames.getSelectedValue();
        DefaultTreeModel model = new DefaultTreeModel(new VarTree(frame));
        this._varTree.setModel(model);
        if (frame == null) {
            return;
        }
        this.fireLocationChange(frame.getRef().location());
    }

    private void threadChanged() {
        ThreadReference thread = (ThreadReference)this._cbThreads.getSelectedItem();
        try {
            if (thread != null) {
                this._listFrames.setModel(this.makeThreadsModel(thread.frames()));
                this._listFrames.setSelectedIndex(0);
            } else {
                this._listFrames.setModel(this.makeThreadsModel(Collections.emptyList()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ListModel<StackFrameRef> makeThreadsModel(List<StackFrame> frames) {
        DefaultListModel<StackFrameRef> model = new DefaultListModel<StackFrameRef>();
        int[] i = new int[]{0};
        frames.forEach(e -> {
            int n = i[0];
            i[0] = n + 1;
            model.addElement(new StackFrameRef(n));
        });
        return model;
    }

    private ComboBoxModel<ThreadReference> makeThreadModel(List<ThreadReference> threads) {
        return new DefaultComboBoxModel<ThreadReference>(threads.toArray(new ThreadReference[threads.size()]));
    }

    private JComponent makeVariablesAndWatchesPanel() {
        TabPane framePane = this.makeFramePane();
        TabPane watchesPane = this.makeWatchesPane();
        CollapsibleSplitPane varPanel = new CollapsibleSplitPane(0, framePane, watchesPane);
        varPanel.setPosition(50.0);
        varPanel.toggleCollapse(watchesPane);
        return varPanel;
    }

    private TabPane makeWatchesPane() {
        TabPane watchesTabPane = new TabPane(TabPosition.TOP, 7);
        watchesTabPane.addTab("Watches", null, new JPanel());
        return watchesTabPane;
    }

    private TabPane makeFramePane() {
        this._varTree = new JTree(new DefaultTreeModel(new VarTree(null)));
        this._varTree.setBorder(null);
        this._varTree.setBackground(Scheme.active().getWindow());
        this._varTree.setRootVisible(false);
        this._varTree.setShowsRootHandles(true);
        this._varTree.setRowHeight(22);
        this._varTree.getSelectionModel().setSelectionMode(1);
        this._varTree.setVisibleRowCount(20);
        this._varTree.setCellRenderer(new VarTreeCellRenderer(this._varTree));
        JScrollPane scroller = new JScrollPane(this._varTree);
        scroller.setBorder(null);
        TabPane varTabPane = new TabPane(TabPosition.TOP, 7);
        varTabPane.addTab("Frame", EditorUtilities.loadIcon("images/single_frame.png"), scroller);
        ToolContainer toolbar = varTabPane.getToolContainer();
        this.addTools(toolbar.getToolBar());
        return varTabPane;
    }

    private void addTools(ToolBar tb) {
        int i = 0;
        LabToolbarButton item = this.makeButton(new CommonMenus.EvaluateExpressionActionHandler(this::getDebugger));
        tb.add((Component)item, i++);
        item = this.makeButton(new CommonMenus.ShowExecPointActionHandler(this::getDebugger));
        tb.add((Component)item, i++);
        tb.add((Component)this.makeSeparator(), i++);
        item = this.makeButton(new CommonMenus.StepOverActionHandler(this::getDebugger));
        tb.add((Component)item, i++);
        item = this.makeButton(new CommonMenus.StepIntoActionHandler(this::getDebugger));
        tb.add((Component)item, i++);
        item = this.makeButton(new CommonMenus.StepOutActionHandler(this::getDebugger));
        tb.add((Component)item, i++);
        tb.add((Component)this.makeSeparator(), i++);
        item = this.makeButton(new CommonMenus.DropFrameActionHandler(this::getDebugger, this::getDropToFrame));
        tb.add((Component)item, i++);
        tb.add((Component)this.makeSeparator(), i++);
        item = this.makeButton(new CommonMenus.RunToCursorActionHandler(this::getDebugger, this::getBreakpointManager, this::getCurrentGosuEditor));
        tb.add((Component)item, i);
    }

    private LabToolbarButton makeButton(Action action) {
        LabToolbarButton item = new LabToolbarButton(null, null, 2, 0);
        item.setAction(action);
        return item;
    }

    private JSeparator makeSeparator() {
        JSeparator separator = new JSeparator(1);
        separator.setMaximumSize(new Dimension(4, 20));
        return separator;
    }

    private GosuEditor getCurrentGosuEditor() {
        return this.getGosuPanel().getCurrentGosuEditor();
    }

    private GosuPanel getGosuPanel() {
        return LabFrame.instance().getGosuPanel();
    }

    private BreakpointManager getBreakpointManager() {
        return this.getGosuPanel().getBreakpointManager();
    }

    public StackFrame getDropToFrame() {
        StackFrameRef ref = this._listFrames.getSelectedValue();
        StackFrame frame = ref.getRef();
        if (this.isFilteredClass(frame.location().declaringType())) {
            frame = null;
        }
        return frame;
    }

    public ThreadReference getSelectedThread() {
        return (ThreadReference)this._cbThreads.getSelectedItem();
    }

    private boolean isFilteredClass(ReferenceType referenceType) {
        String fqn = Debugger.getOutermostType(referenceType);
        return FileTreeUtil.find(fqn) == null;
    }

    public class StackFrameRef {
        private final int _index;

        StackFrameRef(int index) {
            this._index = index;
        }

        StackFrame getRef() {
            try {
                if (!((ThreadReference)DebugPanel.this._cbThreads.getSelectedItem()).isSuspended()) {
                    return null;
                }
            }
            catch (VMDisconnectedException vde) {
                return null;
            }
            try {
                return ((ThreadReference)DebugPanel.this._cbThreads.getSelectedItem()).frame(this._index);
            }
            catch (IncompatibleThreadStateException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ThreadCellRenderer
    implements ListCellRenderer<ThreadReference> {
        private ListCellRenderer<ThreadReference> _delegate;

        private ThreadCellRenderer(ListCellRenderer delegate) {
            this._delegate = delegate;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ThreadReference> list, ThreadReference thread, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel cell = (JLabel)this._delegate.getListCellRendererComponent(list, null, index, isSelected, cellHasFocus);
            try {
                if (thread != null && thread.isSuspended()) {
                    String text = "<html><b>" + thread.name() + "</b> @" + thread.uniqueID() + " group: <b>" + thread.threadGroup().name() + "</b> - <i>" + Thread.State.values()[thread.status()].name() + "</i>";
                    cell.setText(text);
                    cell.setIcon(EditorUtilities.loadIcon("images/thread.png"));
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
            return cell;
        }
    }

    private class StackFrameCellRenderer
    extends AbstractListCellRenderer<StackFrameRef> {
        private StackFrameCellRenderer() {
            super(DebugPanel.this._listFrames);
        }

        @Override
        public void configure() {
            this.setBorder(new EmptyBorder(0, 2, 0, 0));
            StackFrame frame = ((StackFrameRef)this.getNode()).getRef();
            if (frame != null) {
                String fqn;
                Location loc;
                try {
                    loc = frame.location();
                }
                catch (InvalidStackFrameException e) {
                    return;
                }
                String className = fqn = loc.declaringType().name();
                String pkg = "";
                int iDot = fqn.lastIndexOf(46);
                if (iDot > 0) {
                    pkg = fqn.substring(0, iDot);
                    className = fqn.substring(iDot + 1);
                }
                Color textColor = DebugPanel.this._listFrames.getForeground();
                String hex = !DebugPanel.this.isFilteredClass(frame.location().declaringType()) ? String.format("#%02x%02x%02x", textColor.getRed(), textColor.getGreen(), textColor.getBlue()) : "#7F8C8D";
                String text = "<html><font color= " + hex + ">" + HTMLEscapeUtil.escape(loc.method().name()) + "():" + loc.lineNumber() + ", " + className + "<i>(" + pkg + ")</i></font>";
                this.setText(text);
                this.setIcon(EditorUtilities.loadIcon("images/single_frame.png"));
            }
        }
    }
}

