/*
 * Decompiled with CFR 0.152.
 */
package editor.plugin.typeloader.java;

import editor.Scheme;
import editor.util.HTMLEscapeUtil;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;

public class JavaDocument
extends DefaultStyledDocument {
    private Element _root = this.getDefaultRootElement();
    private MutableAttributeSet _word;
    private MutableAttributeSet _keyword;
    private MutableAttributeSet _error;
    private MutableAttributeSet _warning;
    private MutableAttributeSet _comment;
    private MutableAttributeSet _stringLiteral;
    private boolean _multiLineComment;
    private Set<String> _keywords;
    private DiagnosticCollector<JavaFileObject> _errorHandler;

    public JavaDocument() {
        this.putProperty("__EndOfLine__", "\n");
        this._word = new SimpleAttributeSet();
        StyleConstants.setForeground(this._word, Scheme.active().getCodeWindowText());
        this._error = new SimpleAttributeSet();
        StyleConstants.setForeground(this._error, Scheme.active().getCodeError());
        this._warning = new SimpleAttributeSet();
        StyleConstants.setForeground(this._warning, Scheme.active().getCodeWarning());
        this._keyword = new SimpleAttributeSet();
        StyleConstants.setForeground(this._keyword, Scheme.active().getCodeKeyword());
        StyleConstants.setBold(this._keyword, true);
        this._comment = new SimpleAttributeSet();
        StyleConstants.setForeground(this._comment, Scheme.active().getCodeComment());
        this._stringLiteral = new SimpleAttributeSet();
        StyleConstants.setForeground(this._stringLiteral, Scheme.active().getCodeStringLiteral());
        this._keywords = new HashSet<String>();
        this._keywords.add("abstract");
        this._keywords.add("assert");
        this._keywords.add("boolean");
        this._keywords.add("break");
        this._keywords.add("byte");
        this._keywords.add("case");
        this._keywords.add("catch");
        this._keywords.add("char");
        this._keywords.add("class");
        this._keywords.add("continue");
        this._keywords.add("default");
        this._keywords.add("do");
        this._keywords.add("double");
        this._keywords.add("else");
        this._keywords.add("enum");
        this._keywords.add("extends");
        this._keywords.add("final");
        this._keywords.add("finally");
        this._keywords.add("float");
        this._keywords.add("for");
        this._keywords.add("if");
        this._keywords.add("implements");
        this._keywords.add("import");
        this._keywords.add("instanceof");
        this._keywords.add("int");
        this._keywords.add("interface");
        this._keywords.add("long");
        this._keywords.add("native");
        this._keywords.add("new");
        this._keywords.add("null");
        this._keywords.add("package");
        this._keywords.add("private");
        this._keywords.add("protected");
        this._keywords.add("public");
        this._keywords.add("return");
        this._keywords.add("short");
        this._keywords.add("static");
        this._keywords.add("strictfp");
        this._keywords.add("super");
        this._keywords.add("switch");
        this._keywords.add("synchronized");
        this._keywords.add("this");
        this._keywords.add("throws");
        this._keywords.add("transient");
        this._keywords.add("try");
        this._keywords.add("void");
        this._keywords.add("volatile");
        this._keywords.add("while");
        this._keywords.add("true");
        this._keywords.add("false");
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        switch (str) {
            case "(": {
                str = this.addParenthesis();
                break;
            }
            case "\n": {
                str = this.addWhiteSpace(offset);
                break;
            }
            case "\"": {
                str = this.addMatchingQuotationMark();
                break;
            }
            case "{": {
                str = this.addMatchingBrace(offset);
            }
        }
        super.insertString(offset, str, a);
        this.processChangedLines(offset, str.length());
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, 0);
    }

    private void processChangedLines(int offset, int length) throws BadLocationException {
        String content = this.getText(0, this.getLength());
        int startLine = this._root.getElementIndex(offset);
        int endLine = this._root.getElementIndex(offset + length);
        this.setMultiLineComment(this.commentLinesBefore(content, startLine));
        for (int i = startLine; i <= endLine; ++i) {
            this.applyHighlighting(content, i);
        }
        if (this.isMultiLineComment()) {
            this.commentLinesAfter(content, endLine);
        } else {
            this.highlightLinesAfter(content, endLine);
        }
    }

    private boolean commentLinesBefore(String content, int line) {
        int offset = this._root.getElement(line).getStartOffset();
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), offset - 2);
        if (startDelimiter < 0) {
            return false;
        }
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), startDelimiter);
        if (endDelimiter < offset & endDelimiter != -1) {
            return false;
        }
        this.setCharacterAttributes(startDelimiter, offset - startDelimiter + 1, this._comment, false);
        return true;
    }

    private void commentLinesAfter(String content, int line) {
        int offset = this._root.getElement(line).getEndOffset();
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (endDelimiter < 0) {
            return;
        }
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), endDelimiter);
        if (startDelimiter < 0 || startDelimiter <= offset) {
            this.setCharacterAttributes(offset, endDelimiter - offset + 1, this._comment, false);
        }
    }

    private void highlightLinesAfter(String content, int line) throws BadLocationException {
        int delimiter;
        int offset = this._root.getElement(line).getEndOffset();
        int startDelimiter = this.indexOf(content, this.getStartDelimiter(), offset);
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (startDelimiter < 0) {
            startDelimiter = content.length();
        }
        if (endDelimiter < 0) {
            endDelimiter = content.length();
        }
        if ((delimiter = Math.min(startDelimiter, endDelimiter)) < offset) {
            return;
        }
        int endLine = this._root.getElementIndex(delimiter);
        for (int i = line + 1; i < endLine; ++i) {
            Element branch = this._root.getElement(i);
            Element leaf = this.getCharacterElement(branch.getStartOffset());
            AttributeSet as = leaf.getAttributes();
            if (!as.isEqual(this._comment)) continue;
            this.applyHighlighting(content, i);
        }
    }

    private void applyHighlighting(String content, int line) throws BadLocationException {
        int startOffset = this._root.getElement(line).getStartOffset();
        int endOffset = this._root.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        int contentLength = content.length();
        if (endOffset >= contentLength) {
            endOffset = contentLength - 1;
        }
        if (this.endingMultiLineComment(content, startOffset, endOffset) || this.isMultiLineComment() || this.startingMultiLineComment(content, startOffset, endOffset)) {
            this.setCharacterAttributes(startOffset, endOffset - startOffset + 1, this._comment, false);
            return;
        }
        this.setCharacterAttributes(startOffset, lineLength, this._word, true);
        int index = content.indexOf(this.getSingleLineDelimiter(), startOffset);
        if (index > -1 && index < endOffset) {
            this.setCharacterAttributes(index, endOffset - index + 1, this._comment, false);
            endOffset = index - 1;
        }
        this.checkForTokens(content, startOffset, endOffset);
    }

    private boolean startingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        int index = this.indexOf(content, this.getStartDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(true);
        return true;
    }

    private boolean endingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        int index = this.indexOf(content, this.getEndDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(false);
        return true;
    }

    private boolean isMultiLineComment() {
        return this._multiLineComment;
    }

    private void setMultiLineComment(boolean value) {
        this._multiLineComment = value;
    }

    private void checkForTokens(String content, int startOffset, int endOffset) {
        while (startOffset <= endOffset) {
            while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                if (this.isError(startOffset)) {
                    this.setCharacterAttributes(startOffset, 1, this._error, true);
                } else if (this.isWarning(startOffset)) {
                    this.setCharacterAttributes(startOffset, 1, this._warning, true);
                }
                if (startOffset < endOffset) {
                    ++startOffset;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1))) {
                startOffset = this.getQuoteToken(content, startOffset, endOffset);
                continue;
            }
            if (this.isCharQuoteDelimiter(content.substring(startOffset, startOffset + 1))) {
                startOffset = this.getQuoteToken(content, startOffset, endOffset);
                continue;
            }
            startOffset = this.getOtherToken(content, startOffset, endOffset);
        }
    }

    private int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        int endOfQuote = startOffset;
        for (int endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
        }
        int index = content.indexOf(quoteDelimiter, endOfQuote + 1);
        endOfQuote = index < 0 || index > endOffset ? endOffset : index;
        if (this.isError(startOffset, endOfQuote - startOffset + 1)) {
            this.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, this._error, true);
            return endOfQuote + 1;
        }
        if (this.isWarning(startOffset, endOfQuote - startOffset + 1)) {
            this.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, this._warning, true);
            return endOfQuote + 1;
        }
        this.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, this._stringLiteral, false);
        return endOfQuote + 1;
    }

    private int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
        }
        String token = content.substring(startOffset, endOfToken);
        if (this.isError(startOffset, endOfToken - startOffset)) {
            this.setCharacterAttributes(startOffset, endOfToken - startOffset, this._error, true);
            return endOfToken + 1;
        }
        if (this.isWarning(startOffset, endOfToken - startOffset)) {
            this.setCharacterAttributes(startOffset, endOfToken - startOffset, this._warning, true);
            return endOfToken + 1;
        }
        if (this.isKeyword(token)) {
            this.setCharacterAttributes(startOffset, endOfToken - startOffset, this._keyword, false);
        }
        return endOfToken + 1;
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent evt) {
        super.fireInsertUpdate(evt);
        try {
            this.processChangedLines(evt.getOffset(), evt.getLength());
        }
        catch (Exception ex) {
            System.out.println("" + ex);
        }
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent evt) {
        super.fireRemoveUpdate(evt);
        try {
            this.processChangedLines(evt.getOffset(), evt.getLength());
        }
        catch (BadLocationException ex) {
            System.out.println("" + ex);
        }
    }

    private int indexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.indexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index + 1;
        }
        return index;
    }

    private int lastIndexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.lastIndexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index - 1;
        }
        return index;
    }

    private String getLine(String content, int offset) {
        int line = this._root.getElementIndex(offset);
        Element lineElement = this._root.getElement(line);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        return content.substring(start, end - 1);
    }

    protected boolean isDelimiter(String character) {
        String operands = ".;:()\\[]+-/%<=>!&|^~*";
        return Character.isWhitespace(character.charAt(0)) || operands.contains(character);
    }

    protected boolean isQuoteDelimiter(String character) {
        String quoteDelimiters = "\"";
        return quoteDelimiters.contains(character);
    }

    protected boolean isCharQuoteDelimiter(String character) {
        String quoteDelimiters = "'";
        return quoteDelimiters.contains(character);
    }

    protected boolean isKeyword(String token) {
        return this._keywords.contains(token);
    }

    protected String getStartDelimiter() {
        return "/*";
    }

    protected String getEndDelimiter() {
        return "*/";
    }

    protected String getSingleLineDelimiter() {
        return "//";
    }

    protected String addMatchingQuotationMark() throws BadLocationException {
        return "\"\"";
    }

    protected String addMatchingBrace(int offset) throws BadLocationException {
        String temp;
        StringBuilder whiteSpace = new StringBuilder();
        int line = this._root.getElementIndex(offset);
        int i = this._root.getElement(line).getStartOffset();
        while ((temp = this.getText(i, 1)).equals(" ") || temp.equals("\t")) {
            whiteSpace.append(temp);
            ++i;
        }
        return "{\n" + whiteSpace.toString() + "    \n" + whiteSpace.toString() + "}";
    }

    protected String addWhiteSpace(int offset) throws BadLocationException {
        String temp;
        StringBuilder whiteSpace = new StringBuilder();
        int line = this._root.getElementIndex(offset);
        int i = this._root.getElement(line).getStartOffset();
        while ((temp = this.getText(i, 1)).equals(" ") || temp.equals("\t")) {
            whiteSpace.append(temp);
            ++i;
        }
        return "\n" + whiteSpace;
    }

    protected String addParenthesis() throws BadLocationException {
        return "()";
    }

    public DiagnosticCollector<JavaFileObject> getErrorHandler() {
        return this._errorHandler;
    }

    public void setErrorHandler(DiagnosticCollector<JavaFileObject> errorHandler) {
        DiagnosticCollector<JavaFileObject> oldErrorHandler = this._errorHandler;
        this._errorHandler = errorHandler;
        this.processIssues(oldErrorHandler);
        this.processIssues(this._errorHandler);
    }

    private void processIssues(DiagnosticCollector<JavaFileObject> errorHandler) {
        if (errorHandler == null) {
            return;
        }
        for (Diagnostic<JavaFileObject> issue : errorHandler.getDiagnostics()) {
            try {
                this.processChangedLines((int)issue.getStartPosition(), (int)issue.getEndPosition() - (int)issue.getStartPosition());
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isError(int iPos) {
        return this.isError(iPos, 1);
    }

    private boolean isError(int iPos, int iLength) {
        if (this._errorHandler == null) {
            return false;
        }
        for (Diagnostic<JavaFileObject> issue : this._errorHandler.getDiagnostics()) {
            if (issue.getKind() != Diagnostic.Kind.ERROR || ((long)iPos < issue.getStartPosition() || (long)iPos > issue.getEndPosition()) && ((long)(iPos + iLength) < issue.getStartPosition() || (long)(iPos + iLength) > issue.getEndPosition())) continue;
            return true;
        }
        return false;
    }

    private boolean isWarning(int iPos) {
        return this.isWarning(iPos, 1);
    }

    private boolean isWarning(int iPos, int iLength) {
        if (this._errorHandler == null) {
            return false;
        }
        for (Diagnostic<JavaFileObject> issue : this._errorHandler.getDiagnostics()) {
            if (issue.getKind() != Diagnostic.Kind.WARNING && issue.getKind() != Diagnostic.Kind.MANDATORY_WARNING || ((long)iPos < issue.getStartPosition() || (long)iPos > issue.getEndPosition()) && ((long)(iPos + iLength) < issue.getStartPosition() || (long)(iPos + iLength) > issue.getEndPosition())) continue;
            return true;
        }
        return false;
    }

    public String findErrorMessage(int iPos) {
        if (this._errorHandler == null) {
            return null;
        }
        Element root = this.getDefaultRootElement();
        int index = root.getElementIndex(iPos);
        if (index < 0) {
            return null;
        }
        Element lineElement = root.getElement(index);
        if (lineElement == null) {
            return null;
        }
        int tokenIndex = lineElement.getElementIndex(iPos);
        if (tokenIndex < 0) {
            return null;
        }
        Element tokenElem = lineElement.getElement(tokenIndex);
        if (tokenElem == null) {
            return null;
        }
        if (tokenElem.getAttributes().containsAttributes(this._error) || tokenElem.getAttributes().containsAttributes(this._warning)) {
            for (Diagnostic<JavaFileObject> issue : this._errorHandler.getDiagnostics()) {
                if ((issue.getStartPosition() < (long)tokenElem.getStartOffset() || issue.getStartPosition() < (long)tokenElem.getEndOffset()) && (issue.getEndPosition() < (long)tokenElem.getStartOffset() || issue.getEndPosition() < (long)tokenElem.getEndOffset())) continue;
                return "<html>" + HTMLEscapeUtil.escape(issue.getMessage(Locale.getDefault()));
            }
        }
        return null;
    }
}

