/*
 * Decompiled with CFR 0.152.
 */
package editor.run;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.ListeningConnector;
import editor.run.AbstractOutOfProcessExecutor;
import editor.run.DebugTransport;
import editor.run.RemoteRunConfig;
import editor.run.RunState;
import java.util.List;
import java.util.Map;

public class OutOfProcessRemote
extends AbstractOutOfProcessExecutor<RemoteRunConfig> {
    public OutOfProcessRemote() {
        super(RunState.Debug);
    }

    @Override
    protected String exec() throws Exception {
        Connector conn = this.getConnector();
        Map<String, Connector.Argument> args = this.applyArgs(conn, ((RemoteRunConfig)this.getRunConfig()).getTransport());
        this.printLabMessage(this.makeMessage(args));
        if (conn instanceof AttachingConnector) {
            AttachingConnector attachingConn = (AttachingConnector)conn;
            this.setVm(attachingConn.attach(args));
            this.getGosuPanel().makeDebugger(this.getVm());
            return String.valueOf("Attached to: " + this.getVm().name());
        }
        ListeningConnector listeningConn = (ListeningConnector)conn;
        this.setVm(listeningConn.accept(args));
        this.getGosuPanel().makeDebugger(this.getVm());
        return String.valueOf("Accepted connection to: " + this.getVm().name());
    }

    private Connector getConnector() {
        VirtualMachineManager vmm = Bootstrap.virtualMachineManager();
        List<AttachingConnector> attachingConnectors = vmm.attachingConnectors();
        for (AttachingConnector conn : attachingConnectors) {
            DebugTransport transport = ((RemoteRunConfig)this.getRunConfig()).getTransport();
            if (!conn.name().equals(transport.getFqn())) continue;
            return conn;
        }
        List<ListeningConnector> listeningConnectors = vmm.listeningConnectors();
        for (ListeningConnector conn : listeningConnectors) {
            DebugTransport transport = ((RemoteRunConfig)this.getRunConfig()).getTransport();
            if (!conn.name().equals(transport.getFqn())) continue;
            return conn;
        }
        throw new IllegalStateException();
    }

    private Map<String, Connector.Argument> applyArgs(Connector conn, DebugTransport transport) {
        Map<String, Connector.Argument> args = conn.defaultArguments();
        switch (transport) {
            case AttachingSocket: 
            case ListeningSocket: {
                this.applySocketArgs(args);
                break;
            }
            case AttachingMemory: 
            case ListeningMemory: {
                this.applySharedMemoryArgs(args);
            }
        }
        return args;
    }

    private void applySharedMemoryArgs(Map<String, Connector.Argument> args) {
        RemoteRunConfig runConfig = (RemoteRunConfig)this.getRunConfig();
        Connector.Argument name = args.get("name");
        name.setValue(runConfig.getAddress());
    }

    private void applySocketArgs(Map<String, Connector.Argument> args) {
        Connector.Argument hostname;
        RemoteRunConfig runConfig = (RemoteRunConfig)this.getRunConfig();
        String host = runConfig.getHost();
        if (host != null && !host.isEmpty() && (hostname = args.get("hostname")) != null) {
            hostname.setValue(host);
        }
        Connector.Argument port = args.get("port");
        port.setValue(runConfig.getPort());
    }

    private String makeMessage(Map<String, Connector.Argument> args) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Connector.Argument> entry : args.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        sb.append('\n');
        sb.append("Attaching: ").append(((RemoteRunConfig)this.getRunConfig()).getName()).append("...\n");
        return sb.toString();
    }
}

