/*
 * Decompiled with CFR 0.152.
 */
package editor.run;

import editor.GotoProgramTypePopup;
import editor.LabFrame;
import editor.Scheme;
import editor.run.ProgramRunConfigParameters;
import editor.util.DirectoryEditor;
import editor.util.EditorUtilities;
import editor.util.LabCheckbox;
import editor.util.LabToolbarButton;
import editor.util.MoreTextEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

class ProgramConfigPanel
extends JPanel {
    private final ProgramRunConfigParameters _params;
    private final Consumer<ProgramRunConfigParameters> _changeListener;

    ProgramConfigPanel(ProgramRunConfigParameters params, Consumer<ProgramRunConfigParameters> changeListener) {
        super(new BorderLayout());
        this._params = params;
        this._changeListener = changeListener;
        this.configUi();
    }

    private void configUi() {
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        int iY = 0;
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        JLabel label = new JLabel("Name:");
        configPanel.add((Component)label, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        JTextField editName = new JTextField();
        editName.setText(this._params.getName());
        editName.getDocument().addDocumentListener(new DocChangeHandler(this::validateName, this._params::setName));
        configPanel.add((Component)editName, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        JPanel separator = new JPanel();
        separator.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Scheme.active().getSeparator2()));
        configPanel.add((Component)separator, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        label = new JLabel("Run type:");
        configPanel.add((Component)label, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        JTextField editFqn = new JTextField();
        editFqn.setText(this._params.getFqn());
        editFqn.getDocument().addDocumentListener(new DocChangeHandler(this::validateFqn, this._params::setFqn));
        configPanel.add((Component)editFqn, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 2;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 2, 10, 0);
        LabToolbarButton btn = new LabToolbarButton(EditorUtilities.loadIcon("images/program.png"));
        btn.setToolTipText("Find program");
        btn.addActionListener(e -> this.displayProgramPopup(editFqn));
        configPanel.add((Component)btn, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        label = new JLabel("VM arguments:");
        configPanel.add((Component)label, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        MoreTextEditor editVmArgs = new MoreTextEditor(label.getText(), true);
        editVmArgs.setText(this._params.getVmArgs());
        editVmArgs.getDocument().addDocumentListener(new DocChangeHandler(this::validateVmArgs, this._params::setVmArgs));
        configPanel.add((Component)editVmArgs, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        label = new JLabel("Program arguments:");
        configPanel.add((Component)label, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        MoreTextEditor editProgArgs = new MoreTextEditor(label.getText(), true);
        editProgArgs.setText(this._params.getProgArgs());
        editProgArgs.getDocument().addDocumentListener(new DocChangeHandler(this::validateProgArgs, this._params::setProgArgs));
        configPanel.add((Component)editProgArgs, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        label = new JLabel("Working directory:");
        configPanel.add((Component)label, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        DirectoryEditor editWorkingDir = new DirectoryEditor(label.getText(), this._params.getWorkingDir(), LabFrame::instance);
        editWorkingDir.getDocument().addDocumentListener(new DocChangeHandler(this::validateWorkingDir, this._params::setWorkingDir));
        configPanel.add((Component)editWorkingDir, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        LabCheckbox cbJre = new LabCheckbox("Use alternate JRE");
        cbJre.setSelected(this._params.isJreEnabled());
        cbJre.addChangeListener(e -> this._params.setJreEnabled(cbJre.isSelected()));
        configPanel.add((Component)cbJre, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        DirectoryEditor editJre = new DirectoryEditor(cbJre.getText(), this._params.getJre(), LabFrame::instance);
        editJre.getDocument().addDocumentListener(new DocChangeHandler(this::validateJre, this._params::setJre));
        EventQueue.invokeLater(() -> editJre.setEnabled(this._params.isJreEnabled()));
        cbJre.addChangeListener(e -> editJre.setEnabled(cbJre.isSelected()));
        configPanel.add((Component)editJre, c);
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        configPanel.add((Component)new JPanel(), c);
        this.add((Component)configPanel, "Center");
    }

    private void displayProgramPopup(JTextComponent fieldRunType) {
        GotoProgramTypePopup.display(fieldRunType, fieldRunType.getText(), fieldRunType::setText);
    }

    private String validateName(String text) {
        if (text == null || text.isEmpty()) {
            return "ERROR";
        }
        return null;
    }

    private String validateFqn(String text) {
        if (text == null || text.isEmpty()) {
            return "ERROR";
        }
        return null;
    }

    private String validateVmArgs(String text) {
        if (text == null || text.isEmpty()) {
            return "ERROR";
        }
        return null;
    }

    private String validateProgArgs(String text) {
        if (text == null || text.isEmpty()) {
            return "ERROR";
        }
        return null;
    }

    private String validateWorkingDir(String text) {
        if (text == null || text.isEmpty()) {
            return "ERROR";
        }
        return null;
    }

    private String validateJre(String text) {
        if (text == null || text.isEmpty()) {
            return "ERROR";
        }
        return null;
    }

    private class DocChangeHandler
    implements DocumentListener {
        Function<String, String> _validator;
        Consumer<String> _consumer;

        public DocChangeHandler(Function<String, String> validator, Consumer<String> consumer) {
            this._validator = validator;
            this._consumer = consumer;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            Document doc = e.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                String error = this._validator.apply(text);
                if (error != null) {
                    // empty if block
                }
                this._consumer.accept(text);
                ProgramConfigPanel.this._changeListener.accept(ProgramConfigPanel.this._params);
            }
            catch (BadLocationException e1) {
                throw new RuntimeException(e1);
            }
        }
    }
}

