/*
 * Decompiled with CFR 0.152.
 */
package editor.run;

import editor.Scheme;
import editor.run.DebugTransport;
import editor.run.RemoteRunConfigParameters;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

class RemoteConfigPanel
extends JPanel {
    private final RemoteRunConfigParameters _params;
    private final Consumer<RemoteRunConfigParameters> _changeListener;
    private JTextField _editAgentArgs;
    private JLabel _labelHost;
    private JTextField _editHost;
    private JLabel _labelPort;
    private JTextField _editName;
    private JLabel _labelAddress;
    private JTextField _editAddress;
    private JTextField _editPort;

    RemoteConfigPanel(RemoteRunConfigParameters params, Consumer<RemoteRunConfigParameters> changeListener) {
        super(new BorderLayout());
        this._params = params;
        this._changeListener = changeListener;
        this.configUi();
    }

    private void configUi() {
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        int iY = 0;
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        JLabel label = new JLabel("Name:");
        configPanel.add((Component)label, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        JTextField editName = new JTextField();
        editName.setText(this._params.getName());
        editName.getDocument().addDocumentListener(new DocChangeHandler(this::validateName, this._params::setName));
        configPanel.add((Component)editName, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        JPanel separator = new JPanel();
        separator.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Scheme.active().getSeparator2()));
        configPanel.add((Component)separator, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 2, 0);
        label = new JLabel("VM args required for the remote process:");
        configPanel.add((Component)label, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 0, 10, 0);
        this._editAgentArgs = new JTextField();
        this._editAgentArgs.setBorder(BorderFactory.createEmptyBorder());
        this._editAgentArgs.setEditable(false);
        configPanel.add((Component)this._editAgentArgs, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        label = new JLabel("Transport:");
        configPanel.add((Component)label, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        JComboBox<DebugTransport> cbTransport = new JComboBox<DebugTransport>(DebugTransport.values());
        cbTransport.addActionListener(e -> {
            this._params.setTransport((DebugTransport)((Object)((Object)cbTransport.getSelectedItem())));
            this.updateTransportMessage();
            this.enableControls();
        });
        EventQueue.invokeLater(() -> cbTransport.setSelectedItem((Object)this._params.getTransport()));
        configPanel.add(cbTransport, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        this._labelHost = new JLabel("Host:");
        configPanel.add((Component)this._labelHost, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        this._editHost = new JTextField();
        this._editHost.setText(this._params.getHost());
        this._editHost.getDocument().addDocumentListener(new DocChangeHandler(this::validateHost, this._params::setHost));
        configPanel.add((Component)this._editHost, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        this._labelPort = new JLabel("Port:");
        configPanel.add((Component)this._labelPort, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        this._editPort = new JTextField();
        this._editPort.setText(this._params.getPort());
        this._editPort.getDocument().addDocumentListener(new DocChangeHandler(this::validatePort, this._params::setPort));
        configPanel.add((Component)this._editPort, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 10);
        this._labelAddress = new JLabel("Address:");
        configPanel.add((Component)this._labelAddress, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 10, 0);
        this._editAddress = new JTextField();
        this._editAddress.setText(this._params.getAddress());
        this._editAddress.getDocument().addDocumentListener(new DocChangeHandler(this::validateName, this._params::setAddress));
        configPanel.add((Component)this._editAddress, c);
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        configPanel.add((Component)new JPanel(), c);
        this.add((Component)configPanel, "Center");
    }

    private void enableControls() {
        DebugTransport transport = this._params.getTransport();
        switch (transport) {
            case AttachingSocket: 
            case ListeningSocket: {
                this._labelAddress.setEnabled(false);
                this._editAddress.setEnabled(false);
                this._labelHost.setEnabled(true);
                this._editHost.setEnabled(true);
                this._labelPort.setEnabled(true);
                this._editPort.setEnabled(true);
                break;
            }
            case AttachingMemory: 
            case ListeningMemory: {
                this._labelAddress.setEnabled(true);
                this._editAddress.setEnabled(true);
                this._labelHost.setEnabled(false);
                this._editHost.setEnabled(false);
                this._labelPort.setEnabled(false);
                this._editPort.setEnabled(false);
            }
        }
    }

    private void updateTransportMessage() {
        DebugTransport transport = this._params.getTransport();
        String agentArgs = transport.getAgentArgs();
        if (agentArgs.contains("$host")) {
            String host = this._params.getHost();
            if (transport == DebugTransport.ListeningSocket) {
                try {
                    host = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            } else if (host == null || host.isEmpty()) {
                host = "<host>";
            }
            agentArgs = agentArgs.replace("$host", host);
        }
        if (agentArgs.contains("$port")) {
            String port = this._params.getPort();
            if (port == null || port.isEmpty()) {
                port = "<port>";
            }
            agentArgs = agentArgs.replace("$port", port);
        }
        if (agentArgs.contains("$address")) {
            String address = this._params.getAddress();
            if (address == null || address.isEmpty()) {
                address = "<name>";
            }
            agentArgs = agentArgs.replace("$address", address);
        }
        this._editAgentArgs.setText(agentArgs);
    }

    private String validateName(String text) {
        if (text == null || text.isEmpty()) {
            return "ERROR";
        }
        return null;
    }

    private String validateHost(String text) {
        if (text == null || text.isEmpty()) {
            return "ERROR";
        }
        return null;
    }

    private String validatePort(String text) {
        if (text == null || text.isEmpty()) {
            return "ERROR";
        }
        return null;
    }

    private class DocChangeHandler
    implements DocumentListener {
        Function<String, String> _validator;
        Consumer<String> _consumer;

        public DocChangeHandler(Function<String, String> validator, Consumer<String> consumer) {
            this._validator = validator;
            this._consumer = consumer;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            Document doc = e.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                String error = this._validator.apply(text);
                if (error != null) {
                    // empty if block
                }
                this._consumer.accept(text);
                RemoteConfigPanel.this.updateTransportMessage();
                RemoteConfigPanel.this._changeListener.accept(RemoteConfigPanel.this._params);
            }
            catch (BadLocationException e1) {
                throw new RuntimeException(e1);
            }
        }
    }
}

