/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.EditorHost;
import editor.FileTree;
import editor.FileTreeUtil;
import editor.GosuPanel;
import editor.LabFrame;
import editor.NodeKind;
import editor.Scheme;
import editor.search.SearchPanel;
import editor.search.SearchScope;
import editor.search.SearchTree;
import editor.search.StringUtil;
import editor.search.TextSearcher;
import editor.util.AbstractDialog;
import editor.util.DirectoryEditor;
import editor.util.EditorUtilities;
import editor.util.LabButton;
import editor.util.ModalEventQueue;
import editor.util.ProgressFeedback;
import gw.lang.reflect.json.IJsonIO;
import gw.util.PathUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;

public abstract class AbstractSearchDialog
extends AbstractDialog {
    private final FileTree _searchDir;
    private final boolean _bReplace;
    private JComboBox<String> _cbSearch;
    private JComboBox<String> _cbReplace;
    private JCheckBox _checkCase;
    private JCheckBox _checkWords;
    private JCheckBox _checkRegex;
    private JRadioButton _rbProject;
    private JRadioButton _rbDirectory;
    private DirectoryEditor _cbDir;
    private JRadioButton _rbScope;
    private JComboBox<SearchScope> _cbScope;
    private JCheckBox _checkFileMask;
    private JComboBox<String> _cbFileMasks;
    private DialogStateHandler _stateHandler;
    private List<FileTree> _prevSearchTree;
    private JPanel _separator2;
    private JPanel _separator3;

    public AbstractSearchDialog(FileTree searchDir, boolean bReplace, String title) {
        super(LabFrame.instance(), title, false);
        this._searchDir = searchDir;
        this._bReplace = bReplace;
        this.configUi();
    }

    protected abstract State getState();

    protected abstract void setState(State var1);

    protected boolean isReplace() {
        return this._bReplace;
    }

    protected void setScope(SearchScope scope) {
        this._rbScope.setSelected(true);
        this._cbScope.setSelectedItem((Object)scope);
    }

    protected void setLocal() {
        this.setScope(SearchScope.CurrentFile);
        EventQueue.invokeLater(() -> this.setScope(SearchScope.CurrentFile));
        this._rbProject.setVisible(false);
        this._rbDirectory.setVisible(false);
        this._cbDir.setVisible(false);
        this._rbScope.setVisible(false);
        this._cbScope.setVisible(false);
        this._separator2.setVisible(false);
        this._separator3.setVisible(false);
        this._checkFileMask.setVisible(false);
        this._cbFileMasks.setVisible(false);
    }

    private void configUi() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        contentPane.setLayout(new BorderLayout());
        this._stateHandler = new DialogStateHandler();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createLineBorder(Scheme.active().getScrollbarBorderColor()));
        mainPanel.add((Component)this.makeSearchPanel(), "Center");
        contentPane.add((Component)mainPanel, "Center");
        JPanel south = new JPanel(new BorderLayout());
        south.setBackground(Scheme.active().getMenu());
        south.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        JPanel filler = new JPanel();
        filler.setBackground(Scheme.active().getMenu());
        south.add((Component)filler, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBackground(Scheme.active().getMenu());
        LabButton btnFind = new LabButton(new FindActionHandler());
        btnFind.setMnemonic('F');
        buttonPanel.add(btnFind);
        this.getRootPane().setDefaultButton(btnFind);
        LabButton btnCancel = new LabButton("Cancel");
        btnCancel.addActionListener(e -> this.close());
        buttonPanel.add(btnCancel);
        south.add((Component)buttonPanel, "East");
        contentPane.add((Component)south, "South");
        contentPane.setBackground(Scheme.active().getMenu());
        this.mapCancelKeystroke("Cancel", this::close);
        this.setSize(400, this._bReplace ? 420 : 400);
        EditorUtilities.centerWindowInFrame(this, this.getOwner());
        EventQueue.invokeLater(() -> {
            this.applyState();
            if (this._searchDir != FileTreeUtil.getRoot()) {
                this._rbDirectory.setSelected(true);
                this._cbDir.setText(PathUtil.getAbsolutePathName((Path)this._searchDir.getFileOrDir()));
            } else if (!this._rbScope.isSelected()) {
                this._rbProject.setSelected(true);
            }
            this._stateHandler.actionPerformed(null);
            this._cbSearch.requestFocus();
            this.setTextFromEditor();
        });
    }

    private void setTextFromEditor() {
        String selection;
        EditorHost editor = LabFrame.instance().getGosuPanel().getCurrentEditor();
        if (editor != null && (selection = editor.getEditor().getSelectedText()) != null) {
            this._cbSearch.setSelectedItem(selection);
            JTextComponent textField = (JTextComponent)this._cbSearch.getEditor().getEditorComponent();
            textField.setText(selection);
            textField.select(0, selection.length());
        }
    }

    private void applyState() {
        if (this.getState() != null) {
            this.getState().restore(this);
        }
    }

    protected String getPattern() {
        return (String)this._cbSearch.getSelectedItem();
    }

    protected boolean isCaseSensitive() {
        return this._checkCase.isSelected();
    }

    protected boolean isWholeWords() {
        return this._checkWords.isSelected();
    }

    protected boolean isRegex() {
        return this._checkRegex.isSelected();
    }

    protected void find() {
        this.setState(new State().save(this));
        this.close();
        this._prevSearchTree = this.getSearchResults();
        GosuPanel gosuPanel = LabFrame.instance().getGosuPanel();
        gosuPanel.showSearches(false);
        SearchPanel searchPanel = gosuPanel.showSearches(true);
        searchPanel.showReplace(this._bReplace);
        searchPanel.setReplacePattern((String)this._cbReplace.getSelectedItem());
        boolean[] bFinished = new boolean[]{false};
        ProgressFeedback.runWithProgress("Searching...", progress -> EventQueue.invokeLater(() -> {
            progress.setLength(this.numOfFiles());
            this.addReplaceInfo(searchPanel);
            String text = (String)this._cbSearch.getSelectedItem();
            SearchTree results = new SearchTree("<html><b>$count</b>&nbsp;occurrences&nbsp;of&nbsp;<b>'" + text + "'</b>&nbsp;in&nbsp;" + this.getScopeName(), NodeKind.Directory, SearchTree.empty());
            searchPanel.add(results);
            TextSearcher searcher = new TextSearcher(text, this._checkCase.isSelected(), this._checkWords.isSelected(), this._checkRegex.isSelected());
            searcher.searchTrees(this.getSelectedTrees(), results, ft -> this.include((FileTree)ft, this.getFileMatchRegex()), progress);
            this.selectFirstMatch(results);
            bFinished[0] = true;
        }));
        new ModalEventQueue(() -> !bFinished[0]).run();
    }

    private int numOfFiles() {
        int count = 0;
        for (FileTree ft : this.getSelectedTrees()) {
            count += ft.getTotalFiles();
        }
        return count;
    }

    private List<FileTree> getSelectedTrees() {
        if (this._rbScope.isSelected()) {
            switch ((SearchScope)((Object)this._cbScope.getSelectedItem())) {
                case CurrentFile: {
                    return Collections.singletonList(FileTreeUtil.getRoot().find(LabFrame.instance().getGosuPanel().getCurrentFile()));
                }
                case OpenFiles: {
                    return LabFrame.instance().getGosuPanel().getOpenFilesInProject();
                }
                case SelectedFiles: {
                    return Collections.singletonList(LabFrame.instance().getGosuPanel().getExperimentView().getSelectedTree());
                }
                case PreviousSearchFiles: {
                    return this._prevSearchTree;
                }
            }
            throw new IllegalStateException();
        }
        return Collections.singletonList(this.getSearchDir());
    }

    private List<FileTree> getSearchResults() {
        SearchPanel searchPanel = LabFrame.instance().getGosuPanel().getSearchPanel();
        if (searchPanel == null) {
            return Collections.emptyList();
        }
        SearchTree root = (SearchTree)searchPanel.getTree().getModel().getRoot();
        ArrayList<FileTree> result = new ArrayList<FileTree>();
        this.findFilesFromPreviousSearch(root, result);
        return result;
    }

    private void findFilesFromPreviousSearch(SearchTree root, List<FileTree> result) {
        SearchTree.SearchTreeNode node = (SearchTree.SearchTreeNode)root.getNode();
        if (node != null && node.getFile() != null && node.getLocation() == null) {
            result.add(node.getFile());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                SearchTree child = (SearchTree)root.getChildAt(i);
                this.findFilesFromPreviousSearch(child, result);
            }
        }
    }

    private void addReplaceInfo(SearchPanel searchPanel) {
        if (this._bReplace) {
            String text = (String)this._cbReplace.getSelectedItem();
            SearchTree results = new SearchTree("<html>Replace occurrences with <b>'" + text + "'</b>", NodeKind.Info, SearchTree.empty());
            searchPanel.add(results);
        }
    }

    private void selectFirstMatch(SearchTree results) {
        if (results.getChildCount() == 0) {
            results.select();
        } else {
            this.selectFirstMatch((SearchTree)results.getChildAt(0));
        }
    }

    private List<String> getFileMatchRegex() {
        String mask;
        if (this._checkFileMask.isSelected() && (mask = (String)this._cbFileMasks.getSelectedItem()) != null && mask.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer tok = new StringTokenizer(mask, ";");
            while (tok.hasMoreTokens()) {
                String ext = tok.nextToken().trim();
                list.add(StringUtil.wildcardToRegex(ext));
            }
            return list;
        }
        return Collections.emptyList();
    }

    private boolean include(FileTree ft, List<String> fileMatchRegex) {
        if (!fileMatchRegex.isEmpty()) {
            for (String regex : fileMatchRegex) {
                if (!ft.getName().toLowerCase().matches(regex)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String getScopeName() {
        if (this._rbProject.isSelected()) {
            return "Experiment";
        }
        if (this._rbDirectory.isSelected()) {
            return this._cbDir.getText();
        }
        if (this._rbScope.isSelected()) {
            return ((SearchScope)((Object)this._cbScope.getSelectedItem())).getLabel();
        }
        throw new IllegalStateException();
    }

    private JComponent makeSearchPanel() {
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        int iY = 0;
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 5);
        JLabel label = new JLabel("Text to find:");
        configPanel.add((Component)label, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 5, 0);
        this._cbSearch = new JComboBox();
        this._cbSearch.setEditable(true);
        configPanel.add(this._cbSearch, c);
        this._cbReplace = new JComboBox();
        this._cbReplace.setEditable(true);
        if (this._bReplace) {
            c.anchor = 17;
            c.fill = 0;
            c.gridx = 0;
            c.gridy = iY;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 0, 5);
            label = new JLabel("Replace with:");
            configPanel.add((Component)label, c);
            c.anchor = 17;
            c.fill = 2;
            c.gridx = 1;
            c.gridy = iY++;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 0, 0);
            configPanel.add(this._cbReplace, c);
        }
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 5, 0);
        JPanel separator1 = new JPanel();
        separator1.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Scheme.active().getControlShadow()));
        configPanel.add((Component)separator1, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this._checkCase = new JCheckBox("Case sensitive");
        this._checkCase.setMnemonic('C');
        configPanel.add((Component)this._checkCase, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this._checkWords = new JCheckBox("Whole words only");
        this._checkWords.setMnemonic('R');
        configPanel.add((Component)this._checkWords, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this._checkRegex = new JCheckBox("Regular expression");
        this._checkRegex.setMnemonic('G');
        this._checkRegex.addActionListener(this._stateHandler);
        configPanel.add((Component)this._checkRegex, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 5, 0);
        this._separator2 = new JPanel();
        this._separator2.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Scheme.active().getControlShadow()));
        configPanel.add((Component)this._separator2, c);
        ButtonGroup group = new ButtonGroup();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this._rbProject = new JRadioButton("Whole experiment");
        this._rbProject.setMnemonic('H');
        this._rbProject.addActionListener(this._stateHandler);
        group.add(this._rbProject);
        configPanel.add((Component)this._rbProject, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this._rbDirectory = new JRadioButton("Directory:");
        this._rbDirectory.setMnemonic('D');
        this._rbDirectory.addActionListener(this._stateHandler);
        group.add(this._rbDirectory);
        configPanel.add((Component)this._rbDirectory, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this._cbDir = new DirectoryEditor("Directory", PathUtil.getAbsolutePathName((Path)this._searchDir.getFileOrDir()), LabFrame::instance);
        configPanel.add((Component)this._cbDir, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this._rbScope = new JRadioButton("Scope:");
        this._rbScope.setMnemonic('S');
        this._rbScope.addActionListener(this._stateHandler);
        group.add(this._rbScope);
        configPanel.add((Component)this._rbScope, c);
        this._rbProject.setSelected(true);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this._cbScope = new JComboBox<SearchScope>(SearchScope.values());
        configPanel.add(this._cbScope, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 5, 0);
        this._separator3 = new JPanel();
        this._separator3.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Scheme.active().getControlShadow()));
        configPanel.add((Component)this._separator3, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this._checkFileMask = new JCheckBox("Path mask(s):");
        this._checkFileMask.setMnemonic('M');
        this._checkFileMask.addActionListener(this._stateHandler);
        configPanel.add((Component)this._checkFileMask, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this._cbFileMasks = new JComboBox();
        this._cbFileMasks.setEditable(true);
        configPanel.add(this._cbFileMasks, c);
        return configPanel;
    }

    public FileTree getSearchDir() {
        FileTree fileTree;
        Path file;
        if (this._rbDirectory.isSelected() && PathUtil.exists((Path)(file = PathUtil.create((String)this._cbDir.getText(), (String[])new String[0])), (LinkOption[])new LinkOption[0]) && (fileTree = FileTreeUtil.getRoot().find(file)) != null) {
            return fileTree;
        }
        return FileTreeUtil.getRoot();
    }

    private class FindActionHandler
    extends AbstractAction {
        private FindActionHandler() {
            super(AbstractSearchDialog.this._bReplace ? "Replace" : "Find");
        }

        @Override
        public boolean isEnabled() {
            String pattern = ((JTextComponent)AbstractSearchDialog.this._cbSearch.getEditor().getEditorComponent()).getText();
            return pattern != null && !pattern.isEmpty();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractSearchDialog.this.find();
        }
    }

    public static class State
    implements IJsonIO {
        String[] _searchHistory;
        String[] _replaceHistory;
        boolean _case;
        boolean _words;
        boolean _regex;
        boolean _project;
        boolean _dir;
        boolean _scope;
        String _selectedDir;
        SearchScope _selectedScope;
        boolean _mask;
        String _selectedMask;
        String[] _masks;

        public State save(AbstractSearchDialog dlg) {
            this._searchHistory = this.makeArray(dlg._cbSearch);
            this._replaceHistory = this.makeArray(dlg._cbReplace);
            this._case = dlg._checkCase.isSelected();
            this._words = dlg._checkWords.isSelected();
            this._regex = dlg._checkRegex.isSelected();
            this._project = dlg._rbProject.isSelected();
            this._dir = dlg._rbDirectory.isSelected();
            this._scope = dlg._rbScope.isSelected();
            this._selectedScope = (SearchScope)((Object)dlg._cbScope.getSelectedItem());
            this._selectedDir = dlg._cbDir.getText();
            this._mask = dlg._checkFileMask.isSelected();
            this._selectedMask = (String)dlg._cbFileMasks.getSelectedItem();
            this._masks = this.makeArray(dlg._cbFileMasks);
            return this;
        }

        public void restore(AbstractSearchDialog dlg) {
            dlg._cbSearch.setModel(new DefaultComboBoxModel<String>(this._searchHistory));
            dlg._cbSearch.getEditor().setItem(null);
            dlg._cbReplace.setModel(new DefaultComboBoxModel<String>(this._replaceHistory));
            dlg._cbReplace.getEditor().setItem(null);
            dlg._checkCase.setSelected(this._case);
            dlg._checkWords.setSelected(this._words);
            dlg._checkRegex.setSelected(this._regex);
            dlg._rbProject.setSelected(this._project);
            dlg._rbDirectory.setSelected(this._dir);
            dlg._rbScope.setSelected(this._scope);
            dlg._cbDir.setText(this._selectedDir);
            dlg._cbScope.setSelectedItem((Object)this._selectedScope);
            dlg._checkFileMask.setSelected(this._mask);
            dlg._cbFileMasks.setSelectedItem(this._selectedMask);
            dlg._cbFileMasks.setModel(new DefaultComboBoxModel<String>(this._masks));
        }

        private String[] makeArray(JComboBox<String> cb) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
            int size = Math.min(20, model.getSize());
            String selectedItem = (String)cb.getSelectedItem();
            int extra = 0;
            if (selectedItem != null && !selectedItem.isEmpty() && model.getIndexOf(selectedItem) < 0) {
                extra = 1;
            }
            String[] array = new String[size + extra];
            if (extra > 0) {
                array[0] = selectedItem;
            }
            for (int i = 0; i < size; ++i) {
                array[i + extra] = (String)model.getElementAt(i);
            }
            return array;
        }
    }

    private class DialogStateHandler
    implements ActionListener {
        private DialogStateHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractSearchDialog.this._checkWords.setEnabled(!AbstractSearchDialog.this._checkRegex.isSelected());
            AbstractSearchDialog.this._cbDir.setEnabled(AbstractSearchDialog.this._rbDirectory.isSelected());
            AbstractSearchDialog.this._cbScope.setEnabled(AbstractSearchDialog.this._rbScope.isSelected());
            AbstractSearchDialog.this._cbDir.setEnabled(AbstractSearchDialog.this._rbDirectory.isSelected());
            AbstractSearchDialog.this._cbFileMasks.setEnabled(AbstractSearchDialog.this._checkFileMask.isSelected());
        }
    }
}

