/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.search.SearchLocation;
import java.util.ArrayList;
import java.util.List;

public class StringUtil {
    public static List<SearchLocation> search(String strSource, String strPattern, boolean bIgnoreCase, boolean bWords) {
        return StringUtil.search(strSource, strPattern, bIgnoreCase, bWords, 0);
    }

    public static List<SearchLocation> search(String strSource, String strPattern, boolean bIgnoreCase, boolean bWords, int iOffset) {
        return StringUtil.search(strSource, strPattern, bIgnoreCase, bWords, iOffset, false);
    }

    public static List<SearchLocation> search(String content, String pattern, boolean bIgnoreCase, boolean bWords, int iOffset, boolean backwards) {
        int iIndex2;
        if (bIgnoreCase) {
            content = content.toLowerCase();
            pattern = pattern.toLowerCase();
        }
        ArrayList<SearchLocation> list = new ArrayList<SearchLocation>();
        if (content.isEmpty()) {
            return list;
        }
        int iIndex = backwards ? content.length() : 0;
        int n = iIndex2 = backwards ? content.lastIndexOf(pattern, iOffset - pattern.length() - 1) : content.indexOf(pattern, iOffset);
        if (iIndex2 < 0) {
            return list;
        }
        SearchLocation slBuffer = new SearchLocation();
        do {
            StringUtil.getLocation(content, iIndex, iIndex2, slBuffer);
            if (!bWords || StringUtil.isWholeWord(content, iIndex2, pattern)) {
                SearchLocation sl = new SearchLocation();
                sl._iOffset = iIndex2;
                sl._iLine = slBuffer._iLine + 1;
                sl._iColumn = slBuffer._iColumn + 1;
                sl._iLineOffset = slBuffer._iLineOffset;
                sl._iLength = pattern.length();
                list.add(sl);
            }
            iIndex = iIndex2;
        } while ((iIndex2 = backwards ? content.lastIndexOf(pattern, --iIndex) : content.indexOf(pattern, iIndex += pattern.length())) >= 0);
        return list;
    }

    private static boolean isWholeWord(String content, int offset, String pattern) {
        if (offset > 0 && Character.isLetterOrDigit(content.charAt(offset - 1))) {
            return false;
        }
        int followingCharOffset = offset + pattern.length();
        if (followingCharOffset < content.length()) {
            return !Character.isLetterOrDigit(content.charAt(followingCharOffset));
        }
        return true;
    }

    public static void getLocation(String strSource, int iFrom, int iTo, SearchLocation location) {
        if (strSource == null) {
            return;
        }
        if (iFrom > strSource.length() || iTo > strSource.length()) {
            throw new IllegalArgumentException("String index out of bounds.  Source: , From: " + iFrom + ", To:" + iTo);
        }
        int iLineCount = 0;
        int iLineStart = location._iLineOffset;
        for (int i = iFrom; i < iTo; ++i) {
            char c = strSource.charAt(i);
            if (c != '\n') continue;
            ++iLineCount;
            iLineStart = i + 1;
        }
        location._iLine += iLineCount;
        location._iColumn = iTo - iLineStart;
        location._iLineOffset = iLineStart;
    }

    public static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    public static int getLineOffset(String content, int line) {
        int offset;
        int lineCsr = 1;
        for (offset = 0; offset < content.length(); ++offset) {
            if (lineCsr == line) {
                return offset;
            }
            char c = content.charAt(offset);
            if (c != '\n') continue;
            ++lineCsr;
        }
        return offset;
    }
}

