/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.GosuEditor;
import editor.LabFrame;
import editor.search.FeatureUtil;
import editor.search.LocalVarFeatureInfo;
import editor.search.SearchElement;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IDynamicPropertySymbol;
import gw.lang.parser.IDynamicSymbol;
import gw.lang.parser.IFileRepositoryBasedType;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.exceptions.ParseIssue;
import gw.lang.parser.expressions.IBeanMethodCallExpression;
import gw.lang.parser.expressions.IFieldAccessExpression;
import gw.lang.parser.expressions.IIdentifierExpression;
import gw.lang.parser.expressions.ILocalVarDeclaration;
import gw.lang.parser.expressions.IMethodCallExpression;
import gw.lang.parser.expressions.INameInDeclaration;
import gw.lang.parser.expressions.INewExpression;
import gw.lang.parser.expressions.IPropertyAccessIdentifier;
import gw.lang.parser.expressions.IPropertyAsMethodCallIdentifier;
import gw.lang.parser.expressions.ITypeLiteralExpression;
import gw.lang.parser.expressions.ITypeVariableDefinition;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.statements.IAssignmentStatement;
import gw.lang.parser.statements.IClassDeclaration;
import gw.lang.parser.statements.IConstructorStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.parser.statements.IMemberAssignmentStatement;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.ILocationInfo;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IMethodBackedPropertyInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.INamespaceType;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuVarPropertyInfo;
import java.util.ArrayList;

public class UsageTarget {
    private final IParsedElement _pe;
    private final IFeatureInfo _selectedFi;
    private final IFeatureInfo _rootFi;
    private final SearchElement _targetPe;

    public UsageTarget(IParsedElement pe, IFeatureInfo selectedFi) {
        this._pe = pe;
        this._selectedFi = selectedFi;
        this._rootFi = this.findRootFeatureInfo();
        this._targetPe = UsageTarget.findTarget(this._rootFi, pe);
    }

    private IFeatureInfo findRootFeatureInfo() {
        if (this._selectedFi instanceof IMethodInfo) {
            return FeatureUtil.findRootMethodInfo((IMethodInfo)this._selectedFi);
        }
        if (this._selectedFi instanceof IPropertyInfo) {
            return FeatureUtil.findRootPropertyInfo((IPropertyInfo)this._selectedFi);
        }
        if (this._selectedFi instanceof IConstructorInfo) {
            return FeatureUtil.findRootConstructorInfo((IConstructorInfo)this._selectedFi);
        }
        return this._selectedFi;
    }

    public IParsedElement getParsedElement() {
        return this._pe;
    }

    public IFeatureInfo getSelectedFeatureInfo() {
        return this._selectedFi;
    }

    public IFeatureInfo getRootFeatureInfo() {
        return this._rootFi;
    }

    public SearchElement getTargetElement() {
        return this._targetPe;
    }

    public static UsageTarget makeTargetFromCaret() {
        GosuEditor editor = UsageTarget.getCurrentGosuEditor();
        if (editor == null) {
            return null;
        }
        IParseTree loc = editor.getDeepestLocationAtCaret();
        if (loc == null) {
            return null;
        }
        IParsedElement pe = loc.getParsedElement();
        return UsageTarget.makeTarget(pe);
    }

    public static UsageTarget makeTarget(IParsedElement pe) {
        if (pe == null) {
            return null;
        }
        while (pe.getLocation().getLength() == 0) {
            pe = pe.getParent();
        }
        try {
            IFeatureInfo fi = UsageTarget.findFeatureInfoFor(pe);
            if (fi == null) {
                return null;
            }
            return new UsageTarget(pe, fi);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ParseIssue) {
                return null;
            }
            throw e;
        }
    }

    private static GosuEditor getCurrentGosuEditor() {
        return LabFrame.instance().getGosuPanel().getCurrentGosuEditor();
    }

    private static IFeatureInfo findFeatureInfoFor(IParsedElement pe) {
        if (pe instanceof IIdentifierExpression) {
            SearchElement target;
            IPropertyInfo pi;
            IGosuClass gsClass;
            if (pe instanceof IPropertyAccessIdentifier || pe instanceof IPropertyAsMethodCallIdentifier) {
                IFeatureInfo pi2 = ((IDynamicPropertySymbol)((IIdentifierExpression)pe).getSymbol()).getPropertyInfo();
                SearchElement target2 = UsageTarget.findTarget(pi2, pe);
                if (target2 != null) {
                    return UsageTarget.findFeatureInfoFor((IParsedElement)target2.getElement());
                }
                return ((IDynamicPropertySymbol)((IIdentifierExpression)pe).getSymbol()).getPropertyInfo();
            }
            ISymbol symbol = ((IIdentifierExpression)pe).getSymbol();
            if (symbol instanceof IDynamicSymbol && (gsClass = symbol.getGosuClass()) != null && (pi = gsClass.getTypeInfo().getProperty((IType)gsClass, (CharSequence)symbol.getDisplayName())) != null && (target = UsageTarget.findTarget((IFeatureInfo)pi, pe)) != null) {
                return UsageTarget.findFeatureInfoFor((IParsedElement)target.getElement());
            }
            return new LocalVarFeatureInfo((IIdentifierExpression)pe);
        }
        if (pe instanceof ILocalVarDeclaration) {
            return new LocalVarFeatureInfo((ILocalVarDeclaration)pe);
        }
        if (pe instanceof IFieldAccessExpression) {
            IFieldAccessExpression memberAccess = (IFieldAccessExpression)pe;
            if (!(memberAccess.getType() instanceof INamespaceType)) {
                SearchElement targetPe = UsageTarget.findTarget((IFeatureInfo)memberAccess.getPropertyInfo(), pe);
                if (targetPe != null) {
                    Object element = targetPe.getElement();
                    if (element instanceof IFeatureInfo) {
                        return (IFeatureInfo)element;
                    }
                    return UsageTarget.findFeatureInfoFor((IParsedElement)targetPe.getElement());
                }
                return memberAccess.getPropertyInfo();
            }
        } else if (pe instanceof IMethodCallExpression) {
            IMethodCallExpression methodCallExpression = (IMethodCallExpression)pe;
            IFunctionSymbol sym = methodCallExpression.getFunctionSymbol();
            if (sym instanceof IDynamicFunctionSymbol) {
                return ((IDynamicFunctionSymbol)sym).getMethodOrConstructorInfo();
            }
        } else {
            if (pe instanceof IBeanMethodCallExpression) {
                IBeanMethodCallExpression beanMethodCallExpression = (IBeanMethodCallExpression)pe;
                return beanMethodCallExpression.getMethodDescriptor();
            }
            if (pe instanceof INewExpression) {
                INewExpression newExpression = (INewExpression)pe;
                return newExpression.getConstructor();
            }
            if (pe instanceof IClassDeclaration) {
                return pe.getGosuClass().getTypeInfo();
            }
            if (pe instanceof INameInDeclaration) {
                IFeatureInfo fi = UsageTarget.findFeatureInfo((INameInDeclaration)pe);
                if (fi != null) {
                    return fi;
                }
            } else if (pe instanceof IVarStatement && ((IVarStatement)pe).isFieldDeclaration() && ((IVarStatement)pe).getType().isEnum()) {
                IFeatureInfo fi = UsageTarget.findFeatureInfo(pe, ((IVarStatement)pe).getIdentifierName());
                if (fi != null) {
                    return fi;
                }
            } else {
                if (pe instanceof IConstructorStatement) {
                    return ((IConstructorStatement)pe).getDynamicFunctionSymbol().getMethodOrConstructorInfo();
                }
                if (pe instanceof ITypeVariableDefinition) {
                    ITypeVariableDefinition typeVariableDefinition = (ITypeVariableDefinition)pe;
                    return null;
                }
                if (pe instanceof ITypeLiteralExpression) {
                    IConstructorInfo ctor;
                    if (pe.getParent() instanceof INewExpression && ((INewExpression)pe.getParent()).getTypeLiteral() == pe && (ctor = ((INewExpression)pe.getParent()).getConstructor()) != null) {
                        return ctor;
                    }
                    ITypeLiteralExpression typeLiteral = (ITypeLiteralExpression)pe;
                    if (UsageTarget.isErrant(typeLiteral)) {
                        return null;
                    }
                    IType type = typeLiteral.getType().getType();
                    while (type.isArray()) {
                        type = type.getComponentType();
                    }
                    return type.getTypeInfo();
                }
            }
        }
        return null;
    }

    private static SearchElement findTarget(IFeatureInfo fi, IParsedElement ref) {
        IType type = fi.getOwnersType();
        IType iType = type = type instanceof IMetaType ? ((IMetaType)type).getType() : type;
        if (!(type instanceof IFileRepositoryBasedType)) {
            return null;
        }
        IFileRepositoryBasedType declaringType = (IFileRepositoryBasedType)type;
        if (fi instanceof ITypeInfo) {
            if (type instanceof IGosuClass) {
                return new SearchElement((IParsedElement)((IGosuClass)type).getClassStatement().getClassDeclaration());
            }
            ILocationInfo loc = fi.getLocationInfo();
            if (loc != null && loc != ILocationInfo.EMPTY) {
                return new SearchElement(fi, (IType)declaringType, loc.getOffset());
            }
            return new SearchElement(fi, (IType)declaringType, 0);
        }
        if (fi instanceof IMethodInfo) {
            if (declaringType instanceof IGosuClass) {
                IFunctionStatement fs = ((IGosuClass)declaringType).getFunctionStatement((IMethodInfo)fi);
                return new SearchElement(fs.getLocation().getDeepestLocation(fs.getNameOffset(null), true).getParsedElement());
            }
            ILocationInfo loc = fi.getLocationInfo();
            if (loc != null && loc != ILocationInfo.EMPTY) {
                return new SearchElement(fi, (IType)declaringType, loc.getOffset());
            }
        } else if (fi instanceof IPropertyInfo) {
            ILocationInfo loc;
            boolean bSetter;
            IParsedElement parent;
            if (fi instanceof IGosuVarPropertyInfo) {
                int offset = ((IGosuVarPropertyInfo)fi).getOffset();
                return new SearchElement(((IGosuClass)declaringType).getClassStatement().getLocation().getDeepestLocation(offset, true).getParsedElement());
            }
            if (ref instanceof IIdentifierExpression) {
                parent = ref.getParent();
                bSetter = parent instanceof IAssignmentStatement && ((IAssignmentStatement)parent).getIdentifier() == ref;
            } else {
                parent = ref.getParent();
                boolean bl = bSetter = parent instanceof IMemberAssignmentStatement && (((IMemberAssignmentStatement)parent).getMemberAccess() == ref || ((IMemberAssignmentStatement)parent).getRootExpression() == ref);
            }
            if (fi instanceof IMethodBackedPropertyInfo) {
                IMethodInfo mi = bSetter ? ((IMethodBackedPropertyInfo)fi).getWriteMethodInfo() : ((IMethodBackedPropertyInfo)fi).getReadMethodInfo();
                IType ownersType = mi.getOwnersType();
                if (ownersType instanceof IGosuClass) {
                    IFunctionStatement fs = ((IGosuClass)ownersType).getFunctionStatement(mi);
                    if (fs == null) {
                        return new SearchElement((IParsedElement)((IGosuClass)declaringType).getPropertyDeclaration(fi.getDisplayName()));
                    }
                    return new SearchElement(fs.getLocation().getDeepestLocation(fs.getNameOffset(null), true).getParsedElement());
                }
                fi = mi;
            }
            if ((loc = fi.getLocationInfo()) != null && loc != ILocationInfo.EMPTY) {
                return new SearchElement(fi, (IType)declaringType, loc.getOffset());
            }
        } else if (fi instanceof IConstructorInfo) {
            if (((IConstructorInfo)fi).isDefault()) {
                return UsageTarget.findTarget(fi.getContainer(), ref);
            }
            if (declaringType instanceof IGosuClass) {
                IConstructorStatement fs = ((IGosuClass)declaringType).getConstructorStatement((IConstructorInfo)fi);
                return new SearchElement(fs == null ? null : fs.getLocation().getDeepestLocation(fs.getNameOffset(null), true).getParsedElement());
            }
            ILocationInfo loc = fi.getLocationInfo();
            if (loc != null && loc != ILocationInfo.EMPTY) {
                return new SearchElement(fi, (IType)declaringType, loc.getOffset());
            }
        } else if (fi instanceof LocalVarFeatureInfo) {
            return new SearchElement(UsageTarget.findLocalDeclaration(((LocalVarFeatureInfo)fi).getSymbol(), ref));
        }
        return null;
    }

    private static IParsedElement findLocalDeclaration(ISymbol symbol, IParsedElement pe) {
        ArrayList res = new ArrayList();
        IParsedElement root = UsageTarget.getRootParsedElement(pe);
        root.getContainedParsedElementsByType(ILocalVarDeclaration.class, res);
        for (ILocalVarDeclaration varDecl : res) {
            if (symbol != varDecl.getSymbol() && !UsageTarget.sameFunctionSameIndex(pe, symbol, varDecl)) continue;
            int offset = varDecl.getNameOffset((String)varDecl.getLocalVarName());
            return UsageTarget.findDeepestViablePe(offset, (IParsedElement)varDecl);
        }
        ArrayList v = new ArrayList();
        root.getContainedParsedElementsByType(IVarStatement.class, v);
        for (IVarStatement fs : v) {
            if (!symbol.equals(fs.getSymbol())) continue;
            int offset = fs.getNameOffset(fs.getIdentifierName());
            return UsageTarget.findDeepestViablePe(offset, (IParsedElement)fs);
        }
        return null;
    }

    private static boolean sameFunctionSameIndex(IParsedElement pe, ISymbol symbol, ILocalVarDeclaration varDecl) {
        if (UsageTarget.findFunctionStmt(pe) == UsageTarget.findFunctionStmt((IParsedElement)varDecl)) {
            ISymbol declSymbol = varDecl.getSymbol();
            return symbol.equals(declSymbol) && symbol.getIndex() == declSymbol.getIndex();
        }
        return false;
    }

    private static IFunctionStatement findFunctionStmt(IParsedElement pe) {
        if (pe instanceof IFunctionStatement) {
            return (IFunctionStatement)pe;
        }
        return UsageTarget.findFunctionStmt(pe.getParent());
    }

    private static IParsedElement findDeepestViablePe(int offset, IParsedElement pe) {
        IParseTree deepestLocation = pe.getLocation().getDeepestLocation(offset, true);
        IParsedElement localPe = deepestLocation.getParsedElement();
        while (localPe.getLocation().getLength() == 0) {
            localPe = localPe.getParent();
        }
        return localPe;
    }

    private static IParsedElement getRootParsedElement(IParsedElement pe) {
        IParseTree location = pe.getLocation();
        if (location == null) {
            return null;
        }
        IParsedElement parsedElement = location.getParsedElement();
        while (parsedElement.getParent() != null) {
            parsedElement = parsedElement.getParent();
        }
        return parsedElement;
    }

    private static IFeatureInfo findFeatureInfo(INameInDeclaration pe) {
        IParsedElement parent = pe.getParent();
        return UsageTarget.findFeatureInfo(parent, pe.getName());
    }

    private static IFeatureInfo findFeatureInfo(IParsedElement parent, String name) {
        if (parent instanceof IVarStatement) {
            IVarStatement varStatement = (IVarStatement)parent;
            if (varStatement.isFieldDeclaration()) {
                IGosuClass gsClass = varStatement.getSymbol().getGosuClass();
                return gsClass.getTypeInfo().getProperty((IType)gsClass, (CharSequence)name);
            }
            LocalVarFeatureInfo local = new LocalVarFeatureInfo(varStatement);
            if (local.getContainer() != null) {
                return local;
            }
        } else {
            if (parent instanceof ILocalVarDeclaration) {
                return new LocalVarFeatureInfo((ILocalVarDeclaration)parent);
            }
            if (parent instanceof IFunctionStatement) {
                return ((IFunctionStatement)parent).getDynamicFunctionSymbol().getMethodOrConstructorInfo();
            }
        }
        return null;
    }

    private static boolean isErrant(ITypeLiteralExpression typeLiteral) {
        IMetaType type = typeLiteral.getType();
        return type instanceof IMetaType && type.getType() instanceof IErrorType;
    }
}

