/*
 * Decompiled with CFR 0.152.
 */
package editor.settings;

import editor.LabFrame;
import editor.settings.AbstractSettings;
import editor.settings.CompilerSettingsPanel;
import editor.settings.CompilerSettingsParameters;
import editor.util.Experiment;
import gw.util.PathUtil;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;

public class CompilerSettings
extends AbstractSettings<CompilerSettingsParameters> {
    public static final String PATH = "Compiler";

    public CompilerSettings() {
        super(null, PATH, PATH);
    }

    @Override
    public CompilerSettingsParameters makeDefaultParameters(Experiment experiment) {
        CompilerSettingsParameters params = new CompilerSettingsParameters();
        params.setSourceBased(true);
        params.setOuputPath("classes");
        return params;
    }

    @Override
    public boolean isValid() {
        return ((CompilerSettingsParameters)this.getParams()).isSourceBased() || PathUtil.isDirectory((Path)PathUtil.create((String)((CompilerSettingsParameters)this.getParams()).getOutputPath(), (String[])new String[0]), (LinkOption[])new LinkOption[0]);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public JComponent makePanel(CompilerSettingsParameters params, Consumer<CompilerSettingsParameters> changeListener) {
        return new CompilerSettingsPanel(params, changeListener);
    }

    @Override
    public boolean isExperimentSetting() {
        return true;
    }

    @Override
    public boolean isIdeSetting() {
        return false;
    }

    public static boolean isStaticCompile() {
        CompilerSettings settings = CompilerSettings.getCompilerSettings();
        return !((CompilerSettingsParameters)settings.getParams()).isSourceBased();
    }

    public static Path getCompilerOutputDir() {
        if (!CompilerSettings.isStaticCompile()) {
            return null;
        }
        CompilerSettings settings = CompilerSettings.getCompilerSettings();
        return PathUtil.create((String)((CompilerSettingsParameters)settings.getParams()).getOutputPath(), (String[])new String[0]);
    }

    private static CompilerSettings getCompilerSettings() {
        Experiment experiment = LabFrame.instance().getGosuPanel().getExperiment();
        return (CompilerSettings)experiment.getSettings().get(PATH);
    }
}

