/*
 * Decompiled with CFR 0.152.
 */
package editor.settings;

import editor.settings.AppearanceSettings;
import editor.settings.CompilerSettings;
import editor.settings.ISettings;
import editor.util.Experiment;
import java.util.Map;
import java.util.TreeMap;

public class Settings {
    public static Map<String, ISettings> makeDefaultSettings(Experiment experiment) {
        TreeMap<String, ISettings> settings = new TreeMap<String, ISettings>();
        CompilerSettings compilerSettings = new CompilerSettings();
        compilerSettings.resetToDefaultSettings(experiment);
        settings.put(compilerSettings.getPath(), compilerSettings);
        return settings;
    }

    public static Map<String, ISettings> makeDefaultSettings() {
        TreeMap<String, ISettings> settings = new TreeMap<String, ISettings>();
        AppearanceSettings appearanceSettings = new AppearanceSettings();
        appearanceSettings.resetToDefaultSettings(null);
        settings.put(appearanceSettings.getPath(), appearanceSettings);
        return settings;
    }

    public static Map<String, ISettings> mergeSettings(Map<String, ISettings> old, Experiment experiment) {
        Map<String, ISettings> defaultSettings = Settings.makeDefaultSettings(experiment);
        old.keySet().forEach(key -> {
            ISettings cfr_ignored_0 = (ISettings)defaultSettings.put((String)key, (ISettings)old.get(key));
        });
        return defaultSettings;
    }

    public static Map<String, ISettings> mergeSettings(Map<String, ISettings> old) {
        Map<String, ISettings> defaultSettings = Settings.makeDefaultSettings();
        old.keySet().forEach(key -> {
            ISettings cfr_ignored_0 = (ISettings)defaultSettings.put((String)key, (ISettings)old.get(key));
        });
        return defaultSettings;
    }
}

