/*
 * Decompiled with CFR 0.152.
 */
package editor.settings;

import editor.AbstractTreeCellRenderer;
import editor.GosuPanel;
import editor.IHandleCancel;
import editor.LabFrame;
import editor.Scheme;
import editor.settings.ISettings;
import editor.settings.ISettingsParameters;
import editor.settings.SettingsTree;
import editor.splitpane.CollapsibleSplitPane;
import editor.tabpane.ITab;
import editor.tabpane.TabPane;
import editor.tabpane.TabPosition;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.IEditableLabel;
import editor.util.LabButton;
import gw.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;

public class SettingsDialog
extends JDialog
implements IHandleCancel {
    private JPanel _configPanel;
    private ITab _configTab;
    private JButton _btnOk;
    private Experiment _experiment = this.getGosuPanel().getExperiment();
    private JTree _tree;
    private List<ISettings> _modifiedSettings = new ArrayList<ISettings>();
    private Map<ISettings, Pair<ISettingsParameters, JComponent>> _mapSettings = new HashMap<ISettings, Pair<ISettingsParameters, JComponent>>();
    private ISettings _mruSettings;

    public SettingsDialog() {
        super(LabFrame.instance(), "Settings", true);
        this.configUi();
    }

    protected void configUi() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        contentPane.setLayout(new BorderLayout());
        this._configPanel = new JPanel(new BorderLayout());
        TabPane configTabPane = new TabPane(TabPosition.TOP, 7);
        this._configTab = configTabPane.addTab("No Selection", null, this._configPanel);
        JPanel buttonPanel = this.makeButtonPanel();
        CollapsibleSplitPane splitPane = new CollapsibleSplitPane(0, this.makeTreePanel(), configTabPane);
        this.add((Component)splitPane, "Center");
        splitPane.setPosition(30.0);
        contentPane.add((Component)splitPane, "Center");
        JPanel south = new JPanel(new BorderLayout());
        south.setBackground(Scheme.active().getMenu());
        south.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        JPanel filler = new JPanel();
        filler.setBackground(Scheme.active().getMenu());
        south.add((Component)filler, "Center");
        south.add((Component)buttonPanel, "East");
        contentPane.add((Component)south, "South");
        contentPane.setBackground(Scheme.active().getMenu());
        this.mapCancelKeystroke("Cancel", this::close);
        this.setSize(800, 500);
        EditorUtilities.centerWindowInFrame(this, this.getOwner());
    }

    private void save() {
        this._modifiedSettings.forEach(e -> {
            Pair<ISettingsParameters, JComponent> pair = this._mapSettings.get(e);
            e.setParams((ISettingsParameters)pair.getFirst(), true);
        });
        this._experiment.setMruSettings(this._mruSettings);
        this._experiment.save();
        LabFrame.saveSettings();
    }

    private void close() {
        this.dispose();
    }

    public SettingsTree getSelectedTree() {
        return (SettingsTree)this._tree.getLastSelectedPathComponent();
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(Scheme.active().getMenu());
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.addOkButton(buttonPanel);
        this.addSeparator(buttonPanel);
        LabButton btnCancel = new LabButton("Cancel");
        btnCancel.addActionListener(e -> this.close());
        buttonPanel.add(btnCancel);
        return buttonPanel;
    }

    private void addSeparator(JPanel buttonPanel) {
        JPanel separator = new JPanel();
        separator.setBackground(Scheme.active().getMenu());
        separator.setMinimumSize(new Dimension(8, 8));
        buttonPanel.add(separator);
    }

    private void addOkButton(JPanel buttonPanel) {
        this._btnOk = new LabButton("OK");
        this._btnOk.addActionListener(e -> {
            this.save();
            this.close();
        });
        buttonPanel.add(this._btnOk);
        this.getRootPane().setDefaultButton(this._btnOk);
    }

    private JComponent makeTreePanel() {
        DefaultTreeModel model = new DefaultTreeModel(this.makeSettingsTree());
        this._tree = new JTree(model);
        this._tree.setBackground(Scheme.active().getWindow());
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.setRowHeight(22);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setVisibleRowCount(20);
        this._tree.setCellRenderer(new SettingsTreeCellRenderer(this._tree));
        this._tree.addTreeSelectionListener(new SelectionHandler());
        JScrollPane scroller = new JScrollPane(this._tree);
        scroller.setBorder(BorderFactory.createEmptyBorder());
        this.expandAll();
        this.selectMruSettings();
        TabPane tabPane = new TabPane(TabPosition.TOP, 7);
        tabPane.addTab("Settings", null, scroller);
        return tabPane;
    }

    private SettingsTree makeSettingsTree() {
        SettingsTree root = new SettingsTree();
        ArrayList<ISettings> settings = new ArrayList<ISettings>(this._experiment.getSettings().values());
        LabFrame.instance();
        settings.addAll(LabFrame.getSettings().values());
        while (!settings.isEmpty()) {
            Iterator iterator = settings.iterator();
            while (iterator.hasNext()) {
                ISettings rc = (ISettings)iterator.next();
                SettingsTree parent = root.find(rc.getParentPath());
                if (parent == null) continue;
                parent.addChild(new SettingsTree(rc, parent));
                iterator.remove();
            }
        }
        return root;
    }

    public void expandAll() {
        this.expandAll(0, this._tree.getRowCount());
    }

    void expandAll(int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            this._tree.expandRow(i);
        }
        if (this._tree.getRowCount() != rowCount) {
            this.expandAll(rowCount, this._tree.getRowCount());
        }
    }

    private void showConfigPanel() {
        this._configPanel.removeAll();
        SettingsTree selection = this.getSelectedTree();
        if (selection == null) {
            return;
        }
        ISettings settings = selection.getSettings();
        if (settings != null) {
            Pair pair = this._mapSettings.get(settings);
            if (pair == null) {
                ISettingsParameters copyParams = this.copyParams(settings);
                pair = new Pair((Object)copyParams, (Object)settings.makePanel(copyParams, cp -> this.settingsChanged((ISettingsParameters)cp)));
                this._mapSettings.put(settings, (Pair<ISettingsParameters, JComponent>)pair);
                EventQueue.invokeLater(() -> this.modifiedConfig(settings));
            }
            this._configPanel.add((Component)pair.getSecond(), "Center");
        } else {
            JComponent emptySelection = this.makeEmptyPanel();
            this._configPanel.add((Component)emptySelection, "Center");
            this._configPanel.revalidate();
        }
        this._configPanel.repaint();
    }

    private void settingsChanged(ISettingsParameters params) {
        for (Map.Entry<ISettings, Pair<ISettingsParameters, JComponent>> e : this._mapSettings.entrySet()) {
            if (e.getValue().getFirst() != params) continue;
            SettingsTree tree = ((SettingsTree)this._tree.getModel().getRoot()).find(e.getKey());
            ((DefaultTreeModel)this._tree.getModel()).nodeChanged(tree);
            break;
        }
    }

    private ISettingsParameters copyParams(ISettings settings) {
        Object params = settings.makeDefaultParameters(this._experiment);
        settings.getParams().copy(params);
        return params;
    }

    private JComponent makeEmptyPanel() {
        return new JPanel(new BorderLayout());
    }

    private void modifiedConfig(ISettings settings) {
        if (this._modifiedSettings.contains(settings)) {
            throw new IllegalStateException();
        }
        this._modifiedSettings.add(settings);
    }

    private void selectMruSettings() {
        ISettings settings = this._experiment.getMruSettings();
        if (settings == null) {
            this._tree.setSelectionRow(0);
            return;
        }
        SettingsTree tree = ((SettingsTree)this._tree.getModel().getRoot()).find(settings);
        if (tree != null) {
            tree.select(this._tree);
        }
    }

    private GosuPanel getGosuPanel() {
        return LabFrame.instance().getGosuPanel();
    }

    private class SelectionHandler
    implements TreeSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            SettingsDialog.this.showConfigPanel();
            SettingsTree selection = SettingsDialog.this.getSelectedTree();
            if (selection != null) {
                ((IEditableLabel)SettingsDialog.this._configTab.getLabel()).setDisplayName(selection.getSettings().getName());
                SettingsDialog.this._mruSettings = selection.getSettings();
            } else {
                ((IEditableLabel)SettingsDialog.this._configTab.getLabel()).setDisplayName("No Selection");
                SettingsDialog.this._mruSettings = null;
                SettingsDialog.this._configPanel.repaint();
            }
        }
    }

    public class SettingsTreeCellRenderer
    extends AbstractTreeCellRenderer<SettingsTree> {
        public SettingsTreeCellRenderer(JTree tree) {
            super(tree);
        }

        @Override
        public void configure() {
            SettingsTree node = (SettingsTree)this.getNode();
            if (node == null) {
                return;
            }
            this.setBorder(new EmptyBorder(0, 3, 0, 3));
            ISettings settings = node.getSettings();
            if (settings != null) {
                this.setText(settings.getName());
            } else {
                this.setText("<root>");
            }
            this.setIcon(node.getIcon());
        }
    }
}

