/*
 * Decompiled with CFR 0.152.
 */
package editor.settings;

import editor.settings.ISettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SettingsTree
implements MutableTreeNode {
    private ISettings _settings;
    private SettingsTree _parent;
    private List<SettingsTree> _children;

    public SettingsTree() {
        this._children = Collections.emptyList();
    }

    public SettingsTree(ISettings settings, SettingsTree parent) {
        this._parent = parent;
        this._settings = settings;
        this._children = Collections.emptyList();
    }

    public ISettings getSettings() {
        return this._settings;
    }

    public boolean isTerminal() {
        return this.getSettings() != null;
    }

    public List<SettingsTree> getChildren() {
        return this._children;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        if (this._children.isEmpty()) {
            this._children = new ArrayList<SettingsTree>();
        }
        this._children.add(index, (SettingsTree)child);
        child.setParent(this);
    }

    public void addChild(SettingsTree child) {
        this.insert(child, this._children.size());
    }

    public void addViaModel(JTree tree, MutableTreeNode child) {
        ((DefaultTreeModel)tree.getModel()).insertNodeInto(child, this, this.getChildCount());
    }

    public void insertViaModel(JTree tree, MutableTreeNode child, int index) {
        ((DefaultTreeModel)tree.getModel()).insertNodeInto(child, this, index);
    }

    public void deleteViaModel(JTree tree, MutableTreeNode child) {
        ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(child);
    }

    @Override
    public void remove(int index) {
        this.remove(this.getChildren().get(index));
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.getChildren().remove(node);
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public void removeFromParent() {
        this._parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this._parent = (SettingsTree)newParent;
    }

    @Override
    public SettingsTree getChildAt(int childIndex) {
        return this.getChildren().get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public SettingsTree getParent() {
        return this._parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isTerminal();
    }

    @Override
    public boolean isLeaf() {
        return this.isTerminal();
    }

    public Enumeration children() {
        final Iterator<SettingsTree> iter = this.getChildren().iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    public String toString() {
        return this._settings != null ? this._settings.getName() : "<root>";
    }

    public void select(JTree tree) {
        TreePath path = this.getPath();
        tree.expandPath(path);
        tree.setSelectionPath(path);
        tree.scrollPathToVisible(path);
    }

    public TreePath getPath() {
        List<SettingsTree> path = this.makePath(new ArrayList<SettingsTree>());
        return new TreePath(path.toArray(new SettingsTree[path.size()]));
    }

    private List<SettingsTree> makePath(List<SettingsTree> path) {
        if (this.getParent() != null) {
            this.getParent().makePath(path);
        }
        path.add(this);
        return path;
    }

    public SettingsTree find(String settingsPath) {
        if (this.getSettings() == null && settingsPath.isEmpty() || settingsPath.equals(this.getSettings().getPath())) {
            return this;
        }
        for (SettingsTree tree : this.getChildren()) {
            SettingsTree found = tree.find(settingsPath);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public SettingsTree find(ISettings settings) {
        if (settings.equals(this.getSettings())) {
            return this;
        }
        for (SettingsTree tree : this.getChildren()) {
            SettingsTree found = tree.find(settings);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Icon getIcon() {
        return this._settings != null ? this._settings.getIcon() : null;
    }
}

