/*
 * Decompiled with CFR 0.152.
 */
package editor.shipit;

import editor.FileTree;
import editor.FileTreeUtil;
import editor.GosuPanel;
import editor.LabFrame;
import editor.MessageTree;
import editor.MessagesPanel;
import editor.NodeKind;
import editor.debugger.Debugger;
import editor.search.IncrementalCompilerUsageSearcher;
import editor.settings.CompilerSettings;
import editor.shipit.CompiledClass;
import editor.shipit.Compiler;
import editor.shipit.FileChangeFinder;
import editor.shipit.ICompileConsumer;
import editor.util.Experiment;
import editor.util.IProgressCallback;
import editor.util.ModalEventQueue;
import editor.util.ProgressFeedback;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.util.PathUtil;
import gw.util.StreamUtil;
import java.awt.EventQueue;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;

public class ExperimentBuild {
    private static ExperimentBuild INSTANCE;
    private final FileChangeFinder _fileChangeFinder;
    private List<CompiledClass> _compiledClassesNoErrors;
    private Set<IType> _errantTypes = new HashSet<IType>();

    public static ExperimentBuild instance() {
        return INSTANCE == null ? (INSTANCE = new ExperimentBuild(true)) : INSTANCE;
    }

    public ExperimentBuild(boolean rebuild) {
        this._fileChangeFinder = new FileChangeFinder(rebuild);
        this._compiledClassesNoErrors = new ArrayList<CompiledClass>();
    }

    public boolean make(ICompileConsumer consumer) {
        consumer = this.getDebugger() == null ? this.chainForNotDebugging(consumer) : this.chainForDebugging(consumer);
        boolean result = this._fileChangeFinder.isRefreshAll() ? this.rebuild(consumer) : this.build(consumer, this.findTypesToCompile(), true);
        return result;
    }

    public boolean compile(ICompileConsumer consumer, Set<IType> typesToCompile) {
        consumer = this.getDebugger() == null ? this.chainForNotDebugging(consumer) : this.chainForDebugging(consumer);
        return this.build(consumer, typesToCompile, true);
    }

    public boolean rebuild(ICompileConsumer consumer) {
        this.cleanCompileOutput();
        this.copySources();
        boolean result = this.build(this.chainForNotDebugging(consumer), Collections.singleton(FileTreeUtil.getRoot()), false);
        TypeSystem.refresh((boolean)false);
        return result;
    }

    private void copySources() {
        if (!CompilerSettings.isStaticCompile()) {
            return;
        }
        Path outputPath = CompilerSettings.getCompilerOutputDir();
        if (!PathUtil.isDirectory((Path)outputPath, (LinkOption[])new LinkOption[0]) && !PathUtil.mkdirs((Path)outputPath)) {
            JOptionPane.showMessageDialog(LabFrame.instance(), "Invalid compiler output path: " + PathUtil.getAbsolutePathName((Path)outputPath));
        }
        Experiment experiment = LabFrame.instance().getGosuPanel().getExperiment();
        for (String sp : experiment.getSourcePath()) {
            Path jarOrDir = PathUtil.getAbsolutePath((Path)PathUtil.create((String)sp, (String[])new String[0]));
            if (!PathUtil.isDirectory((Path)jarOrDir, (LinkOption[])new LinkOption[0])) continue;
            for (Path child : PathUtil.listFiles((Path)jarOrDir)) {
                StreamUtil.copy((Path)child, (Path)outputPath);
            }
        }
    }

    private void cleanCompileOutput() {
        Path dir;
        if (CompilerSettings.isStaticCompile() && PathUtil.isDirectory((Path)(dir = CompilerSettings.getCompilerOutputDir()), (LinkOption[])new LinkOption[0])) {
            for (Path child : PathUtil.listFiles((Path)dir)) {
                PathUtil.delete((Path)child, (boolean)true);
            }
        }
    }

    private Set<IType> findTypesToCompile() {
        Path outputPath = CompilerSettings.getCompilerOutputDir();
        HashSet<IType> types = new HashSet<IType>();
        for (FileTree ft : this._fileChangeFinder.findChangedFiles(ref -> true)) {
            if (ft.getType() != null) {
                IncrementalCompilerUsageSearcher searcher = new IncrementalCompilerUsageSearcher(ft.getType());
                searcher.headlessSearch(FileTreeUtil.getRoot());
                types.addAll(searcher.getTypes());
                continue;
            }
            if (!ft.isFile() || outputPath == null) continue;
            this.copySourceFileToOutputDir(outputPath, ft);
        }
        types.addAll(this._errantTypes);
        return types;
    }

    private void copySourceFileToOutputDir(Path outputPath, FileTree ft) {
        Path dir;
        String fqnDir = ft.getParent().makeFqn();
        if (fqnDir != null) {
            fqnDir = fqnDir.replace('.', File.separatorChar);
            dir = PathUtil.create((Path)outputPath, (String)fqnDir);
            PathUtil.mkdirs((Path)dir);
        } else {
            dir = outputPath;
        }
        Path file = PathUtil.create((Path)dir, (String)PathUtil.getName((Path)ft.getFileOrDir()));
        StreamUtil.copy((Path)ft.getFileOrDir(), (Path)file);
    }

    private Debugger getDebugger() {
        return LabFrame.instance().getGosuPanel().getDebugger();
    }

    private ICompileConsumer chainForDebugging(ICompileConsumer consumer) {
        return cc -> {
            if (!cc.isErrant()) {
                this._compiledClassesNoErrors.add(cc);
            } else {
                this._errantTypes.add((IType)cc.getType());
            }
            return consumer.accept(cc);
        };
    }

    private ICompileConsumer chainForNotDebugging(ICompileConsumer consumer) {
        return cc -> {
            if (cc.isErrant()) {
                this._errantTypes.add((IType)cc.getType());
            }
            return consumer.accept(cc);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean build(ICompileConsumer consumer, Set sources, boolean incremental) {
        GosuPanel gosuPanel = LabFrame.instance().getGosuPanel();
        this._errantTypes = new HashSet<IType>();
        try {
            MessageTree doneMessage;
            MessagesPanel messages = gosuPanel.showMessages(true);
            messages.clear();
            boolean[] bRes = new boolean[]{false};
            boolean[] bFinished = new boolean[]{false};
            Compiler compiler = new Compiler();
            ProgressFeedback.runWithProgress("Compiling...", incremental ? progress -> this.incrementalCompileSources(sources, consumer, messages, bRes, bFinished, compiler, progress) : progress -> this.fullCompileSources(sources, consumer, messages, bRes, bFinished, compiler, progress));
            new ModalEventQueue(() -> !bFinished[0]).run();
            if (bRes[0]) {
                int errors = compiler.getErrors();
                int warnings = compiler.getWarnings();
                String message = "Compilation completed with " + errors + (errors == 1 ? " error " : " errors ") + " and " + warnings + (warnings == 1 ? " warning " : " warnings ");
                doneMessage = new MessageTree(message, errors > 0 ? NodeKind.Error : (warnings > 0 ? NodeKind.Warning : NodeKind.Info), MessageTree.empty());
                messages.insertAtTop(doneMessage);
            } else {
                doneMessage = new MessageTree("Compilation failed to complete", NodeKind.Failure, MessageTree.empty());
                messages.insertAtTop(doneMessage);
            }
            EventQueue.invokeLater(doneMessage::select);
            boolean bl = bRes[0];
            return bl;
        }
        finally {
            this._fileChangeFinder.reset();
            this._compiledClassesNoErrors = new ArrayList<CompiledClass>();
        }
    }

    private void fullCompileSources(Collection<FileTree> sources, ICompileConsumer consumer, MessagesPanel messages, boolean[] bRes, boolean[] bFinished, Compiler compiler, IProgressCallback progress) {
        progress.setLength(sources.stream().mapToInt(FileTree::getTotalFiles).sum());
        for (FileTree fileTree : sources) {
            bRes[0] = bRes[0] | compiler.compileTree(fileTree, consumer, progress, messages);
        }
        this.redefineClassInDebugger();
        bFinished[0] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementalCompileSources(Collection<IType> sources, ICompileConsumer consumer, MessagesPanel messages, boolean[] bRes, boolean[] bFinished, Compiler compiler, IProgressCallback progress) {
        try {
            progress.setLength(sources.size());
            bRes[0] = true;
            for (IType type : sources) {
                progress.incrementProgress(type != null ? type.getName() : "", new String[0]);
                bRes[0] = bRes[0] | compiler.compile(type, consumer, messages);
            }
            this.redefineClassInDebugger();
        }
        finally {
            bFinished[0] = true;
        }
    }

    private void redefineClassInDebugger() {
        Debugger debugger = this.getDebugger();
        if (debugger != null && !this._compiledClassesNoErrors.isEmpty()) {
            debugger.redefineClasses(this._compiledClassesNoErrors);
        }
    }
}

