/*
 * Decompiled with CFR 0.152.
 */
package editor.shipit;

import editor.FileTree;
import editor.FileTreeUtil;
import gw.util.PathUtil;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class FileChangeFinder {
    private long _timestamp;

    public FileChangeFinder(boolean rebuild) {
        this._timestamp = rebuild ? 0L : System.currentTimeMillis();
    }

    public void reset() {
        this._timestamp = System.currentTimeMillis();
    }

    public boolean isRefreshAll() {
        return this._timestamp == 0L;
    }

    public Set<FileTree> findChangedFiles(Predicate<FileTree> filter) {
        return this.findChangedFiles(FileTreeUtil.getRoot(), filter);
    }

    public Set<FileTree> findChangedFiles(FileTree ft, Predicate<FileTree> filter) {
        return this.findChangedFiles(ft, filter, new HashSet<FileTree>());
    }

    private Set<FileTree> findChangedFiles(FileTree ft, Predicate<FileTree> filter, Set<FileTree> result) {
        if (ft.isFile()) {
            if (PathUtil.lastModified((Path)ft.getFileOrDir(), (LinkOption[])new LinkOption[0]) > this._timestamp && filter.test(ft)) {
                result.add(ft);
            }
        } else {
            for (FileTree child : ft.getChildren()) {
                this.findChangedFiles(child, filter, result);
            }
        }
        return result;
    }
}

