/*
 * Decompiled with CFR 0.152.
 */
package editor.splitpane;

import editor.splitpane.EmptyCaptionBar;
import editor.splitpane.ICaptionActionListener;
import editor.splitpane.ICaptionBar;
import editor.splitpane.ICaptionedPanel;
import editor.splitpane.SplitPane;
import editor.tabpane.TabPosition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import javax.swing.JComponent;

public class CollapsibleSplitPane
extends SplitPane {
    private ICaptionedPanel _topMin;
    private ICaptionedPanel _bottomMin;
    private ICaptionActionListener _captionActionListener;

    public CollapsibleSplitPane(int iOrientation, JComponent comp1, JComponent comp2) {
        super(iOrientation, comp1, comp2);
    }

    @Override
    public void setTop(JComponent c) {
        super.setTop(c);
        this.listenToCaptionActions(c);
    }

    @Override
    public void setBottom(JComponent c) {
        super.setBottom(c);
        this.listenToCaptionActions(c);
    }

    public void restorePane() {
        if (this.isMin()) {
            this.toggleCollapseNow(this.getTopMin() == null ? this.getBottomMin() : this.getTopMin());
        }
    }

    public boolean isMin() {
        return this.getTopMin() != null || this.getBottomMin() != null;
    }

    public ICaptionedPanel getTopMin() {
        return this._topMin;
    }

    protected void setTopMin(ICaptionedPanel topMin) {
        this._topMin = topMin;
    }

    public ICaptionedPanel getBottomMin() {
        return this._bottomMin;
    }

    protected void setBottomMin(ICaptionedPanel bottomMin) {
        this._bottomMin = bottomMin;
    }

    public void hearBothSides() {
        this.listenToCaptionActions(this._comp1);
        this.listenToCaptionActions(this._comp2);
    }

    private void listenToCaptionActions(JComponent c) {
        ICaptionedPanel captionedPanel = this.findCaptionedPanel(c);
        if (captionedPanel == null) {
            return;
        }
        if (this._captionActionListener == null) {
            this._captionActionListener = new CaptionActionListener();
        }
        captionedPanel.getCaption().addCaptionActionListener(this._captionActionListener);
    }

    private ICaptionedPanel findCaptionedPanel(Component c) {
        if (!(c instanceof Container)) {
            return null;
        }
        if (c instanceof SplitPane) {
            return null;
        }
        if (c instanceof ICaptionedPanel) {
            return (ICaptionedPanel)((Object)c);
        }
        Component[] children = ((Container)c).getComponents();
        for (int i = 0; i < children.length; ++i) {
            ICaptionedPanel titledPane = this.findCaptionedPanel(children[i]);
            if (titledPane == null) continue;
            return titledPane;
        }
        return null;
    }

    public void toggleCollapse(ICaptionedPanel captionedPanel) {
        EventQueue.invokeLater(() -> this.toggleCollapseNow(captionedPanel));
    }

    private void toggleCollapseNow(ICaptionedPanel captionedPanel) {
        if (this.isInTop(captionedPanel)) {
            this.toggleTopCollapse(captionedPanel);
        } else if (this.isInBottom(captionedPanel)) {
            this.toggleBottomCollapse(captionedPanel);
        }
        EventQueue.invokeLater(() -> {
            this.revalidate();
            this.doLayout();
            this.repaint();
        });
    }

    private void toggleTopCollapse(ICaptionedPanel captionedPanel) {
        if (this.getTopMin() != null) {
            this.restore();
        } else {
            this.collapseTop(captionedPanel);
        }
    }

    private void toggleBottomCollapse(ICaptionedPanel captionedPanel) {
        if (this.getBottomMin() != null) {
            this.restore();
        } else {
            this.collapseBottom(captionedPanel);
        }
    }

    private void restore() {
        Component minBar = this.getComponent(0);
        if (!(minBar instanceof ICaptionBar)) {
            return;
        }
        ICaptionBar bar = (ICaptionBar)((Object)minBar);
        this.removeAll();
        this.addMainComponents(this._comp1, this._comp2);
        this.setTopMin(null);
        this.setBottomMin(null);
        bar.setCaptionType(ICaptionActionListener.ActionType.RESTORE);
        ICaptionedPanel other = this.findCaptionedPanel(this.getTop());
        if (other != null && other.getCaption().getCaptionType() != ICaptionActionListener.ActionType.RESTORE) {
            other.getCaption().setCaptionType(ICaptionActionListener.ActionType.RESTORE);
        } else {
            other = this.findCaptionedPanel(this.getBottom());
            if (other != null && other.getCaption().getCaptionType() != ICaptionActionListener.ActionType.RESTORE) {
                other.getCaption().setCaptionType(ICaptionActionListener.ActionType.RESTORE);
            }
        }
    }

    private void collapseTop(ICaptionedPanel captionedPanel) {
        if (this.getBottomMin() != null) {
            this.setBottomMin(null);
        }
        ICaptionBar minLabel = this.makeMinLabel(captionedPanel, true);
        this.setTopMin(captionedPanel);
        this.removeAll();
        BorderLayout bl = new BorderLayout();
        this.setLayout(bl);
        if (this.getOrientation() == 0) {
            bl.setHgap(4);
            bl.setVgap(4);
            this.add((Component)((Object)minLabel), "West");
        } else {
            bl.setVgap(4);
            bl.setHgap(4);
            this.add((Component)((Object)minLabel), "North");
        }
        ICaptionedPanel bottomCaptionedPanel = this.findCaptionedPanel(this._comp2);
        if (bottomCaptionedPanel != null) {
            bottomCaptionedPanel.getCaption().setCaptionType(ICaptionActionListener.ActionType.MAXIMIZE);
        }
        this.add((Component)this._comp2, "Center");
    }

    public void collapseBottom(ICaptionedPanel bottomCaptionedPanel) {
        if (this.getTopMin() != null) {
            this.setTopMin(null);
        }
        ICaptionBar minLabel = this.makeMinLabel(bottomCaptionedPanel, false);
        this.setBottomMin(bottomCaptionedPanel);
        this.removeAll();
        BorderLayout bl = new BorderLayout();
        this.setLayout(bl);
        int iGap = minLabel instanceof EmptyCaptionBar ? 0 : 4;
        String location = this.getOrientation() == 0 ? "East" : "South";
        bl.setHgap(iGap);
        bl.setVgap(iGap);
        this.add((Component)((Object)minLabel), location);
        ICaptionedPanel topCaptionedPanel = this.findCaptionedPanel(this._comp1);
        if (topCaptionedPanel != null) {
            topCaptionedPanel.getCaption().setCaptionType(ICaptionActionListener.ActionType.MAXIMIZE);
        }
        this.add((Component)this._comp1, "Center");
    }

    private ICaptionBar makeMinLabel(ICaptionedPanel captionedPanel, boolean bTop) {
        captionedPanel.getCaption().setCaptionType(ICaptionActionListener.ActionType.MINIMIZE);
        ICaptionBar bar = captionedPanel.getCaption().getMinimizedPanel(this.getOrientation() == 0 ? (bTop ? TabPosition.LEFT : TabPosition.RIGHT) : TabPosition.TOP);
        bar.setCaptionType(ICaptionActionListener.ActionType.MINIMIZE);
        return bar;
    }

    private boolean isInTop(ICaptionedPanel captionedPanel) {
        Component c;
        for (c = (Component)((Object)captionedPanel); c != this._comp1 && c != null; c = c.getParent()) {
        }
        return c == this._comp1;
    }

    private boolean isInBottom(ICaptionedPanel captionedPanel) {
        Component c;
        for (c = (Component)((Object)captionedPanel); c != this._comp2 && c != null; c = c.getParent()) {
        }
        return c == this._comp2;
    }

    private class CaptionActionListener
    implements ICaptionActionListener {
        @Override
        public void captionActionPerformed(ICaptionedPanel captionedPanel, ICaptionActionListener.ActionType actionType) {
            if (actionType == ICaptionActionListener.ActionType.MINIMIZE) {
                CollapsibleSplitPane.this.toggleCollapse(captionedPanel);
            } else if (actionType == ICaptionActionListener.ActionType.RESTORE) {
                CollapsibleSplitPane.this.restore();
            } else if (actionType == ICaptionActionListener.ActionType.MAXIMIZE) {
                if (CollapsibleSplitPane.this.getTop() == captionedPanel || CollapsibleSplitPane.this.getTop().isAncestorOf((Component)((Object)captionedPanel))) {
                    ICaptionedPanel bottom = CollapsibleSplitPane.this.findCaptionedPanel(CollapsibleSplitPane.this.getBottom());
                    if (bottom != null) {
                        CollapsibleSplitPane.this.toggleBottomCollapse(bottom);
                    }
                } else {
                    ICaptionedPanel top = CollapsibleSplitPane.this.findCaptionedPanel(CollapsibleSplitPane.this.getTop());
                    if (top != null) {
                        CollapsibleSplitPane.this.toggleTopCollapse(top);
                    }
                }
            }
            CollapsibleSplitPane.this.revalidate();
            CollapsibleSplitPane.this.repaint();
        }
    }
}

