/*
 * Decompiled with CFR 0.152.
 */
package editor.tabpane;

import editor.IContextMenuHandler;
import editor.Scheme;
import editor.tabpane.ContentContainer;
import editor.tabpane.ITab;
import editor.tabpane.MoreTab;
import editor.tabpane.TabContainerLayoutManager;
import editor.tabpane.TabPane;
import editor.tabpane.TabPosition;
import editor.util.EditorUtilities;
import editor.util.IDisposable;
import editor.util.ILabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class TabContainer
extends JPanel {
    public static final String TAB_PROPERTY = "_ITab";
    private List<ITab> _orderedTabs;
    private MoreTab _moreTab;
    private TabPosition _tabPosition;
    private EventListenerList _selectionListeners;
    private EventListenerList _tabPositionListeners;
    private IContextMenuHandler<JComponent> _contextMenuHandler;

    public TabContainer(TabPosition tabPosition) {
        this._tabPosition = tabPosition;
        this._orderedTabs = new ArrayList<ITab>();
        this._selectionListeners = new EventListenerList();
        this._tabPositionListeners = new EventListenerList();
        this._moreTab = new MoreTab(this);
        this.add(this._moreTab);
        this.setLayout(new TabContainerLayoutManager());
        this.setOpaque(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EventQueue.invokeLater(this::revalidate);
    }

    public TabPosition getTabPosition() {
        return this._tabPosition;
    }

    public void setTabPosition(TabPosition tabPosition) {
        this._tabPosition = tabPosition;
        this.fireTabPositionChanged();
    }

    public ITab[] getTabs() {
        return this._orderedTabs.toArray(new ITab[this._orderedTabs.size()]);
    }

    public void addTab(ITab tab) {
        this.insertTab(tab, -1, true);
    }

    public void addTabWithoutSelecting(ITab tab) {
        this.insertTabWithoutSelecting(tab, -1);
    }

    public ITab insertTab(ITab tab, int iIndex, boolean focus) {
        this.resetComponentOrderToTabOrder();
        iIndex = iIndex < 0 ? this._orderedTabs.size() : iIndex;
        this._orderedTabs.add(iIndex, tab);
        JComponent comp = tab.getComponent();
        comp.putClientProperty(TAB_PROPERTY, tab);
        this.add((Component)comp, iIndex);
        tab.getComponent().addMouseListener(new MouseOnTabHandler());
        this.selectTab(tab, focus);
        return tab;
    }

    public ITab insertTabWithoutSelecting(ITab tab, int iIndex) {
        ITab selected = this.getSelectedTab();
        this.insertTab(tab, iIndex, false);
        if (selected != null) {
            this.selectTab(selected, false);
        }
        return tab;
    }

    public void removeTab(ITab tab) {
        this._orderedTabs.remove(tab);
        this.remove(tab.getComponent());
        this.dispose(tab);
        this.revalidate();
        this.repaint();
        this.fireSelectionChanged(tab);
    }

    private void dispose(ITab tab) {
        JComponent contentPane;
        ILabel label = tab.getLabel();
        if (label instanceof IDisposable) {
            ((IDisposable)((Object)label)).dispose();
        }
        if ((contentPane = tab.getContentPane()) instanceof IDisposable && contentPane != label) {
            ((IDisposable)((Object)contentPane)).dispose();
        }
        tab.dispose();
    }

    public void removeTabWithContent(JComponent contentPane) {
        ITab tab = this.findTabWithContent(contentPane);
        if (tab != null) {
            this.removeTab(tab);
        }
    }

    public void removeAllTabs() {
        for (int i = this._orderedTabs.size() - 1; i >= 0; --i) {
            ITab tab = this._orderedTabs.get(i);
            this.removeTab(tab);
        }
    }

    public int getTabCount() {
        return this._orderedTabs.size();
    }

    public ITab getTabAt(int iIndex) {
        return this._orderedTabs.get(iIndex);
    }

    public ITab getSelectedTab() {
        if (this._orderedTabs.size() == 0) {
            return null;
        }
        return TabContainer.tabFromComponent(this.getFirstTabComponent());
    }

    private Component getFirstTabComponent() {
        for (Component c : this.getComponents()) {
            if (c == this._moreTab) continue;
            return c;
        }
        return null;
    }

    public int getSelectedTabIndex() {
        if (this._orderedTabs.size() == 0) {
            return -1;
        }
        return this._orderedTabs.indexOf(this.getSelectedTab());
    }

    public void selectTab(JComponent contentPane, boolean focus) {
        ITab tab = this.findTabWithContent(contentPane);
        if (tab != null) {
            this.selectTab(tab, focus);
        }
    }

    public void selectTab(int iTabIndex) {
        if (iTabIndex >= this._orderedTabs.size()) {
            throw new IllegalArgumentException(iTabIndex + " > " + this._orderedTabs.size());
        }
        ITab tab = this._orderedTabs.get(iTabIndex);
        this.selectTab(tab, true);
    }

    public void selectTab(ITab tab, boolean bFocus) {
        if (this.getSelectedTab() == tab && EditorUtilities.isInFocusLineage(tab.getContentPane())) {
            return;
        }
        if (this.isShowing() && (!tab.getComponent().isShowing() || this.getTabPane() != null && this.getTabPane().isDynamic() && !this.isInView(tab))) {
            this._orderedTabs.remove(tab);
            this._orderedTabs.add(0, tab);
        }
        this.resetComponentOrderToTabOrder();
        JComponent tabComponent = tab.getComponent();
        this.add((Component)tabComponent, 0);
        this.revalidate();
        this.repaint();
        this.fireSelectionChanged(tab);
        if (bFocus) {
            this.setFocusToSelectedTab();
        }
    }

    private boolean isInView(ITab tab) {
        return tab.getComponent().getX() + tab.getComponent().getWidth() <= this.getWidth();
    }

    private void setFocusToSelectedTab() {
        JComponent selectedTabComponent;
        ITab selectedTab = this.getSelectedTab();
        JComponent jComponent = selectedTabComponent = selectedTab == null ? null : selectedTab.getComponent();
        if (selectedTabComponent != null && !EditorUtilities.containsFocus(selectedTabComponent)) {
            selectedTabComponent.transferFocus();
        }
    }

    public ITab findTabWithContent(JComponent contentPane) {
        for (int i = 0; i < this._orderedTabs.size(); ++i) {
            ITab tab = this._orderedTabs.get(i);
            if (tab.getContentPane() != contentPane) continue;
            return tab;
        }
        return null;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int iIndex) {
        ITab tab;
        if (!(comp instanceof JComponent)) {
            throw new IllegalArgumentException("Not a JComponent");
        }
        if (comp != this._moreTab && (tab = TabContainer.tabFromComponent(comp)) == null) {
            throw new IllegalArgumentException("Not an ITab");
        }
        super.addImpl(comp, constraints, iIndex);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isShowBaseLine()) {
            return;
        }
        g.setColor(Scheme.active().getScrollbarBorderColor());
        if (this.getTabPosition() == TabPosition.TOP) {
            g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        } else if (this.getTabPosition() == TabPosition.BOTTOM) {
            g.drawLine(0, 0, this.getWidth() - 1, 0);
        } else if (this.getTabPosition() == TabPosition.LEFT) {
            g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
        } else {
            g.drawLine(0, 0, 0, this.getHeight() - 1);
        }
    }

    public void addSelectionListener(ChangeListener l) {
        this._selectionListeners.add(ChangeListener.class, l);
    }

    public void removeSelectionListener(ChangeListener l) {
        this._selectionListeners.remove(ChangeListener.class, l);
    }

    private void fireSelectionChanged(ITab tab) {
        Object[] listeners = this._selectionListeners.getListenerList();
        if (listeners.length == 0) {
            return;
        }
        TabChangeEvent e = new TabChangeEvent(this, tab);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    public void addTabpositionListener(ChangeListener l) {
        this._tabPositionListeners.add(ChangeListener.class, l);
    }

    public void removeTabpositionListener(ChangeListener l) {
        this._tabPositionListeners.remove(ChangeListener.class, l);
    }

    private void fireTabPositionChanged() {
        Object[] listeners = this._tabPositionListeners.getListenerList();
        if (listeners.length == 0) {
            return;
        }
        ChangeEvent e = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    public void setContextMenuHandler(IContextMenuHandler<JComponent> handler) {
        this._contextMenuHandler = handler;
    }

    public IContextMenuHandler<JComponent> getContextMenuHandler() {
        return this._contextMenuHandler;
    }

    private void resetComponentOrderToTabOrder() {
        if (this._orderedTabs.size() == 0) {
            return;
        }
        ITab tabSelected = TabContainer.tabFromComponent(this.getFirstTabComponent());
        this.add((Component)tabSelected.getComponent(), this._orderedTabs.indexOf(tabSelected));
    }

    public static ITab tabFromComponent(Component comp) {
        return (ITab)((JComponent)comp).getClientProperty(TAB_PROPERTY);
    }

    public boolean isVertical() {
        return this._tabPosition == TabPosition.LEFT || this._tabPosition == TabPosition.RIGHT;
    }

    public boolean isShowBaseLine() {
        TabPane tabPane = this.getTabPane();
        return tabPane != null && tabPane.isShowing();
    }

    public TabPane getTabPane() {
        for (Container p = this.getParent(); p != null && !(p instanceof Window) && !(p instanceof ContentContainer); p = p.getParent()) {
            if (!(p instanceof TabPane)) continue;
            return (TabPane)p;
        }
        return null;
    }

    private void displayContextMenu(MouseEvent e) {
        IContextMenuHandler<JComponent> handler = this.getContextMenuHandler();
        if (handler != null) {
            JComponent c = (JComponent)e.getSource();
            handler.displayContextMenu(c, e.getX(), c.getHeight(), e.getComponent());
        }
    }

    public MoreTab getMoreTab() {
        return this._moreTab;
    }

    public static class TabChangeEvent
    extends ChangeEvent {
        private ITab _tab;

        public TabChangeEvent(TabContainer tabContainer, ITab tab) {
            super(tabContainer);
            this._tab = tab;
        }

        public ITab getTab() {
            return this._tab;
        }
    }

    class MouseOnTabHandler
    extends MouseAdapter {
        MouseOnTabHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TabPane tabPane;
            JComponent tabComp = (JComponent)e.getSource();
            ITab tab = TabContainer.tabFromComponent(tabComp);
            if ((SwingUtilities.isMiddleMouseButton(e) || (e.getModifiers() & 1) != 0) && (tabPane = TabContainer.this.getTabPane()) != null && tabPane.isDynamic()) {
                TabContainer.this.removeTab(tab);
                return;
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                TabContainer.this.displayContextMenu(e);
                return;
            }
            if (TabContainer.this.getSelectedTab() == tab && tab.getContentPane().isShowing()) {
                return;
            }
            TabContainer.this.selectTab(tab, true);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JComponent tabComp = (JComponent)e.getSource();
            ITab tab = TabContainer.tabFromComponent(tabComp);
            if (tab != null) {
                tab.setHover(true);
                tabComp.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JComponent tabComp = (JComponent)e.getSource();
            ITab tab = TabContainer.tabFromComponent(tabComp);
            if (tab != null) {
                tab.setHover(false);
                tabComp.repaint();
            }
        }
    }
}

