/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class LabGlassPane
extends JPanel {
    private static final LabGlassPane INSTANCE = new LabGlassPane();
    private final Set<Component> _modalComponents = new HashSet<Component>();
    private Component _recentFocusOwner;
    private boolean _firstTime = true;

    public static LabGlassPane getInstance() {
        return INSTANCE;
    }

    private LabGlassPane() {
        super(null);
        this.setOpaque(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (Component component : LabGlassPane.this._modalComponents) {
                    LabGlassPane.this.centerComponent(component);
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        JRootPane rootPane;
        super.paintComponent(g);
        if (!this._modalComponents.isEmpty() && (rootPane = SwingUtilities.getRootPane(this)) != null) {
            rootPane.getLayeredPane().print(g);
        }
    }

    public void addModalComponent(Component component) {
        if (component == null || !this._modalComponents.add(component)) {
            return;
        }
        this.add(component);
        this.centerComponent(component);
        this.validate();
        this.hideLayeredPaneAndShowThisPane(true);
    }

    public void removeModalComponent(Component component) {
        if (component == null || !this._modalComponents.remove(component)) {
            return;
        }
        this.remove(component);
        this.hideLayeredPaneAndShowThisPane(!this._modalComponents.isEmpty());
    }

    private void centerComponent(Component component) {
        component.setLocation((this.getWidth() - component.getWidth()) / 2, (this.getHeight() - component.getHeight()) / 2);
    }

    public void hideLayeredPaneAndShowThisPane(boolean bShowThisPane) {
        boolean oldVisible = this.isVisible();
        this.setVisible(bShowThisPane);
        JRootPane rootPane = SwingUtilities.getRootPane(this);
        if (rootPane != null && (this._firstTime || this.isVisible() != oldVisible)) {
            this._firstTime = false;
            if (bShowThisPane) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
                if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, rootPane)) {
                    this._recentFocusOwner = focusOwner;
                }
                rootPane.getLayeredPane().setVisible(false);
                this.requestFocusInWindow();
            } else {
                rootPane.getLayeredPane().setVisible(true);
                if (this._recentFocusOwner != null) {
                    this._recentFocusOwner.requestFocusInWindow();
                }
                this._recentFocusOwner = null;
            }
        }
        if (bShowThisPane) {
            this.repaint();
        }
    }
}

