/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.StringPopup;
import editor.util.EditorUtilities;
import editor.util.LabToolbarButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class MoreTextEditor
extends JPanel {
    private JTextField _editText;
    private final boolean _bConvertNewLineToSpaace;
    private LabToolbarButton _btnDir;

    public MoreTextEditor(String title, boolean bConvertNewLineToSpace) {
        super(new GridBagLayout());
        this._bConvertNewLineToSpaace = bConvertNewLineToSpace;
        this.configUi(title);
    }

    public Document getDocument() {
        return this._editText.getDocument();
    }

    public void setText(String vmArgs) {
        this._editText.setText(vmArgs);
    }

    public String getText() {
        return this._editText.getText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._editText.setEnabled(enabled);
        this._btnDir.setEnabled(enabled);
    }

    private void configUi(final String title) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 3);
        this._editText = new JTextField();
        this.add((Component)this._editText, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this._btnDir = new LabToolbarButton(new AbstractAction(title, EditorUtilities.loadIcon("images/ellipsis.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoreTextEditor.this.getMoreText(title);
            }
        });
        this.add((Component)this._btnDir, c);
    }

    void getMoreText(String title) {
        StringPopup popup = new StringPopup(this._editText.getText(), title, this._editText, false, 5, 45);
        popup.addNodeChangeListener(e -> {
            String text = e.getSource().toString();
            if (this._bConvertNewLineToSpaace) {
                text = text.replace('\n', ' ');
            }
            this._editText.setText(text);
            this._editText.requestFocus();
            EditorUtilities.fixSwingFocusBugWhenPopupCloses(this._editText);
            this._editText.repaint();
        });
        popup.show(this, 0, 0);
        EditorUtilities.centerWindowInFrame(popup, EditorUtilities.getWindow());
    }
}

