/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.IHandleCancel;
import editor.LabFrame;
import editor.util.EditorUtilities;
import editor.util.LabButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class AbstractCloseDialog
extends JDialog
implements IHandleCancel {
    protected JButton _btnClose;

    public AbstractCloseDialog(String strCaption) {
        super(LabFrame.instance(), strCaption, true);
        this.init();
    }

    public AbstractCloseDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractCloseDialog.this.close();
            }
        });
    }

    protected abstract JComponent createCenterPanel();

    protected void close() {
        this.dispose();
    }

    protected void configUi() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JComponent centerPanel = this.createCenterPanel();
        JComponent buttonPanel = this.createButtonPanel();
        contentPane.add((Component)centerPanel, "Center");
        contentPane.add((Component)buttonPanel, "South");
        this.setInitialSize();
        EditorUtilities.centerWindowInFrame(this, this.getOwner());
    }

    protected void setInitialSize() {
        this.pack();
    }

    protected JComponent createButtonPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        FlowLayout layout = new FlowLayout();
        layout.setVgap(0);
        btnPanel.setLayout(layout);
        this._btnClose = this.createCloseButton();
        this.getRootPane().setDefaultButton(this._btnClose);
        this._btnClose.addActionListener(e -> this.close());
        this.mapCancelKeystroke("Close", this::close);
        btnPanel.add(this._btnClose);
        return btnPanel;
    }

    protected JButton createCloseButton() {
        return new LabButton("Close");
    }
}

