/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.EditorHostTextPane;
import editor.FileTree;
import editor.FileTreeUtil;
import editor.GosuPanel;
import editor.IEditorHost;
import editor.LabFrame;
import editor.Scheme;
import editor.SimpleDocumentFilter;
import editor.StringPopup;
import editor.search.SearchLocation;
import editor.undo.AtomicUndoManager;
import editor.util.EditorUtilities;
import editor.util.TaskQueue;
import editor.util.TextComponentUtil;
import editor.util.transform.java.JavaToGosu;
import gw.lang.GosuShop;
import gw.lang.parser.IParserPart;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISourceCodeTokenizer;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.IToken;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.util.GosuStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;

public abstract class EditorHost
extends JPanel
implements IEditorHost {
    public static final int TAB_SIZE = 2;
    public static final String INTELLISENSE_TASK_QUEUE = "_intellisenseParser";
    static int COMPLETION_DELAY = 500;
    private JPopupMenu _completionPopup;
    private AtomicUndoManager _undoMgr;
    private UndoableEditListener _uel;
    private IScriptPartId _partId;
    private boolean _bParserSuspended;
    private boolean _bEnterPressedConsumed;
    private boolean _bAltDown;
    private boolean _bCompleteCode;
    private int _iTimerCount;
    private static TimerPool _timerPool = new TimerPool();
    private HighlightMode _highlightMode = HighlightMode.SEARCH;

    EditorHost(AtomicUndoManager atomicUndoManager) {
        this._undoMgr = atomicUndoManager;
    }

    @Override
    public IScriptPartId getScriptPart() {
        return this._partId;
    }

    @Override
    public void setScriptPart(IScriptPartId partId) {
        this._partId = partId;
    }

    @Override
    public AtomicUndoManager getUndoManager() {
        return this._undoMgr;
    }

    @Override
    public void read(IScriptPartId partId, String strSource) throws IOException {
        this.setScriptPart(partId);
        this.setLabel("");
        EditorHostTextPane editor = this.getEditor();
        AbstractDocument doc = (AbstractDocument)editor.getDocument();
        if (doc != null) {
            doc.removeDocumentListener(this.getDocHandler());
        }
        strSource = GosuStringUtil.replace((String)strSource, (String)"\r\n", (String)"\n");
        editor.read(new StringReader(strSource), (Object)"");
        this.addDocumentListener();
        this.parse();
    }

    public void parseAndWaitForParser() {
        this.parse();
        this.waitForParser();
    }

    public void waitForParser() {
        TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE).postTaskAndWait(() -> {});
    }

    protected void addKeyHandlers() {
        EditorHostTextPane editor = this.getEditor();
        editor.getInputMap().put(KeyStroke.getKeyStroke("TAB"), "_bulkIndent");
        editor.getActionMap().put("_bulkIndent", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditorHost.this.isCompletionPopupShowing()) {
                    EditorHost.this.handleBulkIndent(false);
                }
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke("shift TAB"), "_bulkOutdent");
        editor.getActionMap().put("_bulkOutdent", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditorHost.this.isCompletionPopupShowing()) {
                    EditorHost.this.handleBulkIndent(true);
                }
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " SLASH"), "_bulkComment");
        editor.getActionMap().put("_bulkComment", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditorHost.this.isCompletionPopupShowing()) {
                    EditorHost.this.handleBulkComment();
                }
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "_removeHighlights");
        editor.getActionMap().put("_removeHighlights", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHost.this.setHighlightMode(HighlightMode.SEARCH);
                EditorHost.this.removeAllHighlights();
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke("F3"), "_gotoNextHighlight");
        editor.getActionMap().put("_gotoNextHighlight", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorHost.this.getHighlightMode() == HighlightMode.USAGES) {
                    EditorHost.this.gotoNextUsageHighlight();
                }
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke("shift F3"), "_gotoPrevHighlight");
        editor.getActionMap().put("_gotoPrevHighlight", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorHost.this.getHighlightMode() == HighlightMode.USAGES) {
                    EditorHost.this.gotoPrevUsageHighlight();
                }
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke(8, EditorUtilities.CONTROL_KEY_MASK), "_deleteWord");
        editor.getActionMap().put("_deleteWord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHost.this.deleteWord();
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke(127, EditorUtilities.CONTROL_KEY_MASK), "_deleteWordForward");
        editor.getActionMap().put("_deleteWordForward", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHost.this.deleteWordForwards();
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke(89, EditorUtilities.CONTROL_KEY_MASK), "_deleteLine");
        editor.getActionMap().put("_deleteLine", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHost.this.deleteLine();
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " shift J"), "_joinLines");
        editor.getActionMap().put("_joinLines", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHost.this.joinLines();
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " G"), "_gotoLine");
        editor.getActionMap().put("_gotoLine", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHost.this.displayGotoLinePopup();
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke(9, 64), "_unindent");
        editor.getActionMap().put("_unindent", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHost.this.unindent();
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " Z"), "_undo");
        editor.getActionMap().put("_undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtomicUndoManager undoManager = EditorHost.this.getUndoManager();
                if (undoManager.canUndo()) {
                    undoManager.undo();
                }
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke("alt F1"), "_selectFileInTree");
        editor.getActionMap().put("_selectFileInTree", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHost.this.showFileInTree();
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke(76, EditorUtilities.CONTROL_KEY_MASK), "_centerView");
        editor.getActionMap().put("_centerView", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHost.this.centerView();
            }
        });
        editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " D"), "_duplicate");
        editor.getActionMap().put("_duplicate", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHost.this.duplicate();
            }
        });
        TextComponentUtil.fixTextComponentKeyMap(this.getEditor());
    }

    public void showFileInTree() {
        GosuPanel gosuPanel = LabFrame.instance().getGosuPanel();
        Path file = gosuPanel.getCurrentFile();
        FileTree root = FileTreeUtil.getRoot();
        FileTree fileTree = root.find(file);
        if (fileTree != null) {
            fileTree.select();
        }
    }

    public int getLineNumberAtCaret() {
        return this.getEditor().getDocument().getDefaultRootElement().getElementIndex(this.getEditor().getCaretPosition()) + 1;
    }

    public int getLineOffset(int iLine) {
        Element root = this.getDocument().getRootElements()[0];
        iLine = root.getElementCount() < iLine ? root.getElementCount() : iLine;
        Element elemAtLine = root.getElement(iLine);
        return elemAtLine == null ? 0 : elemAtLine.getStartOffset();
    }

    void handleBulkIndent(boolean bOutdent) {
        CompoundEdit atom = this.getUndoManager().beginUndoAtom(bOutdent ? "Outdent" : "Indent");
        try {
            this._handleBulkIndent(bOutdent);
        }
        finally {
            this.getUndoManager().endUndoAtom(atom);
        }
    }

    void _handleBulkIndent(boolean bOutdent) {
        int iSelectionEnd;
        EditorHostTextPane editor = this.getEditor();
        String strTabSpaces = this.getIndentWhitespace();
        int iSelectionStart = editor.getSelectionStart();
        if (iSelectionStart == (iSelectionEnd = editor.getSelectionEnd())) {
            ((JTextComponent)editor).replaceSelection(strTabSpaces);
            return;
        }
        this.revalidate();
        Element root = editor.getDocument().getRootElements()[0];
        int iStartIndex = root.getElementIndex(iSelectionStart);
        int iEndIndex = root.getElementIndex(iSelectionEnd);
        if (iStartIndex != iEndIndex && root.getElement(iEndIndex).getStartOffset() == iSelectionEnd) {
            iEndIndex = root.getElementIndex(--iSelectionEnd);
        }
        try {
            for (int i = iStartIndex; i <= iEndIndex; ++i) {
                int iEnd;
                Element line = root.getElement(i);
                int iStart = line.getStartOffset();
                String strLine = editor.getText(iStart, (iEnd = line.getEndOffset()) - iStart);
                if (strLine.trim().length() == 0) continue;
                if (strLine.length() > 0 && bOutdent) {
                    if (strLine.startsWith(strTabSpaces)) {
                        strLine = strLine.substring(2);
                    } else if (Character.isWhitespace(strLine.charAt(0))) {
                        strLine = strLine.substring(1);
                    }
                } else {
                    strLine = strTabSpaces + strLine;
                }
                iEnd = line.getEndOffset();
                editor.select(iStart, iEnd);
                ((JTextComponent)editor).replaceSelection(strLine);
                iSelectionEnd = editor.getSelectionEnd();
            }
            editor.select(iSelectionStart, iSelectionEnd);
        }
        catch (Exception ex) {
            EditorUtilities.handleUncaughtException(ex);
        }
    }

    @Override
    public void setLabel(String label) {
    }

    @Override
    public AbstractDocument getDocument() {
        return (AbstractDocument)this.getEditor().getDocument();
    }

    @Override
    public void setUndoableEditListener(UndoableEditListener uel) {
        if (this._uel != null) {
            this.getEditor().getDocument().removeUndoableEditListener(this._uel);
        }
        this._uel = uel;
        if (this._uel != null) {
            this.getEditor().getDocument().addUndoableEditListener(this._uel);
        }
    }

    protected void addDocumentListener() {
        AbstractDocument doc = (AbstractDocument)this.getEditor().getDocument();
        if (doc != null) {
            doc.addDocumentListener(this.getDocHandler());
        }
    }

    @Override
    public String getText() {
        return this.getEditor().getText();
    }

    @Override
    public IType getParsedClass() {
        IScriptPartId scriptPart = this.getScriptPart();
        return scriptPart == null ? null : scriptPart.getContainingType();
    }

    void dismissCompletionPopup() {
        if (this._completionPopup != null) {
            this._completionPopup.setVisible(false);
            this._completionPopup = null;
        }
    }

    public JPopupMenu getCompletionPopup() {
        return this._completionPopup;
    }

    public void setCompletionPopup(JPopupMenu completionPopup) {
        this._completionPopup = completionPopup;
    }

    public boolean isCompletionPopupShowing() {
        return this._completionPopup != null && this._completionPopup.isShowing();
    }

    public void displayGotoLinePopup() {
        this.dismissCompletionPopup();
        StringPopup popup = new StringPopup("", "Line number:", this.getEditor());
        popup.addNodeChangeListener(e -> {
            try {
                int iLine = Integer.parseInt(e.getSource().toString());
                if (iLine > 0) {
                    this.gotoLine(iLine);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.getEditor().requestFocus();
            EditorUtilities.fixSwingFocusBugWhenPopupCloses(this);
            this.getEditor().repaint();
        });
        popup.show(this, 0, 0);
        EditorUtilities.centerWindowInFrame(popup, EditorUtilities.getWindow());
    }

    public void gotoLine(int iLine) {
        this.gotoLine(iLine, 0);
    }

    public void gotoLine(int iLine, int iColumn) {
        Element root = this.getEditor().getDocument().getRootElements()[0];
        int n = iLine = root.getElementCount() < iLine ? root.getElementCount() : iLine;
        if (iLine < 1) {
            JOptionPane.showMessageDialog(LabFrame.instance(), "Invalide line number: " + iLine, "Gosu Lab", 0);
            return;
        }
        Element line = root.getElement(iLine - 1);
        this.gotoOffset(line.getStartOffset() + iColumn);
    }

    public void gotoOffset(int offset) {
        int length = this.getEditor().getDocument().getLength();
        if (offset > length) {
            offset = length - 1;
        }
        if (offset < 0) {
            offset = 0;
        }
        this.getEditor().setCaretPosition(offset);
    }

    public void duplicate() {
        DocumentFilter documentFilter = this.getDocument().getDocumentFilter();
        if (documentFilter == null || ((SimpleDocumentFilter)documentFilter).acceptEdit("")) {
            CompoundEdit undoAtom = this._undoMgr.getUndoAtom();
            if (undoAtom != null && ((CompoundEdit)undoAtom).getPresentationName().equals("Text Change")) {
                this._undoMgr.endUndoAtom();
            }
            undoAtom = this.getUndoManager().beginUndoAtom("Duplicate Line");
            try {
                this._duplicate();
            }
            finally {
                this.getUndoManager().endUndoAtom(undoAtom);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _duplicate() {
        EditorHostTextPane editor = this.getEditor();
        String selectedText = editor.getSelectedText();
        if (GosuStringUtil.isEmpty((String)selectedText)) {
            String currentText = ((JTextComponent)editor).getText();
            int initialCaretPosition = editor.getCaretPosition();
            int lineStart = TextComponentUtil.getLineStart(((JTextComponent)editor).getText(), initialCaretPosition);
            int lineEnd = TextComponentUtil.getLineEnd(((JTextComponent)editor).getText(), initialCaretPosition);
            try {
                this.recordCaretPositionForUndo();
                String insertedLine = "\n" + currentText.substring(lineStart, lineEnd);
                editor.getDocument().insertString(lineEnd, insertedLine, null);
                if (initialCaretPosition >= lineEnd) return;
                ((JTextComponent)editor).setCaretPosition(editor.getCaretPosition() + insertedLine.length());
                this.recordCaretPositionForUndo();
                return;
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            int initialSelectionEnd = editor.getSelectionEnd();
            editor.getDocument().insertString(initialSelectionEnd, selectedText, null);
            editor.getCaret().setDot(initialSelectionEnd);
            editor.getCaret().moveDot(initialSelectionEnd + selectedText.length());
            this.recordCaretPositionForUndo();
            return;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void recordCaretPositionForUndo() throws BadLocationException {
        EditorHostTextPane editor = this.getEditor();
        editor.getDocument().insertString(editor.getCaretPosition(), "8", null);
        editor.getDocument().remove(editor.getCaretPosition() - 1, 1);
    }

    public void delete() {
        TextComponentUtil.expandSelectionIfNeeded(this.getEditor());
        this.getEditor().replaceSelection("");
    }

    public String getExpandedSelection() {
        TextComponentUtil.expandSelectionIfNeeded(this.getEditor());
        return this.getEditor().getSelectedText();
    }

    void deleteWord() {
        CompoundEdit atom = this.getUndoManager().beginUndoAtom("Delete Word");
        try {
            if (!GosuStringUtil.isEmpty((String)this.getEditor().getSelectedText())) {
                this.delete();
            } else {
                try {
                    TextComponentUtil.deleteWordAtCaret(this.getEditor());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.getUndoManager().endUndoAtom(atom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteWordForwards() {
        CompoundEdit atom = this.getUndoManager().beginUndoAtom("Delete Word");
        try {
            if (!GosuStringUtil.isEmpty((String)this.getEditor().getSelectedText())) {
                this.delete();
            } else {
                int start = this.getEditor().getCaretPosition();
                this.jumpRight();
                int end = this.getEditor().getCaretPosition();
                this.getEditor().select(start, end);
                this.getEditor().replaceSelection("");
            }
        }
        finally {
            this.getUndoManager().endUndoAtom(atom);
        }
    }

    void deleteLine() {
        CompoundEdit atom = this.getUndoManager().beginUndoAtom("Delete Line");
        try {
            this.recordCaretPositionForUndo();
            TextComponentUtil.selectLineAtCaret(this.getEditor());
            this.getEditor().replaceSelection("");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.getUndoManager().endUndoAtom(atom);
        }
    }

    void unindent() {
        CompoundEdit atom = this.getUndoManager().beginUndoAtom("Unindent");
        try {
            try {
                TextComponentUtil.unindentLineAtCaret(this.getEditor());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        finally {
            this.getUndoManager().endUndoAtom(atom);
        }
    }

    public void joinLines() {
        DocumentFilter documentFilter = this.getDocument().getDocumentFilter();
        if (documentFilter == null || ((SimpleDocumentFilter)documentFilter).acceptEdit("")) {
            CompoundEdit undoAtom = this.getUndoManager().beginUndoAtom("Join Lines");
            try {
                this._joinLines();
            }
            finally {
                this.getUndoManager().endUndoAtom(undoAtom);
            }
        }
    }

    private void _joinLines() {
        block6: {
            try {
                EditorHostTextPane editor = this.getEditor();
                Document document = editor.getDocument();
                int start = editor.getSelectionStart();
                int end = editor.getSelectionEnd();
                if (start == end) {
                    for (int i = editor.getCaret().getDot(); i < document.getLength(); ++i) {
                        if (!document.getText(i, 1).equals("\n")) continue;
                        document.remove(i, 1);
                        this.swallowSpaces(document, i);
                        break block6;
                    }
                    break block6;
                }
                while (start < end) {
                    if (document.getText(start, 1).equals("\n")) {
                        document.remove(start, 1);
                        --end;
                        int spacesRemoved = this.swallowSpaces(document, start);
                        end -= spacesRemoved;
                        start -= spacesRemoved;
                        continue;
                    }
                    ++start;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private int swallowSpaces(Document document, int i) throws BadLocationException {
        int removedChars = 0;
        while (i < document.getLength() && document.getText(i, 1).equals(" ")) {
            document.remove(i, 1);
            ++removedChars;
        }
        if (!document.getText(i, 1).equals(".") && !document.getText(i, 1).equals("#")) {
            document.insertString(i, " ", null);
            --removedChars;
        }
        return removedChars;
    }

    void jumpRight() {
        TextComponentUtil.jumpRight(this.getEditor());
    }

    public void centerView() {
        try {
            Point caretPos = this.getEditor().modelToView(this.getEditor().getCaretPosition()).getLocation();
            Dimension size = this.getScroller().getBounds().getSize();
            this.getEditor().scrollRectToVisible(new Rectangle(caretPos.x, caretPos.y - size.height / 2, 0, size.height));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void highlightLocations(List<SearchLocation> locations) {
        this.setHighlightMode(HighlightMode.USAGES);
        for (SearchLocation loc : locations) {
            try {
                this.getEditor().getHighlighter().addHighlight(loc._iOffset, loc._iOffset + loc._iLength, LabHighlighter.TEXT);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    @Override
    public void gotoNextUsageHighlight() {
        if (this.isCompletionPopupShowing()) {
            return;
        }
        EditorHostTextPane editor = this.getEditor();
        int caretPosition = editor.getCaretPosition();
        Highlighter.Highlight[] highlights = editor.getHighlighter().getHighlights();
        Arrays.sort(highlights, (o1, o2) -> o1.getStartOffset() - o2.getStartOffset());
        int i = -1;
        do {
            ++i;
            while (i < highlights.length && highlights[i].getStartOffset() <= caretPosition) {
                ++i;
            }
        } while (i < highlights.length && !(highlights[i].getPainter() instanceof LabHighlighter));
        if (i == highlights.length) {
            i = 0;
        }
        ((JTextComponent)editor).setCaretPosition(highlights[i].getEndOffset());
        editor.moveCaretPosition(highlights[i].getStartOffset());
    }

    @Override
    public void gotoPrevUsageHighlight() {
        if (this.isCompletionPopupShowing()) {
            return;
        }
        EditorHostTextPane editor = this.getEditor();
        int caretPosition = editor.getCaretPosition();
        Highlighter.Highlight[] highlights = editor.getHighlighter().getHighlights();
        Arrays.sort(highlights, (o1, o2) -> o2.getStartOffset() - o1.getStartOffset());
        int i = -1;
        do {
            ++i;
            while (i < highlights.length && highlights[i].getStartOffset() >= caretPosition) {
                ++i;
            }
        } while (i < highlights.length && !(highlights[i].getPainter() instanceof LabHighlighter));
        if (i == highlights.length) {
            i = 0;
        }
        ((JTextComponent)editor).setCaretPosition(highlights[i].getEndOffset());
        editor.moveCaretPosition(highlights[i].getStartOffset());
    }

    @Override
    public void removeAllHighlights() {
        if (this.isCompletionPopupShowing()) {
            return;
        }
        EditorHostTextPane editor = this.getEditor();
        this.removeHightlights();
        ((JTextComponent)editor).setCaretPosition(editor.getCaretPosition());
        this.hideMiscPopups();
        this.getFeedbackPanel().repaint();
    }

    private void removeHightlights() {
        Highlighter highlighter = this.getEditor().getHighlighter();
        for (Highlighter.Highlight highlight : highlighter.getHighlights()) {
            highlighter.removeHighlight(highlight);
        }
    }

    protected HighlightMode getHighlightMode() {
        return this._highlightMode;
    }

    protected void setHighlightMode(HighlightMode mode) {
        this._highlightMode = mode;
    }

    protected void hideMiscPopups() {
        EditorUtilities.hideToolTip(this.getEditor());
    }

    @Override
    public void clipCut(Clipboard clipboard) {
        this.getUndoManager().beginUndoAtom("Cut");
        try {
            this.clipCopy(clipboard);
            this.delete();
        }
        finally {
            this.getUndoManager().endUndoAtom();
        }
    }

    @Override
    public void clipCopy(Clipboard clipboard) {
        try {
            Transferable contents = this.getClipCopyContents();
            if (contents == null) {
                return;
            }
            clipboard.setContents(contents, null);
        }
        catch (Exception e) {
            EditorUtilities.handleUncaughtException(e);
        }
    }

    @Override
    public void clipPaste(Clipboard clipboard, boolean asGosu) {
        Transferable t = clipboard.getContents(this);
        if (t == null) {
            return;
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String strContents = (String)t.getTransferData(DataFlavor.stringFlavor);
                if (asGosu && "".equals(strContents = JavaToGosu.convertString(strContents, new int[0]))) {
                    JOptionPane.showMessageDialog(this.getEditor(), "The copied Java code has errors, only valid Java 8 code can be transformed", "Paste Java as Gosu", 0);
                    return;
                }
                this.getEditor().replaceSelection(strContents);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Transferable getClipCopyContents() {
        StringSelection contents = null;
        String strSelection = this.getExpandedSelection();
        if (strSelection != null && strSelection.length() > 0) {
            contents = new StringSelection(strSelection);
        }
        return contents;
    }

    void handleEnter() {
        CompoundEdit undoAtom = this.getUndoManager().beginUndoAtom("New Line");
        try {
            this._handleEnter();
        }
        finally {
            this.getUndoManager().endUndoAtom(undoAtom);
            undoAtom = this.getUndoManager().getUndoAtom();
            if (undoAtom != null && undoAtom.getPresentationName().equals("Text Change")) {
                this.getUndoManager().endUndoAtom();
            }
        }
    }

    void _handleEnter() {
        this.revalidate();
        Element root = this.getEditor().getDocument().getRootElements()[0];
        int index = root.getElementIndex(this.getEditor().getCaretPosition() - 1);
        Element line = root.getElement(index);
        int iStart = line.getStartOffset();
        int iEnd = line.getEndOffset();
        try {
            char c;
            String strLine = line.getDocument().getText(iStart, iEnd - iStart);
            if (strLine.trim().endsWith("{") && this.handleOpenBrace(strLine)) {
                return;
            }
            StringBuilder strbIndent = new StringBuilder();
            for (int iIndent = 0; iIndent < strLine.length() && ((c = strLine.charAt(iIndent)) == ' ' || c == '\t'); ++iIndent) {
                strbIndent.append(c);
            }
            if (strbIndent.length() > 0) {
                this.getEditor().replaceSelection(strbIndent.toString());
            }
            this.indentIfOpenBracePrecedes(strLine);
            this.fixCloseBraceIfNecessary(strLine);
            if (strLine.trim().startsWith("/**")) {
                this.getEditor().replaceSelection(" * ");
                int caretPos = this.getEditor().getCaretPosition();
                this.getEditor().replaceSelection("\n" + strbIndent.toString() + " */");
                this.getEditor().setCaretPosition(caretPos);
            } else {
                boolean isJavadoc = false;
                while (strLine.trim().startsWith("*") && !strLine.contains("*/")) {
                    if (--index < 0) continue;
                    line = root.getElement(index);
                    iStart = line.getStartOffset();
                    iEnd = line.getEndOffset();
                    strLine = line.getDocument().getText(iStart, iEnd - iStart);
                    if (!strLine.trim().startsWith("/**")) continue;
                    isJavadoc = true;
                    break;
                }
                if (isJavadoc) {
                    this.getEditor().replaceSelection("* ");
                }
            }
        }
        catch (Exception ex) {
            EditorUtilities.handleUncaughtException(ex);
        }
    }

    private boolean handleOpenBrace(String strLine) {
        int caretPos = this.getEditor().getCaretPosition() - 1;
        String text = this.getEditor().getText();
        while (text.charAt(caretPos) != '{') {
            --caretPos;
        }
        ISourceCodeTokenizer tokenizer = GosuShop.createSourceCodeTokenizer((CharSequence)text);
        while (tokenizer.getCurrentToken().getTokenStart() < caretPos) {
            tokenizer.nextToken();
        }
        IToken startToken = tokenizer.getCurrentToken();
        if (startToken == null) {
            return false;
        }
        tokenizer.nextToken();
        IToken endToken = IParserPart.eatBlock((char)'{', (char)'}', (boolean)false, (ISourceCodeTokenizer)tokenizer);
        String trimLine = strLine.trim();
        int lineColumn = strLine.indexOf(trimLine) + 1;
        if (endToken == null || endToken.getTokenColumn() != lineColumn) {
            IToken tard = startToken;
            EventQueue.invokeLater(() -> {
                try {
                    String fromOpenBrace = this.getEditor().getDocument().getText(tard.getTokenStart(), this.getEditor().getDocument().getLength() - tard.getTokenStart());
                    int newLineOffset = fromOpenBrace.indexOf("\n") + 1;
                    String spaces = String.join((CharSequence)"", Collections.nCopies(lineColumn - 1, " "));
                    String emptyLine = spaces + "  ";
                    String closeBraceLine = "\n" + spaces + "}";
                    this.getEditor().getDocument().insertString(tard.getTokenStart() + newLineOffset, emptyLine + closeBraceLine, null);
                    EventQueue.invokeLater(() -> this.getEditor().setCaretPosition(tard.getTokenStart() + newLineOffset + emptyLine.length()));
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
            });
            return true;
        }
        return false;
    }

    private void fixCloseBraceIfNecessary(String previousLine) throws BadLocationException {
        String strLine;
        Element root = this.getEditor().getDocument().getRootElements()[0];
        int iStart = this.getEditor().getCaretPosition();
        Element line = root.getElement(root.getElementIndex(iStart));
        int iEnd = line.getEndOffset();
        if (iStart < this.getEditor().getDocument().getLength() && (strLine = line.getDocument().getText(iStart, iEnd - iStart)).trim().startsWith("}")) {
            int offset = strLine.indexOf(125);
            boolean previousLineWasOpenBrace = previousLine.trim().endsWith("{");
            if (previousLineWasOpenBrace) {
                this.getEditor().getDocument().insertString(iStart, "\n", null);
                ++offset;
            }
            this.parseAndWaitForParser();
            this.getEditor().setCaretPosition(iStart + offset);
            this._handleBraceRightNow(this.getEditor().getCaretPosition(), false);
            if (previousLineWasOpenBrace) {
                this.getEditor().setCaretPosition(iStart);
            }
        }
    }

    void handleBackspace() {
        int caretPosition = this.getEditor().getCaretPosition();
        try {
            if (caretPosition > 0 && (this.getEditor().getText(caretPosition - 1, 1).equals(".") || this.getEditor().getText(caretPosition - 1, 1).equals("#"))) {
                this.dismissCompletionPopup();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void indentIfOpenBracePrecedes(String strLine) {
        if ((strLine = strLine.trim()).length() > 0 && strLine.charAt(strLine.length() - 1) == '{') {
            this.getEditor().replaceSelection(this.getIndentWhitespace());
        }
    }

    private String getIndentWhitespace() {
        return GosuStringUtil.repeat((String)" ", (int)2);
    }

    void handleBulkComment() {
        CompoundEdit undoAtom = this.getUndoManager().beginUndoAtom("Comment");
        try {
            this._handleBulkComment();
        }
        finally {
            this.getUndoManager().endUndoAtom(undoAtom);
        }
    }

    void _handleBulkComment() {
        this.revalidate();
        int iSelectionStart = this.getEditor().getSelectionStart();
        int iSelectionEnd = this.getEditor().getSelectionEnd();
        Element root = this.getEditor().getDocument().getRootElements()[0];
        int iStartIndex = root.getElementIndex(iSelectionStart);
        int iEndIndex = root.getElementIndex(iSelectionEnd);
        if (iStartIndex != iEndIndex && root.getElement(iEndIndex).getStartOffset() == iSelectionEnd) {
            iEndIndex = root.getElementIndex(--iSelectionEnd);
        }
        try {
            String strLine;
            int iEnd;
            int iStart;
            Element line;
            int i;
            boolean bHasLineWithoutLeadingComment = false;
            for (i = iStartIndex; i <= iEndIndex; ++i) {
                line = root.getElement(i);
                iStart = line.getStartOffset();
                iEnd = line.getEndOffset();
                strLine = this.getEditor().getText(iStart, iEnd - iStart);
                String strLineTrimmed = strLine.trim();
                if (strLineTrimmed.length() <= 0 || strLineTrimmed.startsWith("//")) continue;
                bHasLineWithoutLeadingComment = true;
                break;
            }
            for (i = iStartIndex; i <= iEndIndex; ++i) {
                line = root.getElement(i);
                iStart = line.getStartOffset();
                iEnd = line.getEndOffset();
                strLine = this.getEditor().getText(iStart, iEnd - iStart);
                if (bHasLineWithoutLeadingComment) {
                    strLine = this.getLineCommentDelimiter() + strLine;
                } else {
                    int iCommentIndex = strLine.indexOf("//");
                    if (iCommentIndex >= 0) {
                        strLine = strLine.substring(0, iCommentIndex) + strLine.substring(iCommentIndex + 2);
                    }
                }
                iEnd = line.getEndOffset();
                this.getEditor().select(iStart, iEnd);
                this.getEditor().replaceSelection(strLine);
                iSelectionEnd = this.getEditor().getSelectionEnd();
            }
            this.getEditor().select(iSelectionStart, iSelectionEnd);
        }
        catch (Exception ex) {
            EditorUtilities.handleUncaughtException(ex);
        }
    }

    void handleBraceRight() {
        int caretPosition = this.getEditor().getCaretPosition();
        EventQueue.invokeLater(() -> EditorHost.postTaskInParserThread(() -> EventQueue.invokeLater(() -> this.handleBraceRightNow(caretPosition))));
    }

    private void handleBraceRightNow(int caretPosition) {
        CompoundEdit undoAtom = this.getUndoManager().beginUndoAtom("Right Brace");
        try {
            this._handleBraceRightNow(caretPosition, true);
        }
        finally {
            this.getUndoManager().endUndoAtom(undoAtom);
        }
    }

    private void _handleBraceRightNow(int caretPosition, boolean wasBraceTyped) {
        Document doc = this.getEditor().getDocument();
        Element root = doc.getRootElements()[0];
        Element line = root.getElement(root.getElementIndex(caretPosition));
        int iBraceLineStart = line.getStartOffset();
        int iBraceLineEnd = line.getEndOffset();
        try {
            char c;
            String strLine = line.getDocument().getText(iBraceLineStart, Math.min(iBraceLineEnd, doc.getLength()) - iBraceLineStart);
            iBraceLineEnd = strLine.endsWith("\n") ? iBraceLineEnd - 1 : iBraceLineEnd;
            strLine = strLine.trim();
            if (strLine.length() > 1) {
                return;
            }
            int iOffset = this.getOffsetOfDeepestStatementLocationAtPos(caretPosition, true);
            if (iOffset < 0) {
                return;
            }
            line = root.getElement(root.getElementIndex(iOffset));
            int iStmtLineStart = line.getStartOffset();
            int iStmtLineEnd = line.getEndOffset();
            strLine = line.getDocument().getText(iStmtLineStart, iStmtLineEnd - iStmtLineStart);
            StringBuilder strbIndent = new StringBuilder();
            for (int iIndent = 0; iIndent < strLine.length() && ((c = strLine.charAt(iIndent)) == ' ' || c == '\t'); ++iIndent) {
                strbIndent.append(c);
            }
            String newText = strbIndent.toString() + '}';
            this.getEditor().select(iBraceLineStart, iBraceLineEnd);
            this.getEditor().replaceSelection(newText);
            if (this.getEditor().getCaretPosition() != caretPosition) {
                this.getEditor().setCaretPosition(iBraceLineStart + strbIndent.length() + (wasBraceTyped ? 1 : 0));
            }
            this.revalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void parse() {
        this.parse(false);
    }

    protected void parse(boolean forceCodeCompletion) {
        EditorHost.postTaskInParserThread(this.getParseTask(forceCodeCompletion));
    }

    public static void postTaskInParserThread(Runnable task) {
        TaskQueue tq = TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE);
        tq.postTask(task);
    }

    public static TaskQueue getParserTaskQueue() {
        return TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE);
    }

    public boolean isParserSuspended() {
        return this._bParserSuspended;
    }

    public void setParserSuspended(boolean bParserSuspended) {
        this._bParserSuspended = bParserSuspended;
    }

    private ParseTask getParseTask(boolean forceCodeCompletion) {
        return new ParseTask(this.getEditor().getText(), forceCodeCompletion, true);
    }

    public static boolean areAnyParserTasksPending() {
        TaskQueue tq = TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE);
        List<Runnable> tasks = tq.getTasks();
        for (Runnable task1 : tasks) {
            Runnable task = task1;
            if (!(task instanceof ParseTask)) continue;
            return true;
        }
        return false;
    }

    protected boolean areMoreThanOneParserTasksPendingForThisEditor() {
        TaskQueue tq = TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE);
        int iCount = 0;
        List<Runnable> tasks = tq.getTasks();
        for (Runnable task1 : tasks) {
            Runnable task = task1;
            if (!(task instanceof ParseTask) || ((ParseTask)task).getEditor() != this) continue;
            if (iCount > 0) {
                return true;
            }
            ++iCount;
        }
        return false;
    }

    protected boolean areMoreThanOneParserTasksGoingToUpdateContainingType() {
        TaskQueue tq = TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE);
        int iCount = 0;
        List<Runnable> tasks = tq.getTasks();
        for (Runnable task1 : tasks) {
            EditorHost otherEditor;
            Runnable task = task1;
            if (!(task instanceof ParseTask) || (otherEditor = ((ParseTask)task).getEditor()) != this && (otherEditor.getScriptPart() == null || this.getScriptPart() == null || this.getScriptPart().getContainingType() != otherEditor.getScriptPart().getContainingType())) continue;
            if (iCount > 0) {
                return true;
            }
            ++iCount;
        }
        return false;
    }

    public boolean isCompleteCode() {
        return this._bCompleteCode;
    }

    public void setCompleteCode(boolean bCompleteCode) {
        this._bCompleteCode = bCompleteCode;
    }

    public void handleDot() {
        this.runIfNoKeyPressedInMillis(COMPLETION_DELAY, () -> {
            this.setCompleteCode(true);
            this.parse(true);
        });
    }

    public void handleColon() {
        this.runIfNoKeyPressedInMillis(COMPLETION_DELAY, () -> {
            this.setCompleteCode(true);
            this.parse(true);
        });
    }

    public void handleCompleteCode() {
        this.setCompleteCode(true);
        EditorHost.postTaskInParserThread(() -> {
            if (this.isCompleteCode()) {
                try {
                    ISymbolTable atCursor = this.getSymbolTableAtCursor();
                    SwingUtilities.invokeLater(() -> {
                        if (this.isCompleteCode()) {
                            try {
                                this.handleDot(atCursor);
                            }
                            finally {
                                this.setCompleteCode(false);
                            }
                        }
                    });
                }
                catch (RuntimeException e) {
                    this.setCompleteCode(false);
                    throw e;
                }
            }
        });
    }

    protected abstract void handleDot(ISymbolTable var1);

    public abstract ISymbolTable getSymbolTableAtCursor();

    void runIfNoKeyPressedInMillis(long lMillis, Runnable task) {
        final boolean[] bKeyPressed = new boolean[]{false};
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                bKeyPressed[0] = true;
            }
        };
        this.getEditor().addKeyListener(keyListener);
        Timer timer = _timerPool.requestTimer((int)lMillis, e -> {
            this.getEditor().removeKeyListener(keyListener);
            if (!bKeyPressed[0]) {
                EditorUtilities.invokeInDispatchThread(task);
            }
            --this._iTimerCount;
        });
        timer.setRepeats(false);
        ++this._iTimerCount;
        timer.start();
    }

    public static void waitOnParserThread() {
        TaskQueue queue = TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE);
        queue.postTaskAndWait(() -> {});
    }

    public int getTimerCount() {
        return this._iTimerCount;
    }

    public static void waitForIntellisenseTimers() {
        _timerPool.waitForAllTimersToFinish();
    }

    public boolean isAltDown() {
        return this._bAltDown;
    }

    private static class TimerPool {
        List<Object> _activeTimers = new ArrayList<Object>();

        private TimerPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Timer requestTimer(int millis, final ActionListener action) {
            TimerPool timerPool = this;
            synchronized (timerPool) {
                final Object timerToken = new Object();
                Timer timer = new Timer(millis, new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            action.actionPerformed(e);
                        }
                        finally {
                            TimerPool timerPool = this;
                            synchronized (timerPool) {
                                _activeTimers.remove(timerToken);
                                this.notify();
                            }
                        }
                    }
                });
                this._activeTimers.add(timerToken);
                return timer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForAllTimersToFinish() {
            TimerPool timerPool = this;
            synchronized (timerPool) {
                while (!this._activeTimers.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public static class LabHighlighter
    implements Highlighter.HighlightPainter {
        public static final LabHighlighter TEXT = new LabHighlighter(Scheme.active().usageReadHighlightColor());
        public static LabHighlighter USAGE = new LabHighlighter(Scheme.active().usageReadHighlightColor());
        private Highlighter.HighlightPainter _delegate;

        public LabHighlighter(Color color) {
            this._delegate = new DefaultHighlighter.DefaultHighlightPainter(color);
        }

        @Override
        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
            this._delegate.paint(g, p0, p1, bounds, c);
        }
    }

    class EditorKeyHandler
    extends KeyAdapter {
        EditorKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            EditorHost.this.setCompleteCode(false);
            EditorHost.this._bAltDown = (e.getModifiers() & 8) > 0;
            if (e.getKeyChar() == '\n' && e.getModifiers() == 0) {
                EditorHost.this._bEnterPressedConsumed = e.isConsumed() || EditorHost.this.isCompletionPopupShowing();
            } else if (e.getKeyChar() == ' ' && e.isControlDown()) {
                if (!EditorHost.this.isCompletionPopupShowing()) {
                    EditorHost.this.handleCompleteCode();
                    e.consume();
                }
            } else if (e.getKeyCode() == 8 || e.getKeyChar() == '\b') {
                EditorHost.this.handleBackspace();
                if (e.getModifiers() == 1) {
                    EditorHost.this.getEditor().dispatchEvent(new KeyEvent((Component)e.getSource(), e.getID(), e.getWhen(), 0, e.getKeyCode(), e.getKeyChar(), e.getKeyLocation()));
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            boolean consumed = e.isConsumed();
            if (consumed || !EditorHost.this.getEditor().isEditable()) {
                return;
            }
            char keyChar = e.getKeyChar();
            int modifiers = e.getModifiers();
            this.postProcessKeystroke(consumed, keyChar, modifiers);
        }

        private void postProcessKeystroke(boolean consumed, char keyChar, int modifiers) {
            if (keyChar == '.') {
                EditorHost.this.handleDot();
            }
            if (keyChar == ':') {
                EditorHost.this.handleColon();
            }
            if (keyChar == '#') {
                EditorHost.this.handleDot();
            } else if (keyChar == '\n' && modifiers == 0) {
                if (!(consumed || EditorHost.this._bEnterPressedConsumed || EditorHost.this.isCompletionPopupShowing())) {
                    EditorHost.this.handleEnter();
                }
            } else if (keyChar == '}' && !consumed && !EditorHost.this.isCompletionPopupShowing()) {
                EditorHost.this.handleBraceRight();
            }
        }
    }

    class ParseTask
    implements Runnable {
        private String _strSource;
        private boolean _forceCodeCompletion;
        private boolean _changed;

        public ParseTask(String strSource, boolean forceCodeCompletion, boolean changed) {
            this._strSource = strSource;
            this._forceCodeCompletion = forceCodeCompletion;
            this._changed = changed;
        }

        public EditorHost getEditor() {
            return EditorHost.this;
        }

        @Override
        public void run() {
            if (!this.getEditor().isShowing()) {
                return;
            }
            if (!EditorHost.this.areMoreThanOneParserTasksPendingForThisEditor() || this._forceCodeCompletion) {
                TypeSystem.lock();
                try {
                    EditorHost.this.parse(this._strSource, this._forceCodeCompletion, this._changed);
                }
                finally {
                    TypeSystem.unlock();
                    if (this._forceCodeCompletion) {
                        EditorHost.this.setCompleteCode(false);
                    }
                }
            }
        }
    }

    protected static enum HighlightMode {
        SEARCH,
        USAGES;

    }
}

