/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractTreeCellRenderer;
import editor.FileTree;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.util.PathUtil;
import java.nio.file.Path;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;

public class FileTreeCellRenderer
extends AbstractTreeCellRenderer<FileTree> {
    public FileTreeCellRenderer(JTree tree) {
        super(tree);
    }

    @Override
    public void configure() {
        FileTree node = (FileTree)this.getNode();
        if (node == null) {
            return;
        }
        this.setBorder(new EmptyBorder(0, 3, 0, 3));
        TypeSystem.lock();
        try {
            if (node.isDirectory() || !node.isFile() && PathUtil.getName((Path)node.getFileOrDir()).indexOf(46) < 0) {
                this.setText(node.getName());
            } else {
                IType type = node.getType();
                this.setText(type == null ? node.getName() : type.getRelativeName());
            }
            this.setIcon(node.getIcon());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            TypeSystem.unlock();
        }
    }
}

