/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.PackageType;
import gw.fs.IDirectory;
import gw.lang.reflect.IType;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.TypeLoaderBase;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.module.IModule;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PackageTypeLoader
extends TypeLoaderBase {
    private static final Map<IModule, PackageTypeLoader> INSTANCE_BY_MODULE = new HashMap<IModule, PackageTypeLoader>();
    private final Map<CharSequence, PackageType> _mapTypeByName = new ConcurrentHashMap<CharSequence, PackageType>();

    public static PackageTypeLoader instance() {
        IModule module = TypeSystem.getCurrentModule();
        PackageTypeLoader instance = INSTANCE_BY_MODULE.get(module);
        if (instance == null) {
            instance = new PackageTypeLoader();
            INSTANCE_BY_MODULE.put(module, instance);
        }
        return instance;
    }

    private PackageTypeLoader() {
    }

    public PackageType getType(String fullyQualifiedName) {
        return this.get(fullyQualifiedName);
    }

    public boolean hasNamespace(String s) {
        return false;
    }

    public Set<String> computeTypeNames() {
        return null;
    }

    public IType getIntrinsicTypeByFullName(String fullyQualifiedName, boolean bSkipVerify) throws ClassNotFoundException {
        return this.get(fullyQualifiedName, bSkipVerify);
    }

    public Set<? extends CharSequence> getAllNamespaces() {
        return Collections.emptySet();
    }

    private void clearCaches() {
        this._mapTypeByName.clear();
    }

    public List<String> getHandledPrefixes() {
        return Collections.emptyList();
    }

    public boolean handlesNonPrefixLoads() {
        return false;
    }

    public void refreshedNamespace(String s, IDirectory iDirectory, RefreshKind refreshKind) {
        this.clearCaches();
    }

    private PackageType get(String strPackage) {
        return this.get(strPackage, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageType get(String strPackage, boolean bSkipVerify) {
        PackageType type = this._mapTypeByName.get(strPackage);
        if (type == null) {
            Map<CharSequence, PackageType> map = this._mapTypeByName;
            synchronized (map) {
                type = this._mapTypeByName.get(strPackage);
                if (type == null) {
                    type = this.define(strPackage, bSkipVerify);
                }
            }
        }
        return type;
    }

    private PackageType define(String strPackage, boolean bSkipVerify) {
        if (bSkipVerify || this.packageExists(strPackage)) {
            PackageType type = new PackageType(strPackage);
            this._mapTypeByName.put(strPackage, type);
            return type;
        }
        return null;
    }

    private boolean packageExists(String strName) {
        String strNamePlusDot = strName + '.';
        for (CharSequence cs : TypeSystem.getAllTypeNames()) {
            String strType = cs.toString();
            if (!strType.startsWith(strNamePlusDot)) continue;
            return true;
        }
        return false;
    }
}

