/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.Scheme;
import editor.util.EditorUtilities;
import editor.util.HTMLEscapeUtil;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IHasArguments;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.expressions.IArgumentListClause;
import gw.lang.parser.expressions.IBeanMethodCallExpression;
import gw.lang.parser.expressions.IMethodCallExpression;
import gw.lang.parser.expressions.INewExpression;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.gs.IGosuClass;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;

public class ParameterInfoPopup
extends JPopupMenu {
    private JPanel _pane = new JPanel();
    private GosuEditor _editor;
    private EditorKeyListener _editorKeyListener;
    private CaretListener _editorCaretListener;
    private UndoableEditListener _docListener;
    private JPanel _labelContainer;
    private int _iArgPosition;

    public ParameterInfoPopup(GosuEditor editor) {
        this._editor = editor;
        this.initLayout();
    }

    protected void initLayout() {
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        GridBagLayout gridBag = new GridBagLayout();
        this._pane.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        IParameterInfo[][] paramInfoLists = this.getParamInfoLists(this._editor.getFunctionCallAtCaret());
        if (paramInfoLists == null || paramInfoLists.length == 0) {
            EventQueue.invokeLater(() -> this.setVisible(false));
            return;
        }
        this._labelContainer = new JPanel();
        this._labelContainer.setLayout(new BoxLayout(this._labelContainer, 1));
        this._labelContainer.setBackground(Scheme.active().getTooltipBackground());
        this._labelContainer.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        int iArgIndex = this.getArgIndex();
        for (int i = 0; i < paramInfoLists.length; ++i) {
            IParameterInfo[] paramInfoList = paramInfoLists[i];
            this.addParameterListLabel(paramInfoList, this._labelContainer, i != paramInfoLists.length - 1, iArgIndex);
        }
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this._pane.add((Component)this._labelContainer, c);
        this.add(this._pane);
        if (this._editor != null) {
            this._editorKeyListener = new EditorKeyListener();
            this._editorCaretListener = new EditorCaretListener();
            this._docListener = e -> this.filterDisplay();
        }
    }

    private int getArgIndex() {
        IParseTree deepest = this._editor.getDeepestLocationAtCaret();
        if (deepest == null) {
            return -1;
        }
        while (deepest != null && !(deepest.getParsedElement() instanceof IArgumentListClause)) {
            if ((deepest = deepest.getParent()) != null) continue;
            return -1;
        }
        IArgumentListClause argListClause = (IArgumentListClause)deepest.getParsedElement();
        int iCaretPos = this._editor.getEditor().getCaretPosition();
        List args = argListClause.getLocation().getChildren();
        for (int i = 0; i < args.size(); ++i) {
            IParseTree location = (IParseTree)args.get(i);
            if (location.getExtent() + 1 < iCaretPos) continue;
            return i;
        }
        return args.size() - 1;
    }

    private void addParameterListLabel(IParameterInfo[] paramList, JPanel container, boolean bBorder, int iArgIndex) {
        JLabel label = new JLabel();
        label.setBorder(bBorder ? BorderFactory.createMatteBorder(0, 0, 1, 0, Scheme.active().getControlShadow()) : null);
        label.setFont(this._editor.getEditor().getFont());
        label.setText(this.makeParamInfoContent(paramList, iArgIndex));
        container.add(label);
    }

    private String makeParamInfoContent(IParameterInfo[] paramInfoList, int iArgIndex) {
        String strContent = "<html>";
        if (paramInfoList == null || paramInfoList.length == 0) {
            strContent = strContent + "&lt;no parameters&gt;";
        } else {
            boolean bUseName = false;
            for (int j = 0; j < paramInfoList.length; ++j) {
                IParameterInfo pi = paramInfoList[j];
                if (pi.getName() == null || pi.getName().length() <= 0 || pi.getName().equalsIgnoreCase(pi.getFeatureType().getRelativeName())) continue;
                bUseName = true;
                break;
            }
            Color typeClr = Scheme.active().getCodeTypeLiteral();
            String typeColor = String.format("#%02x%02x%02x", typeClr.getRed(), typeClr.getGreen(), typeClr.getBlue());
            for (int j = 0; j < paramInfoList.length; ++j) {
                IParameterInfo pi = paramInfoList[j];
                boolean bBlock = pi.getFeatureType() instanceof IBlockType;
                String strTypeName = bBlock ? pi.getName() + ((IBlockType)pi.getFeatureType()).getRelativeNameSansBlock() : pi.getFeatureType().getRelativeName();
                strTypeName = HTMLEscapeUtil.escape(strTypeName);
                if (!bBlock && bUseName && pi.getName() != null && pi.getName().length() > 0) {
                    strContent = j == iArgIndex ? strContent + "<b><i>" + pi.getName() + "</i></b>: " : strContent + "<i>" + pi.getName() + "</i>: ";
                }
                strContent = j == iArgIndex ? strContent + "<font color= " + typeColor + "><b>" + strTypeName + "</b></font>" : strContent + strTypeName;
                if (j >= paramInfoList.length - 1) continue;
                strContent = strContent + ", ";
            }
        }
        return strContent + "</html>";
    }

    private IParameterInfo[][] getParamInfoLists(IParsedElement parsedElement) {
        if (parsedElement instanceof IHasArguments) {
            INewExpression newExpression;
            int iArgPosition = ((IHasArguments)parsedElement).getArgPosition();
            if (this._editor.getEditor().getCaretPosition() < iArgPosition) {
                return this.getParamInfoLists(this._editor.findFunction(parsedElement.getParent()));
            }
            this._iArgPosition = iArgPosition;
            ArrayList<IParameterInfo[]> paramInfoLists = new ArrayList<IParameterInfo[]>();
            if (parsedElement instanceof IMethodCallExpression) {
                IFunctionSymbol fs = ((IMethodCallExpression)parsedElement).getFunctionSymbol();
                if (fs != null) {
                    IFunctionType funcType = (IFunctionType)fs.getType();
                    if (funcType.getMethodInfo() != null) {
                        return new IParameterInfo[][]{funcType.getMethodInfo().getParameters()};
                    }
                    if (funcType.getScriptPart() != null && funcType.getScriptPart().getContainingType() instanceof IGosuClass) {
                        IGosuClass type = (IGosuClass)funcType.getScriptPart().getContainingType();
                        String strName = funcType.getName();
                        MethodList methods = type.getTypeInfo().getMethods((IType)type);
                        for (Object method : methods) {
                            IMethodInfo mi = (IMethodInfo)method;
                            if (!mi.getDisplayName().equalsIgnoreCase(strName) || !mi.isVisible(this._editor.getScriptabilityModifier())) continue;
                            paramInfoLists.add(mi.getParameters());
                        }
                    } else {
                        Map dfsDecls = this._editor.getParser().getDfsDecls();
                        List dynamicFunctionSymbols = (List)dfsDecls.get(funcType.getName());
                        if (dynamicFunctionSymbols != null) {
                            for (IFunctionSymbol symbol : dynamicFunctionSymbols) {
                                assert (symbol instanceof IDynamicFunctionSymbol);
                                IDynamicFunctionSymbol dfs = (IDynamicFunctionSymbol)symbol;
                                IParameterInfo[] params = new IParameterInfo[dfs.getArgs().size()];
                                for (int i = 0; i < dfs.getArgs().size(); ++i) {
                                    ISymbol arg = (ISymbol)dfs.getArgs().get(i);
                                    params[i] = new ParameterInfoStub(arg);
                                }
                                paramInfoLists.add(params);
                            }
                        }
                    }
                }
                return (IParameterInfo[][])paramInfoLists.toArray((T[])new IParameterInfo[0][0]);
            }
            if (parsedElement instanceof IBeanMethodCallExpression) {
                IMethodInfo mi = ((IBeanMethodCallExpression)parsedElement).getMethodDescriptor();
                if (mi != null) {
                    String strName = mi.getDisplayName();
                    IType type = mi.getOwnersType();
                    MethodList methods = type.getTypeInfo().getMethods();
                    for (int i = 0; i < methods.size(); ++i) {
                        mi = (IMethodInfo)methods.get(i);
                        if (!mi.getDisplayName().equalsIgnoreCase(strName) || !mi.isVisible(this._editor.getScriptabilityModifier())) continue;
                        paramInfoLists.add(mi.getParameters());
                    }
                }
                return (IParameterInfo[][])paramInfoLists.toArray((T[])new IParameterInfo[0][0]);
            }
            if (parsedElement instanceof INewExpression && !((newExpression = (INewExpression)parsedElement).getType() instanceof IErrorType)) {
                IType type = newExpression.getType();
                List ctors = type.getTypeInfo().getConstructors();
                for (IConstructorInfo ctor : ctors) {
                    if (!ctor.isVisible(this._editor.getScriptabilityModifier())) continue;
                    paramInfoLists.add(ctor.getParameters());
                }
                return (IParameterInfo[][])paramInfoLists.toArray((T[])new IParameterInfo[0][0]);
            }
        }
        return null;
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        if (this._editor == null) {
            return;
        }
        if (bVisible) {
            this.registerListeners();
        } else {
            this.unregisterListeners();
            this._editor.getEditor().requestFocus();
        }
    }

    void registerListeners() {
        this.unregisterListeners();
        this._editor.getEditor().addKeyListener(this._editorKeyListener);
        this._editor.getEditor().addCaretListener(this._editorCaretListener);
        this._editor.getEditor().getDocument().addUndoableEditListener(this._docListener);
    }

    void unregisterListeners() {
        this._editor.getEditor().getDocument().removeUndoableEditListener(this._docListener);
        this._editor.getEditor().removeCaretListener(this._editorCaretListener);
        this._editor.getEditor().removeKeyListener(this._editorKeyListener);
    }

    void filterDisplay() {
        this.filterDisplay(null);
    }

    void filterDisplay(String strWholePath) {
    }

    public void display(int iPosition) throws BadLocationException {
        Rectangle rcCaretBounds = this._editor.getEditor().modelToView(iPosition);
        if (rcCaretBounds == null) {
            this.show(null, 0, 0);
        } else {
            FontMetrics fm = this.getToolkit().getFontMetrics(this._editor.getFont());
            int iLineHeight = fm.getHeight();
            this.show(this._editor.getEditor(), rcCaretBounds.x, rcCaretBounds.y + iLineHeight);
        }
    }

    public static ParameterInfoPopup invoke(GosuEditor gsEditor, int iPosition) {
        try {
            ParameterInfoPopup parameterInfoPopup = new ParameterInfoPopup(gsEditor);
            parameterInfoPopup.display(iPosition);
            EventQueue.invokeLater(() -> {
                gsEditor.getEditor().requestFocus();
                gsEditor.getEditor().repaint();
            });
            return parameterInfoPopup;
        }
        catch (BadLocationException e) {
            EditorUtilities.handleUncaughtException(e);
            return null;
        }
    }

    String getLabelAt(int index) {
        return ((JLabel)this._labelContainer.getComponent(index)).getText();
    }

    private static class ParameterInfoStub
    implements IParameterInfo {
        private final ISymbol _arg;

        public ParameterInfoStub(ISymbol arg) {
            this._arg = arg;
        }

        public String getName() {
            return this._arg.getName();
        }

        public IType getFeatureType() {
            return this._arg.getType();
        }

        public IFeatureInfo getContainer() {
            return null;
        }

        public IType getOwnersType() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getDescription() {
            return null;
        }
    }

    class EditorKeyListener
    extends KeyAdapter {
        EditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                ParameterInfoPopup.this.setVisible(false);
                EventQueue.invokeLater(() -> ParameterInfoPopup.invoke(ParameterInfoPopup.this._editor, ParameterInfoPopup.this._editor.getEditor().getCaretPosition()));
            } else if (e.getKeyCode() == 27) {
                ParameterInfoPopup.this.setVisible(false);
                e.consume();
            }
        }
    }

    class EditorCaretListener
    implements CaretListener {
        EditorCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            EventQueue.invokeLater(() -> ParameterInfoPopup.invoke(ParameterInfoPopup.this._editor, ParameterInfoPopup.this._editor.getEditor().getCaretPosition()));
        }
    }
}

