/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.util.IProgressCallback;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.ITypeLoaderListener;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.module.ITypeLoaderStack;
import gw.util.concurrent.LocklessLazyVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeNameCache
implements ITypeLoaderListener {
    private LocklessLazyVar<ITypeLoaderStack> _moduleTypeLoader = new LocklessLazyVar<ITypeLoaderStack>(){

        protected ITypeLoaderStack init() {
            ITypeLoaderStack moduleLoader = TypeSystem.getGlobalModule().getModuleTypeLoader();
            TypeSystem.addTypeLoaderListenerAsWeakRef((ITypeLoaderListener)TypeNameCache.this);
            return moduleLoader;
        }
    };
    private volatile Set<String> _allTypeNames;
    private Set<String> _allNamespaces;
    private Map<String, List<String>> _relativeTypeNameToFullyQualifiedTypeNames;
    private volatile boolean _caching;

    public Set<String> getAllTypeNames(IProgressCallback progress) {
        return this.getAllTypeNamesCache(progress);
    }

    public List<String> getFullyQualifiedClassNameFromRelativeName(String relativeClassName) {
        return this.getRelativeTypeNamesCache().get(relativeClassName);
    }

    public Set<String> getAllNamespaces() {
        this.getAllTypeNamesCache(null);
        return this._allNamespaces;
    }

    public void refreshedTypes(RefreshRequest request) {
        switch (request.kind) {
            case CREATION: 
            case DELETION: {
                this.clearCaches();
            }
        }
    }

    public void refreshed() {
        this.clearCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getAllTypeNamesCache(IProgressCallback progress) {
        if (this._allTypeNames != null) {
            return this._allTypeNames;
        }
        TypeSystem.lock();
        try {
            if (this._allTypeNames != null) {
                Set<String> set = this._allTypeNames;
                return set;
            }
            this._caching = true;
            HashSet<String> names = new HashSet<String>();
            List loaders = ((ITypeLoaderStack)this._moduleTypeLoader.get()).getTypeLoaderStack();
            if (progress != null) {
                progress.setLength(loaders.size());
            }
            for (int i = loaders.size() - 1; i >= 0; --i) {
                if (progress != null) {
                    progress.updateProgress(progress.getProgress() + 1, "ProgressFeedback.Loading_type_names", new String[0]);
                }
                ITypeLoader loader = (ITypeLoader)loaders.get(i);
                for (CharSequence typeName : loader.getAllTypeNames()) {
                    names.add((String)typeName);
                    this.addRelativeToFullTypeMapping((String)typeName);
                }
            }
            if (this._relativeTypeNameToFullyQualifiedTypeNames != null) {
                for (List<String> fullNames : this._relativeTypeNameToFullyQualifiedTypeNames.values()) {
                    ((ArrayList)fullNames).trimToSize();
                }
            }
            Set<String> set = this._allTypeNames = names;
            return set;
        }
        finally {
            TypeSystem.unlock();
            this._caching = false;
        }
    }

    private Map<String, List<String>> getRelativeTypeNamesCache() {
        this.getAllTypeNamesCache(null);
        return this._relativeTypeNameToFullyQualifiedTypeNames;
    }

    private void addRelativeToFullTypeMapping(String fullyQualifiedTypeName) {
        List<String> fullNames;
        if (this._relativeTypeNameToFullyQualifiedTypeNames == null) {
            this._relativeTypeNameToFullyQualifiedTypeNames = new HashMap<String, List<String>>();
        }
        if (this._allNamespaces == null) {
            this._allNamespaces = new HashSet<String>();
        }
        int index = this.lastIndexOf(fullyQualifiedTypeName, '.');
        String relativeName = (String)fullyQualifiedTypeName.subSequence(index + 1, fullyQualifiedTypeName.length());
        if (index > 0) {
            String namespace = (String)fullyQualifiedTypeName.subSequence(0, index);
            this._allNamespaces.add(namespace);
        }
        if ((fullNames = this._relativeTypeNameToFullyQualifiedTypeNames.get(relativeName)) == null) {
            fullNames = new ArrayList<String>(1);
            this._relativeTypeNameToFullyQualifiedTypeNames.put(relativeName, fullNames);
        }
        fullNames.add(fullyQualifiedTypeName);
    }

    private int lastIndexOf(String fullyQualifiedTypeName, char c) {
        int index = fullyQualifiedTypeName.length();
        boolean found = false;
        while (index > 0 && !found) {
            found = fullyQualifiedTypeName.charAt(--index) == c;
        }
        if (!found) {
            index = -1;
        }
        return index;
    }

    public void clearCaches() {
        if (this._caching) {
            return;
        }
        TypeSystem.lock();
        try {
            if (this._caching) {
                return;
            }
            this._allTypeNames = null;
            this._allNamespaces = null;
            this._relativeTypeNameToFullyQualifiedTypeNames = null;
        }
        finally {
            TypeSystem.unlock();
        }
    }
}

