/*
 * Decompiled with CFR 0.152.
 */
package editor.actions;

import editor.actions.GenericAction;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class UpdateNotifier {
    static UpdateNotifier _singleton;
    private WeakHashMap<JComponent, Object> _mapItems = new WeakHashMap();

    private UpdateNotifier() {
    }

    public static UpdateNotifier instance() {
        if (_singleton == null) {
            _singleton = new UpdateNotifier();
        }
        return _singleton;
    }

    public void addActionComponent(JComponent item) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Whoops!  UpdateNotifier is restricted to the EventDispatch thread.");
        }
        this._mapItems.put(item, null);
    }

    public void removeActionComponent(JComponent item) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Whoops!  UpdateNotifier is restricted to the EventDispatch thread.");
        }
        this._mapItems.remove(item);
    }

    public void notifyActionComponentsNow() {
        this._notifyActionComponentsNow();
    }

    protected void _notifyActionComponentsNow() {
        for (JComponent item : this._mapItems.keySet()) {
            AbstractButton tb;
            Action action = (Action)item.getClientProperty("_genericAction");
            if (action == null) {
                if (item instanceof AbstractButton) {
                    action = ((AbstractButton)item).getAction();
                }
                if (action == null) continue;
            }
            boolean bEnabled = action.isEnabled();
            if (item.isEnabled() != bEnabled) {
                item.setEnabled(bEnabled);
            }
            if (!(action instanceof GenericAction)) continue;
            boolean bSelected = ((GenericAction)action).isSelected();
            if (item instanceof JToggleButton) {
                tb = (JToggleButton)item;
                if (tb.isSelected() == bSelected) continue;
                tb.setSelected(bSelected);
                continue;
            }
            if (!(item instanceof JCheckBoxMenuItem) || ((JCheckBoxMenuItem)(tb = (JCheckBoxMenuItem)item)).getState() == bSelected) continue;
            ((JCheckBoxMenuItem)tb).setState(bSelected);
        }
    }
}

