/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.AbstractTree;
import editor.EditorHost;
import editor.FileTree;
import editor.ITreeNode;
import editor.LabFrame;
import editor.NodeKind;
import editor.search.SearchLocation;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.TypeSystem;
import gw.util.GosuEscapeUtil;
import gw.util.PathUtil;
import gw.util.StreamUtil;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Path;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.text.AbstractDocument;

public class SearchTree
extends AbstractTree<SearchTree, SearchTreeNode> {
    public SearchTree(JTree tree) {
        super(tree);
    }

    public SearchTree(NodeKind kind, SearchTreeNode node) {
        super(kind, node);
    }

    public SearchTree(String text, NodeKind kind, SearchTreeNode node) {
        super(text, kind, node);
    }

    @Override
    public String getText() {
        String text = super.getText();
        if (text != null) {
            if (text.contains("$count")) {
                text = text.replace("$count", String.valueOf(this.getCount()));
            }
            return text;
        }
        SearchTreeNode node = (SearchTreeNode)this.getNode();
        SearchLocation location = node.getLocation();
        text = location == null ? this.makeDirectoryText(node) : this.makOccuranceText(location);
        this._text = text;
        return this.getText();
    }

    private String makeDirectoryText(SearchTreeNode node) {
        return "<html>" + node.getFile().getName() + "&nbsp;<font style=italic color=#808080>($count&nbsp;occurrences)</font>&nbsp;";
    }

    private String makOccuranceText(SearchLocation loc) {
        String text;
        int col = loc._iColumn - 1;
        try {
            if (loc._iLength <= 200) {
                String textLine = this.getTextLine(loc);
                String beforeMatch = GosuEscapeUtil.escapeForHTML((String)textLine.substring(0, col));
                String match = GosuEscapeUtil.escapeForHTML((String)textLine.substring(col, col + loc._iLength));
                String afterMatch = GosuEscapeUtil.escapeForHTML((String)textLine.substring(col + loc._iLength));
                text = "<html><font style=italic color=#808080>(" + loc._iLine + ":&nbsp;" + (col + 1) + ")</font> " + beforeMatch + "<b>" + match + "</b>" + afterMatch;
            } else {
                text = "<html><font style=italic color=#808080>(" + loc._iLine + ":&nbsp;" + (col + 1) + ")</font>";
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            text = "<html><font style=italic color=#808080>(" + loc._iLine + ":&nbsp;" + (col + 1) + ")</font> <b>Invalid</b>";
        }
        return text;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTextLine(SearchLocation loc) {
        try (BufferedReader reader = PathUtil.createReader((Path)((SearchTreeNode)this.getNode()).getFile().getFileOrDir());){
            int line = 0;
            while (line < loc._iLine) {
                String textLine = reader.readLine();
                if (line == loc._iLine - 1) {
                    String string = textLine;
                    return string;
                }
                ++line;
            }
            return "";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Icon getIcon() {
        return this.findIcon();
    }

    private Icon findIcon() {
        SearchTreeNode node = (SearchTreeNode)this.getNode();
        if (node != null && node.getLocation() == null) {
            FileTree file = node.getFile();
            return file == null ? null : file.getIcon();
        }
        return null;
    }

    public static SearchTreeNode empty() {
        return new SearchTreeNode(){

            @Override
            public boolean hasTarget() {
                return false;
            }
        };
    }

    public int getCount() {
        SearchTreeNode node = (SearchTreeNode)this.getNode();
        if (node.isFile()) {
            return this.getChildCount();
        }
        int count = 0;
        for (SearchTree child : this.getChildren()) {
            count += child.getCount();
        }
        return count;
    }

    public void replace(String pattern) {
        int count = this.getChildCount();
        if (count > 0) {
            SearchTreeNode node = (SearchTreeNode)this.getNode();
            if (node != null && node.isFile()) {
                this.makeChanges(content -> {
                    for (int i = count - 1; i >= 0; --i) {
                        SearchTree child = (SearchTree)this.getChildAt(i);
                        SearchLocation loc = ((SearchTreeNode)child.getNode()).getLocation();
                        content.replace(loc._iOffset, loc._iOffset + loc._iLength, pattern);
                        this.maybeUpdateDoc(loc._iOffset, loc._iLength, pattern);
                    }
                });
            } else {
                for (SearchTree child : this.getChildren()) {
                    child.replace(pattern);
                }
            }
        } else if (this.getNode() != null && ((SearchTreeNode)this.getNode()).getLocation() != null) {
            ((SearchTree)this.getParent()).makeChanges(content -> {
                SearchLocation loc = ((SearchTreeNode)this.getNode()).getLocation();
                content.replace(loc._iOffset, loc._iOffset + loc._iLength, pattern);
                this.maybeUpdateDoc(loc._iOffset, loc._iLength, pattern);
            });
        }
    }

    private void maybeUpdateDoc(int iOffset, int iLength, String pattern) {
        Path file = ((SearchTreeNode)this.getNode()).getFile().getFileOrDir();
        EditorHost editor = LabFrame.instance().getGosuPanel().findTab(file);
        if (editor == null) {
            return;
        }
        editor.getUndoManager().beginUndoAtom("Replace");
        try {
            ((AbstractDocument)editor.getEditor().getDocument()).replace(iOffset, iLength, pattern, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            editor.getUndoManager().endUndoAtom();
        }
        IType type = ((SearchTreeNode)this.getNode()).getFile().getType();
        if (type != null) {
            TypeSystem.refresh((ITypeRef)((ITypeRef)type));
        }
    }

    private void makeChanges(Consumer<StringBuilder> contentChanger) {
        StringBuilder content;
        Throwable throwable;
        SearchTreeNode node = (SearchTreeNode)this.getNode();
        try {
            throwable = null;
            try (BufferedReader reader = PathUtil.createReader((Path)node.getFile().getFileOrDir());){
                content = new StringBuilder(StreamUtil.getContent((Reader)reader).replace("\r\n", "\n"));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        contentChanger.accept(content);
        node.getFile().setLastModified();
        try {
            throwable = null;
            try (BufferedWriter writer = PathUtil.createWriter((Path)node.getFile().getFileOrDir());){
                writer.write(content.toString());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class SearchTreeNode
    implements ITreeNode {
        private final FileTree _file;
        private SearchLocation _loc;
        private Boolean _bFile;

        private SearchTreeNode() {
            this._file = null;
            this._loc = null;
        }

        public SearchTreeNode(FileTree file, SearchLocation loc) {
            this._file = file;
            this._loc = loc;
        }

        @Override
        public boolean hasTarget() {
            return this.getLocation() != null;
        }

        @Override
        public void jumpToTarget() {
            if (this.getLocation() == null) {
                return;
            }
            LabFrame.instance().getGosuPanel().openFile(this._file.getFileOrDir(), true);
            EventQueue.invokeLater(() -> LabFrame.instance().getGosuPanel().getCurrentEditor().gotoOffset(this.getLocation()._iOffset));
        }

        public FileTree getFile() {
            return this._file;
        }

        public SearchLocation getLocation() {
            return this._loc;
        }

        public boolean isFile() {
            return this._bFile == null ? (this._bFile = Boolean.valueOf(this._file != null && this._file.isFile())) : this._bFile;
        }
    }
}

