/*
 * Decompiled with CFR 0.152.
 */
package editor.settings;

import editor.LabFrame;
import editor.settings.CompilerSettingsParameters;
import editor.util.DirectoryEditor;
import gw.util.PathUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

class CompilerSettingsPanel
extends JPanel {
    private final CompilerSettingsParameters _params;
    private final Consumer<CompilerSettingsParameters> _changeListener;
    private JRadioButton _rbSourceBased;
    private JRadioButton _rbClassFileBased;
    private JLabel _labelOutputPath;
    private DirectoryEditor _editOutputPath;

    CompilerSettingsPanel(CompilerSettingsParameters params, Consumer<CompilerSettingsParameters> changeListener) {
        super(new BorderLayout());
        this._params = params;
        this._changeListener = changeListener;
        this.configUi();
    }

    private void configUi() {
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        int iY = 0;
        ButtonGroup group = new ButtonGroup();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 10, 0);
        this._rbSourceBased = new JRadioButton("<html><b>Dynamic</b>.&nbsp;Incrementally&nbsp;compile&nbsp;and&nbsp;load&nbsp;classes&nbsp;direct&nbsp;from&nbsp;source&nbsp;at&nbsp;runtime.");
        this._rbSourceBased.addItemListener(e -> {
            this._params.setSourceBased(this._rbSourceBased.isSelected());
            this._labelOutputPath.setEnabled(!this._rbSourceBased.isSelected());
            this._editOutputPath.setEnabled(!this._rbSourceBased.isSelected());
        });
        group.add(this._rbSourceBased);
        configPanel.add((Component)this._rbSourceBased, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 0);
        this._rbClassFileBased = new JRadioButton("<html><b>Static</b>.&nbsp;Compile&nbsp;classes&nbsp;to&nbsp;disk&nbsp;during&nbsp;development.");
        this._rbClassFileBased.addItemListener(e -> {
            this._params.setSourceBased(this._rbSourceBased.isSelected());
            this._labelOutputPath.setEnabled(!this._rbSourceBased.isSelected());
            this._editOutputPath.setEnabled(!this._rbSourceBased.isSelected());
        });
        group.add(this._rbClassFileBased);
        configPanel.add((Component)this._rbClassFileBased, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 10, 10);
        this._labelOutputPath = new JLabel("Compiler output:");
        configPanel.add((Component)this._labelOutputPath, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 10, 0);
        this._editOutputPath = new DirectoryEditor(this._labelOutputPath.getText(), PathUtil.getAbsolutePathName((Path)PathUtil.create((String)this._params.getOutputPath(), (String[])new String[0])), LabFrame::instance);
        this._editOutputPath.getDocument().addDocumentListener(new DocChangeHandler(this::validateOutputPath, path -> {
            String relativePath = LabFrame.instance().getGosuPanel().getExperiment().makeExperimentRelativePathWithSlashes(PathUtil.create((String)path, (String[])new String[0]));
            path = relativePath == null ? path : relativePath;
            this._params.setOuputPath((String)path);
        }));
        configPanel.add((Component)this._editOutputPath, c);
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        configPanel.add((Component)new JPanel(), c);
        this.add((Component)configPanel, "Center");
        EventQueue.invokeLater(() -> {
            this._rbSourceBased.setSelected(this._params.isSourceBased());
            this._rbClassFileBased.setSelected(!this._params.isSourceBased());
        });
    }

    private String validateOutputPath(String text) {
        if (text == null || text.isEmpty()) {
            return "ERROR";
        }
        return null;
    }

    private class DocChangeHandler
    implements DocumentListener {
        Function<String, String> _validator;
        Consumer<String> _consumer;

        public DocChangeHandler(Function<String, String> validator, Consumer<String> consumer) {
            this._validator = validator;
            this._consumer = consumer;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            Document doc = e.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                String error = this._validator.apply(text);
                if (error != null) {
                    // empty if block
                }
                this._consumer.accept(text);
                CompilerSettingsPanel.this._changeListener.accept(CompilerSettingsPanel.this._params);
            }
            catch (BadLocationException e1) {
                throw new RuntimeException(e1);
            }
        }
    }
}

