/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.Scheme;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.border.Border;

public class ContainerMoverSizer
extends JComponent {
    public static final int PART_NONE = 0;
    public static final int PART_BORDER = 1;
    public static final int PART_BOTTOM = 2;
    public static final int PART_BOTTOMLEFT = 3;
    public static final int PART_BOTTOMRIGHT = 4;
    public static final int PART_CAPTION = 5;
    public static final int PART_CLIENT = 6;
    public static final int PART_HSCROLL = 9;
    public static final int PART_LEFT = 10;
    public static final int PART_MENU = 11;
    public static final int PART_NOWHERE = 12;
    public static final int PART_REDUCE = 13;
    public static final int PART_RIGHT = 14;
    public static final int PART_SYSMENU = 15;
    public static final int PART_TOP = 16;
    public static final int PART_TOPLEFT = 17;
    public static final int PART_TOPRIGHT = 18;
    public static final int PART_TRANSPARENT = 19;
    public static final int PART_VSCROLL = 20;
    public static final int PART_ZOOM = 21;
    public static final int PART_CLOSEBTN = 22;
    public static final int PART_MINBTN = 23;
    public static final int PART_MAXBTN = 24;

    public ContainerMoverSizer(Border border) {
        this.setBorder(border);
        this.configUi();
    }

    public Rectangle getClientRect() {
        Insets borderInsets = this.getBorderInsets();
        return new Rectangle(borderInsets.left, borderInsets.top, this.getWidth() - (borderInsets.left + borderInsets.right), this.getHeight() - (borderInsets.top + borderInsets.bottom) + 1);
    }

    public Insets getBorderInsets() {
        return this.getBorder() == null ? new Insets(3, 3, 3, 3) : this.getBorder().getBorderInsets(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void configUi() {
        this.setOpaque(true);
        this.setBackground(Scheme.active().getControl());
        DragController controller = new DragController();
        this.addMouseListener(controller);
        this.addMouseMotionListener(controller);
    }

    public synchronized int hitTest(Point pt) {
        if (pt == null || this.getParent() == null) {
            return 12;
        }
        Point ptPos = this.getLocation();
        ptPos.x += pt.x;
        ptPos.y += pt.y;
        if (this.getParent().getComponentAt(ptPos.x, ptPos.y) != this) {
            return 0;
        }
        if (this.getClientRect().contains(pt)) {
            return 6;
        }
        int iFrameW = this.getWidth();
        int iFrameH = this.getHeight();
        Insets borderInsets = this.getBorderInsets();
        Rectangle rcBorder = new Rectangle(0, 10, borderInsets.left, iFrameH - 20);
        if (rcBorder.contains(pt)) {
            return 10;
        }
        rcBorder.setBounds(10, 0, iFrameW - 20, borderInsets.top);
        if (rcBorder.contains(pt)) {
            return 16;
        }
        rcBorder.setBounds(iFrameW - borderInsets.right, 10, borderInsets.right, iFrameH - 20);
        if (rcBorder.contains(pt)) {
            return 14;
        }
        rcBorder.setBounds(10, iFrameH - borderInsets.bottom, iFrameW - 20, borderInsets.bottom);
        if (rcBorder.contains(pt)) {
            return 2;
        }
        rcBorder.setBounds(0, 0, 10, 10);
        if (rcBorder.contains(pt)) {
            return 17;
        }
        rcBorder.setBounds(iFrameW - 10, 0, 10, 10);
        if (rcBorder.contains(pt)) {
            return 18;
        }
        rcBorder.setBounds(0, iFrameH - 10, 10, 10);
        if (rcBorder.contains(pt)) {
            return 3;
        }
        rcBorder.setBounds(iFrameW - 10, iFrameH - 10, 10, 10);
        if (rcBorder.contains(pt)) {
            return 4;
        }
        return 12;
    }

    private void updateCursor(int iDragPart) {
        Cursor cursor = this.getCursor();
        switch (iDragPart) {
            case 10: {
                if (cursor != null && cursor.getType() == 10) break;
                this.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            case 14: {
                if (cursor != null && cursor.getType() == 11) break;
                this.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case 16: {
                if (cursor != null && cursor.getType() == 8) break;
                this.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case 2: {
                if (cursor != null && cursor.getType() == 9) break;
                this.setCursor(Cursor.getPredefinedCursor(9));
                break;
            }
            case 17: {
                if (cursor != null && cursor.getType() == 6) break;
                this.setCursor(Cursor.getPredefinedCursor(6));
                break;
            }
            case 18: {
                if (cursor != null && cursor.getType() == 7) break;
                this.setCursor(Cursor.getPredefinedCursor(7));
                break;
            }
            case 3: {
                if (cursor != null && cursor.getType() == 4) break;
                this.setCursor(Cursor.getPredefinedCursor(4));
                break;
            }
            case 4: {
                if (cursor != null && cursor.getType() == 5) break;
                this.setCursor(Cursor.getPredefinedCursor(5));
                break;
            }
            default: {
                if (cursor != null && cursor.getType() == 0) break;
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class DragController
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean _bDragging;
        private Point _ptInitialDragLocation;
        private Container _container;
        private int _iDragPart;

        private DragController() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.setInitialDragLocation(e.getPoint());
            this.setDragging(true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.isDragging()) {
                return;
            }
            this.setDragging(false);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.move(e.getPoint());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.setDragPart(ContainerMoverSizer.this.hitTest(e.getPoint()));
            ContainerMoverSizer.this.updateCursor(this.getDragPart());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ContainerMoverSizer.this.updateCursor(ContainerMoverSizer.this.hitTest(e.getPoint()));
        }

        public int getDragPart() {
            return this._iDragPart;
        }

        private void setDragPart(int iDragPart) {
            this._iDragPart = iDragPart;
        }

        private void move(Point pt) {
            Container container = this.getContainer();
            int iXDiff = pt.x - this.getInitialDragLocation().x;
            int iYDiff = pt.y - this.getInitialDragLocation().y;
            if (iXDiff == 0 && iYDiff == 0) {
                return;
            }
            Rectangle rcBounds = container.getBounds();
            Rectangle rcOldBounds = new Rectangle(rcBounds);
            switch (this.getDragPart()) {
                case 5: 
                case 6: {
                    rcBounds.x += iXDiff;
                    rcBounds.y += iYDiff;
                    break;
                }
                case 10: {
                    rcBounds.width -= iXDiff;
                    rcBounds.x += iXDiff;
                    break;
                }
                case 14: {
                    rcBounds.width += iXDiff;
                    this.setInitialDragLocation(pt);
                    break;
                }
                case 16: {
                    rcBounds.y += iYDiff;
                    rcBounds.height -= iYDiff;
                    break;
                }
                case 2: {
                    rcBounds.height += iYDiff;
                    this.setInitialDragLocation(pt);
                    break;
                }
                case 17: {
                    rcBounds.height -= iYDiff;
                    rcBounds.y += iYDiff;
                    rcBounds.width -= iXDiff;
                    rcBounds.x += iXDiff;
                    break;
                }
                case 18: {
                    rcBounds.height -= iYDiff;
                    rcBounds.y += iYDiff;
                    rcBounds.width += iXDiff;
                    this.getInitialDragLocation().x = pt.x;
                    break;
                }
                case 3: {
                    rcBounds.width -= iXDiff;
                    rcBounds.x += iXDiff;
                    rcBounds.height += iYDiff;
                    this.getInitialDragLocation().y = pt.y;
                    break;
                }
                case 4: {
                    rcBounds.height += iYDiff;
                    rcBounds.width += iXDiff;
                    this.setInitialDragLocation(pt);
                    break;
                }
                default: {
                    return;
                }
            }
            if (rcBounds.equals(rcOldBounds)) {
                return;
            }
            Dimension sizeMinimum = container.getMinimumSize();
            if (rcBounds.width < sizeMinimum.width || rcBounds.height < sizeMinimum.height) {
                return;
            }
            if (this.getDragPart() == 6 || this.getDragPart() == 5) {
                container.setLocation(rcBounds.x, rcBounds.y);
            } else {
                container.setBounds(rcBounds);
            }
            container.validate();
        }

        private Container getContainer() {
            if (this._container != null) {
                return this._container;
            }
            for (Container p = ContainerMoverSizer.this.getParent(); p != null; p = p.getParent()) {
                if (p.getParent() instanceof JLayeredPane && p.getParent().getWidth() > p.getWidth()) {
                    this._container = p;
                    break;
                }
                if (!(p instanceof Window)) continue;
                this._container = p;
                break;
            }
            return this._container;
        }

        private boolean isDragging() {
            return this._bDragging;
        }

        private void setDragging(boolean bDragging) {
            this._bDragging = bDragging;
        }

        private void setInitialDragLocation(Point ptInitialDragLocation) {
            this._ptInitialDragLocation = ptInitialDragLocation;
        }

        private Point getInitialDragLocation() {
            return this._ptInitialDragLocation;
        }
    }
}

