/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.Scheme;
import editor.util.EditorUtilities;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class ContainerSizer
extends JComponent {
    private static ImageIcon g_grabber;

    public ContainerSizer() {
        this.configUi();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g_grabber.paintIcon(this, g, this.getWidth() - g_grabber.getIconWidth(), this.getHeight() - g_grabber.getIconHeight());
    }

    private void configUi() {
        this.setCursor(Cursor.getPredefinedCursor(5));
        g_grabber = EditorUtilities.loadIcon("images/status_grabber.gif");
        g_grabber.setImage(EditorUtilities.createSystemColorImage(g_grabber.getImage()));
        this.setPreferredSize(new Dimension(g_grabber.getIconWidth(), g_grabber.getIconHeight()));
        this.setOpaque(true);
        this.setBackground(Scheme.active().getControl());
        DragController controller = new DragController();
        this.addMouseListener(controller);
        this.addMouseMotionListener(controller);
    }

    private class DragController
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean _bDragging;
        private Point _ptInitialDragLocation;
        private Container _container;

        private DragController() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.setInitialDragLocation(e.getPoint());
            this.setDragging(true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.isDragging()) {
                return;
            }
            this.setDragging(false);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.resize(e.getPoint());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private void resize(Point pt) {
            Container container = this.getContainer();
            int iNewWidth = container.getWidth() + pt.x - this.getInitialDragLocation().x;
            int iNewHeight = container.getHeight() + pt.y - this.getInitialDragLocation().y;
            container.setSize(iNewWidth, iNewHeight);
            container.validate();
        }

        private Container getContainer() {
            if (this._container != null) {
                return this._container;
            }
            for (Container p = ContainerSizer.this.getParent(); p != null; p = p.getParent()) {
                if (p.getParent() instanceof JLayeredPane && p.getParent().getWidth() > p.getWidth()) {
                    this._container = p;
                    break;
                }
                if (!(p instanceof Window)) continue;
                this._container = p;
                break;
            }
            return this._container;
        }

        private boolean isDragging() {
            return this._bDragging;
        }

        private void setDragging(boolean bDragging) {
            this._bDragging = bDragging;
        }

        private void setInitialDragLocation(Point ptInitialDragLocation) {
            this._ptInitialDragLocation = ptInitialDragLocation;
        }

        private Point getInitialDragLocation() {
            return this._ptInitialDragLocation;
        }
    }
}

