/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.ILineInfoManager;
import editor.Scheme;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;

public class EditorScrollPane
extends JScrollPane {
    private AdviceColumn _adviceColumn;
    private JTextComponent _editor;
    private ILineInfoManager _lineInfoMgr;

    public EditorScrollPane(ILineInfoManager lineInfoMgr, JTextComponent editor, JComponent view, int iVertPolicy, int iHorzPolicy) {
        super(view, iVertPolicy, iHorzPolicy);
        this._lineInfoMgr = lineInfoMgr;
        this._editor = editor;
        this._adviceColumn = new AdviceColumn();
        this.setRowHeaderView(this._adviceColumn);
        this.setBackground(Scheme.active().getControl());
    }

    public EditorScrollPane(ILineInfoManager lineInfoRenderer, JTextComponent editor, JComponent view) {
        this(lineInfoRenderer, editor, view, 20, 30);
    }

    @Override
    public void setViewportBorder(Border border) {
        super.setViewportBorder(border);
        Insets insets = new Insets(0, 0, 0, 0);
        if (border != null) {
            insets = border.getBorderInsets(this);
        }
        if (this._adviceColumn != null) {
            this._adviceColumn.setBorder(new EmptyBorder(new Insets(insets.top, 0, 0, 1)));
        }
    }

    public ILineInfoManager getLineInfoMgr() {
        return this._lineInfoMgr;
    }

    public AdviceColumn getAdviceColumn() {
        return this._adviceColumn;
    }

    public class AdviceColumn
    extends JPanel {
        public AdviceColumn() {
            this.setLayout(null);
            this.setBorder(new EmptyBorder(new Insets(0, 1, 0, 1)));
            this.setBackground(Scheme.active().getControl());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    AdviceColumn.this.handleMouseClicked(e);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    AdviceColumn.this.updateCursor(e);
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = new Dimension();
            dim.height = EditorScrollPane.this._editor.getHeight();
            FontMetrics fm = EditorScrollPane.this._editor.getFontMetrics(EditorScrollPane.this._editor.getFont());
            int iLineHeight = fm.getHeight();
            iLineHeight += this.getLineSpacingAttr(iLineHeight);
            int iLines = this.getHeight() / iLineHeight;
            dim.width = fm.stringWidth(String.valueOf(iLines));
            dim.width = Math.max(dim.width, 16);
            dim.width += this.getLineInfoRequiredWidth();
            Insets borderInsets = this.getBorder().getBorderInsets(this);
            dim.width += borderInsets.left + borderInsets.right;
            return dim;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Scheme.active().getLineNumberColor());
            g.setFont(EditorScrollPane.this._editor.getFont());
            FontMetrics fm = g.getFontMetrics(EditorScrollPane.this._editor.getFont());
            int iLineHeight = fm.getHeight();
            iLineHeight += this.getLineSpacingAttr(iLineHeight);
            int iMargin = ((EditorScrollPane)EditorScrollPane.this)._editor.getMargin().top + this.getLineSpacingAttr(iLineHeight);
            int iLines = this.getHeight() / iLineHeight;
            int borderWidth = this.getBorder().getBorderInsets((Component)this).right;
            Rectangle clipBounds = g.getClipBounds();
            for (int i = 1; i <= iLines; ++i) {
                String strLine = String.valueOf(i);
                int iWidth = fm.stringWidth(strLine);
                int x = this.getWidth() - iWidth - this.getLineInfoRequiredWidth() - borderWidth;
                int y = i * iLineHeight - fm.getDescent() + iMargin;
                if (!this.inClipBounds(clipBounds, y) && !this.inClipBounds(clipBounds, y + iLineHeight)) continue;
                g.drawString(strLine, x, y);
                this.renderLineInfo(g, i, iLineHeight, this.getWidth() - this.getLineInfoRequiredWidth() - borderWidth, (i - 1) * iLineHeight + iMargin);
            }
        }

        private boolean inClipBounds(Rectangle clipBounds, int y) {
            return y >= clipBounds.y && y <= clipBounds.y + clipBounds.height;
        }

        private int getLineSpacingAttr(int iLineHeight) {
            AttributeSet attr;
            Float lineSpacing;
            if (EditorScrollPane.this._editor instanceof JTextPane && (lineSpacing = (Float)(attr = ((JTextPane)EditorScrollPane.this._editor).getParagraphAttributes()).getAttribute(StyleConstants.LineSpacing)) != null) {
                return Math.round(lineSpacing.floatValue() * (float)iLineHeight);
            }
            return 0;
        }

        private int getLineInfoRequiredWidth() {
            if (EditorScrollPane.this._lineInfoMgr != null) {
                return EditorScrollPane.this._lineInfoMgr.getRequiredWidth();
            }
            return 0;
        }

        private void renderLineInfo(Graphics g, int iLine, int iLineHeight, int iX, int iY) {
            if (EditorScrollPane.this._lineInfoMgr == null) {
                return;
            }
            EditorScrollPane.this._lineInfoMgr.render(g, iLine, iLineHeight, iX, iY);
        }

        private void handleMouseClicked(MouseEvent e) {
            EditorScrollPane.this._editor.requestFocus();
            if (EditorScrollPane.this._lineInfoMgr != null) {
                FontMetrics fm = this.getToolkit().getFontMetrics(EditorScrollPane.this._editor.getFont());
                int iLineHeight = fm.getHeight();
                int iLine = (e.getY() - 2) / iLineHeight + 1;
                int iY = e.getY() - (iLine - 1) * iLineHeight;
                int iX = e.getX() - (this.getWidth() - this.getLineInfoRequiredWidth() - this.getBorder().getBorderInsets((Component)this).right);
                EditorScrollPane.this._lineInfoMgr.handleLineClick(e, (e.getY() - 2) / iLineHeight + 1, iX, iY);
                this.repaint();
                EditorScrollPane.this._editor.repaint();
            }
        }

        private void updateCursor(MouseEvent e) {
            FontMetrics fm = this.getToolkit().getFontMetrics(EditorScrollPane.this._editor.getFont());
            int iLineHeight = fm.getHeight();
            if (EditorScrollPane.this._lineInfoMgr != null) {
                this.setCursor(EditorScrollPane.this._lineInfoMgr.getCursor((e.getY() - 2) / iLineHeight + 1));
            }
        }
    }
}

